/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.net.auth;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleResourceNotFoundException;
import org.apache.guacamole.language.TranslatableMessage;
import org.apache.guacamole.net.auth.AbstractActivityLog;
import org.apache.guacamole.net.auth.ActivityLog;

public class FileActivityLog
extends AbstractActivityLog {
    private final File content;

    public FileActivityLog(ActivityLog.Type type, TranslatableMessage description, File content) {
        super(type, description);
        this.content = content;
    }

    @Override
    public long getSize() throws GuacamoleException {
        return this.content.length();
    }

    @Override
    public InputStream getContent() throws GuacamoleException {
        try {
            return new FileInputStream(this.content);
        }
        catch (FileNotFoundException e) {
            throw new GuacamoleResourceNotFoundException("Associated file does not exist or cannot be read.", (Throwable)e);
        }
    }
}

