/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.aliyun.oss;

import com.aliyun.oss.common.auth.CredentialsProvider;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.aliyun.oss.AliyunCredentialsProvider;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystem;
import org.apache.hadoop.security.ProviderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AliyunOSSUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AliyunOSSUtils.class);
    private static LocalDirAllocator directoryAllocator;

    private AliyunOSSUtils() {
    }

    public static int intPositiveOption(Configuration conf, String key, int defVal) {
        int v = conf.getInt(key, defVal);
        if (v <= 0) {
            LOG.warn(key + " is configured to " + v + ", will use default value: " + defVal);
            v = defVal;
        }
        return v;
    }

    public static String getValueWithKey(Configuration conf, String key) throws IOException {
        try {
            char[] pass = conf.getPassword(key);
            if (pass != null) {
                return new String(pass).trim();
            }
            return "";
        }
        catch (IOException ioe) {
            throw new IOException("Cannot find password option " + key, ioe);
        }
    }

    public static long calculatePartSize(long contentLength, long minPartSize) {
        long tmpPartSize = contentLength / 10000L + 1L;
        return Math.max(minPartSize, tmpPartSize);
    }

    public static CredentialsProvider getCredentialsProvider(URI uri, Configuration conf) throws IOException {
        AliyunCredentialsProvider credentials;
        String className = conf.getTrimmed("fs.oss.credentials.provider");
        if (StringUtils.isEmpty((CharSequence)className)) {
            Configuration newConf = ProviderUtils.excludeIncompatibleCredentialProviders((Configuration)conf, AliyunOSSFileSystem.class);
            credentials = new AliyunCredentialsProvider(newConf);
        } else {
            try {
                LOG.debug("Credential provider class is:" + className);
                Class<?> credClass = Class.forName(className);
                try {
                    credentials = (CredentialsProvider)credClass.getDeclaredConstructor(URI.class, Configuration.class).newInstance(uri, conf);
                }
                catch (NoSuchMethodException | SecurityException e) {
                    credentials = (CredentialsProvider)credClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (ClassNotFoundException e) {
                throw new IOException(className + " not found.", e);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new IOException(String.format("%s constructor exception.  A class specified in %s must provide an accessible constructor accepting URI and Configuration, or an accessible default constructor.", className, "fs.oss.credentials.provider"), e);
            }
            catch (IllegalArgumentException | ReflectiveOperationException e) {
                throw new IOException(className + " instantiation exception.", e);
            }
        }
        return credentials;
    }

    public static String maybeAddTrailingSlash(String key) {
        if (StringUtils.isNotEmpty((CharSequence)key) && !key.endsWith("/")) {
            return key + '/';
        }
        return key;
    }

    public static boolean objectRepresentsDirectory(String name, long size) {
        return StringUtils.isNotEmpty((CharSequence)name) && name.endsWith("/") && size == 0L;
    }

    public static File createTmpFileForWrite(String path, long size, Configuration conf) throws IOException {
        if (conf.get("fs.oss.buffer.dir") == null) {
            conf.set("fs.oss.buffer.dir", conf.get("hadoop.tmp.dir") + "/oss");
        }
        if (directoryAllocator == null) {
            directoryAllocator = new LocalDirAllocator("fs.oss.buffer.dir");
        }
        return directoryAllocator.createTmpFileForWrite(path, size, conf);
    }

    static int intOption(Configuration conf, String key, int defVal, int min) {
        int v = conf.getInt(key, defVal);
        Preconditions.checkArgument((v >= min ? 1 : 0) != 0, (Object)String.format("Value of %s: %d is below the minimum value %d", key, v, min));
        LOG.debug("Value of {} is {}", (Object)key, (Object)v);
        return v;
    }

    static long longOption(Configuration conf, String key, long defVal, long min) {
        long v = conf.getLong(key, defVal);
        Preconditions.checkArgument((v >= min ? 1 : 0) != 0, (Object)String.format("Value of %s: %d is below the minimum value %d", key, v, min));
        LOG.debug("Value of {} is {}", (Object)key, (Object)v);
        return v;
    }

    public static long getMultipartSizeProperty(Configuration conf, String property, long defVal) {
        long partSize = conf.getLong(property, defVal);
        if (partSize < 102400L) {
            LOG.warn("{} must be at least 100 KB; configured value is {}", (Object)property, (Object)partSize);
            partSize = 102400L;
        } else if (partSize > Integer.MAX_VALUE) {
            LOG.warn("oss: {} capped to ~2.14GB(maximum allowed size with current output mechanism)", (Object)"fs.oss.multipart.upload.size");
            partSize = Integer.MAX_VALUE;
        }
        return partSize;
    }
}

