/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import java.io.IOException;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestKerberosUtil {
    @Test
    public void testGetServerPrincipal() throws IOException {
        String service = "TestKerberosUtil";
        String localHostname = KerberosUtil.getLocalHostName();
        String testHost = "FooBar";
        Assert.assertEquals((String)"When no hostname is sent", (Object)(service + "/" + localHostname.toLowerCase()), (Object)KerberosUtil.getServicePrincipal((String)service, null));
        Assert.assertEquals((String)"When empty hostname is sent", (Object)(service + "/" + localHostname.toLowerCase()), (Object)KerberosUtil.getServicePrincipal((String)service, (String)""));
        Assert.assertEquals((String)"When 0.0.0.0 hostname is sent", (Object)(service + "/" + localHostname.toLowerCase()), (Object)KerberosUtil.getServicePrincipal((String)service, (String)"0.0.0.0"));
        Assert.assertEquals((String)"When uppercase hostname is sent", (Object)(service + "/" + testHost.toLowerCase()), (Object)KerberosUtil.getServicePrincipal((String)service, (String)testHost));
        Assert.assertEquals((String)"When lowercase hostname is sent", (Object)(service + "/" + testHost.toLowerCase()), (Object)KerberosUtil.getServicePrincipal((String)service, (String)testHost.toLowerCase()));
    }
}

