/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.junit.Assert;
import org.junit.Test;

public class TestAuthenticationToken {
    @Test
    public void testAnonymous() {
        Assert.assertNotNull((Object)AuthenticationToken.ANONYMOUS);
        Assert.assertEquals(null, (Object)AuthenticationToken.ANONYMOUS.getUserName());
        Assert.assertEquals(null, (Object)AuthenticationToken.ANONYMOUS.getName());
        Assert.assertEquals(null, (Object)AuthenticationToken.ANONYMOUS.getType());
        Assert.assertEquals((long)-1L, (long)AuthenticationToken.ANONYMOUS.getExpires());
        Assert.assertFalse((boolean)AuthenticationToken.ANONYMOUS.isExpired());
    }

    @Test
    public void testConstructor() throws Exception {
        try {
            new AuthenticationToken(null, "p", "t");
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Throwable ex) {
            Assert.fail();
        }
        try {
            new AuthenticationToken("", "p", "t");
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Throwable ex) {
            Assert.fail();
        }
        try {
            new AuthenticationToken("u", null, "t");
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Throwable ex) {
            Assert.fail();
        }
        try {
            new AuthenticationToken("u", "", "t");
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Throwable ex) {
            Assert.fail();
        }
        try {
            new AuthenticationToken("u", "p", null);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Throwable ex) {
            Assert.fail();
        }
        try {
            new AuthenticationToken("u", "p", "");
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Throwable ex) {
            Assert.fail();
        }
        new AuthenticationToken("u", "p", "t");
    }

    @Test
    public void testGetters() throws Exception {
        long expires = System.currentTimeMillis() + 50L;
        AuthenticationToken token = new AuthenticationToken("u", "p", "t");
        token.setExpires(expires);
        Assert.assertEquals((Object)"u", (Object)token.getUserName());
        Assert.assertEquals((Object)"p", (Object)token.getName());
        Assert.assertEquals((Object)"t", (Object)token.getType());
        Assert.assertEquals((long)expires, (long)token.getExpires());
        Assert.assertFalse((boolean)token.isExpired());
        Thread.sleep(51L);
        Assert.assertTrue((boolean)token.isExpired());
    }

    @Test
    public void testToStringAndParse() throws Exception {
        long expires = System.currentTimeMillis() + 50L;
        AuthenticationToken token = new AuthenticationToken("u", "p", "t");
        token.setExpires(expires);
        String str = token.toString();
        token = AuthenticationToken.parse((String)str);
        Assert.assertEquals((Object)"p", (Object)token.getName());
        Assert.assertEquals((Object)"t", (Object)token.getType());
        Assert.assertEquals((long)expires, (long)token.getExpires());
        Assert.assertFalse((boolean)token.isExpired());
        Thread.sleep(51L);
        Assert.assertTrue((boolean)token.isExpired());
    }

    @Test
    public void testParseInvalid() throws Exception {
        long expires = System.currentTimeMillis() + 50L;
        AuthenticationToken token = new AuthenticationToken("u", "p", "t");
        token.setExpires(expires);
        String str = token.toString();
        str = str.substring(0, str.indexOf("e="));
        try {
            AuthenticationToken.parse((String)str);
            Assert.fail();
        }
        catch (AuthenticationException ex) {
        }
        catch (Exception ex) {
            Assert.fail();
        }
    }
}

