/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.client;

import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.hadoop.minikdc.KerberosSecurityTestcase;
import org.apache.hadoop.security.authentication.KerberosTestUtils;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.AuthenticatorTestCase;
import org.apache.hadoop.security.authentication.client.KerberosAuthenticator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestKerberosAuthenticator
extends KerberosSecurityTestcase {
    private boolean useTomcat = false;

    public TestKerberosAuthenticator(boolean useTomcat) {
        this.useTomcat = useTomcat;
    }

    @Parameterized.Parameters
    public static Collection booleans() {
        return Arrays.asList({false}, {true});
    }

    @Before
    public void setup() throws Exception {
        File keytabFile = new File(KerberosTestUtils.getKeytabFile());
        String clientPrincipal = KerberosTestUtils.getClientPrincipal();
        String serverPrincipal = KerberosTestUtils.getServerPrincipal();
        clientPrincipal = clientPrincipal.substring(0, clientPrincipal.lastIndexOf("@"));
        serverPrincipal = serverPrincipal.substring(0, serverPrincipal.lastIndexOf("@"));
        this.getKdc().createPrincipal(keytabFile, new String[]{clientPrincipal, serverPrincipal});
    }

    private Properties getAuthenticationHandlerConfiguration() {
        Properties props = new Properties();
        props.setProperty("type", "kerberos");
        props.setProperty("kerberos.principal", KerberosTestUtils.getServerPrincipal());
        props.setProperty("kerberos.keytab", KerberosTestUtils.getKeytabFile());
        props.setProperty("kerberos.name.rules", "RULE:[1:$1@$0](.*@" + KerberosTestUtils.getRealm() + ")s/@.*//\n");
        return props;
    }

    @Test(timeout=60000L)
    public void testFallbacktoPseudoAuthenticator() throws Exception {
        AuthenticatorTestCase auth = new AuthenticatorTestCase(this.useTomcat);
        Properties props = new Properties();
        props.setProperty("type", "simple");
        props.setProperty("simple.anonymous.allowed", "false");
        AuthenticatorTestCase.setAuthenticationHandlerConfig((Properties)props);
        auth._testAuthentication((Authenticator)new KerberosAuthenticator(), false);
    }

    @Test(timeout=60000L)
    public void testFallbacktoPseudoAuthenticatorAnonymous() throws Exception {
        AuthenticatorTestCase auth = new AuthenticatorTestCase(this.useTomcat);
        Properties props = new Properties();
        props.setProperty("type", "simple");
        props.setProperty("simple.anonymous.allowed", "true");
        AuthenticatorTestCase.setAuthenticationHandlerConfig((Properties)props);
        auth._testAuthentication((Authenticator)new KerberosAuthenticator(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testNotAuthenticated() throws Exception {
        AuthenticatorTestCase auth = new AuthenticatorTestCase(this.useTomcat);
        AuthenticatorTestCase.setAuthenticationHandlerConfig((Properties)this.getAuthenticationHandlerConfiguration());
        auth.start();
        try {
            URL url = new URL(auth.getBaseURL());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.connect();
            Assert.assertEquals((long)401L, (long)conn.getResponseCode());
            Assert.assertTrue((conn.getHeaderField("WWW-Authenticate") != null ? 1 : 0) != 0);
        }
        finally {
            auth.stop();
        }
    }

    @Test(timeout=60000L)
    public void testAuthentication() throws Exception {
        AuthenticatorTestCase auth = new AuthenticatorTestCase(this.useTomcat);
        AuthenticatorTestCase.setAuthenticationHandlerConfig((Properties)this.getAuthenticationHandlerConfiguration());
        KerberosTestUtils.doAsClient((Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Test(timeout=60000L)
    public void testAuthenticationPost() throws Exception {
        AuthenticatorTestCase auth = new AuthenticatorTestCase(this.useTomcat);
        AuthenticatorTestCase.setAuthenticationHandlerConfig((Properties)this.getAuthenticationHandlerConfiguration());
        KerberosTestUtils.doAsClient((Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Test(timeout=60000L)
    public void testAuthenticationHttpClient() throws Exception {
        AuthenticatorTestCase auth = new AuthenticatorTestCase(this.useTomcat);
        AuthenticatorTestCase.setAuthenticationHandlerConfig((Properties)this.getAuthenticationHandlerConfiguration());
        KerberosTestUtils.doAsClient((Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Test(timeout=60000L)
    public void testAuthenticationHttpClientPost() throws Exception {
        AuthenticatorTestCase auth = new AuthenticatorTestCase(this.useTomcat);
        AuthenticatorTestCase.setAuthenticationHandlerConfig((Properties)this.getAuthenticationHandlerConfiguration());
        KerberosTestUtils.doAsClient((Callable)new /* Unavailable Anonymous Inner Class!! */);
    }
}

