/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.io.File;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.minikdc.KerberosSecurityTestcase;
import org.apache.hadoop.security.authentication.KerberosTestUtils;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.KerberosAuthenticationHandler;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestKerberosAuthenticationHandler
extends KerberosSecurityTestcase {
    protected KerberosAuthenticationHandler handler;

    protected KerberosAuthenticationHandler getNewAuthenticationHandler() {
        return new KerberosAuthenticationHandler();
    }

    protected String getExpectedType() {
        return "kerberos";
    }

    protected Properties getDefaultProperties() {
        Properties props = new Properties();
        props.setProperty("kerberos.principal", KerberosTestUtils.getServerPrincipal());
        props.setProperty("kerberos.keytab", KerberosTestUtils.getKeytabFile());
        props.setProperty("kerberos.name.rules", "RULE:[1:$1@$0](.*@" + KerberosTestUtils.getRealm() + ")s/@.*//\n");
        return props;
    }

    @Before
    public void setup() throws Exception {
        File keytabFile = new File(KerberosTestUtils.getKeytabFile());
        String clientPrincipal = KerberosTestUtils.getClientPrincipal();
        String serverPrincipal = KerberosTestUtils.getServerPrincipal();
        clientPrincipal = clientPrincipal.substring(0, clientPrincipal.lastIndexOf("@"));
        serverPrincipal = serverPrincipal.substring(0, serverPrincipal.lastIndexOf("@"));
        this.getKdc().createPrincipal(keytabFile, new String[]{clientPrincipal, serverPrincipal});
        this.handler = this.getNewAuthenticationHandler();
        Properties props = this.getDefaultProperties();
        try {
            this.handler.init(props);
        }
        catch (Exception ex) {
            this.handler = null;
            throw ex;
        }
    }

    @Test(timeout=60000L)
    public void testNameRules() throws Exception {
        KerberosName kn = new KerberosName(KerberosTestUtils.getServerPrincipal());
        Assert.assertEquals((Object)KerberosTestUtils.getRealm(), (Object)kn.getRealm());
        this.handler.destroy();
        KerberosName.setRules((String)"RULE:[1:$1@$0](.*@FOO)s/@.*//\nDEFAULT");
        this.handler = this.getNewAuthenticationHandler();
        Properties props = this.getDefaultProperties();
        props.setProperty("kerberos.name.rules", "RULE:[1:$1@$0](.*@BAR)s/@.*//\nDEFAULT");
        try {
            this.handler.init(props);
        }
        catch (Exception exception) {
            // empty catch block
        }
        kn = new KerberosName("bar@BAR");
        Assert.assertEquals((Object)"bar", (Object)kn.getShortName());
        kn = new KerberosName("bar@FOO");
        Assert.assertEquals((Object)"bar@FOO", (Object)kn.getShortName());
    }

    @Test(timeout=60000L)
    public void testInit() throws Exception {
        Assert.assertEquals((Object)KerberosTestUtils.getKeytabFile(), (Object)this.handler.getKeytab());
        Set principals = this.handler.getPrincipals();
        KerberosPrincipal expectedPrincipal = new KerberosPrincipal(KerberosTestUtils.getServerPrincipal());
        Assert.assertTrue((boolean)principals.contains(expectedPrincipal));
        Assert.assertEquals((long)1L, (long)principals.size());
    }

    @Test(timeout=60000L)
    public void testDynamicPrincipalDiscovery() throws Exception {
        String[] keytabUsers = new String[]{"HTTP/host1", "HTTP/host2", "HTTP2/host1", "XHTTP/host"};
        String keytab = KerberosTestUtils.getKeytabFile();
        this.getKdc().createPrincipal(new File(keytab), keytabUsers);
        this.handler.destroy();
        Properties props = new Properties();
        props.setProperty("kerberos.keytab", keytab);
        props.setProperty("kerberos.principal", "*");
        this.handler = this.getNewAuthenticationHandler();
        this.handler.init(props);
        Assert.assertEquals((Object)KerberosTestUtils.getKeytabFile(), (Object)this.handler.getKeytab());
        Set loginPrincipals = this.handler.getPrincipals();
        for (String user : keytabUsers) {
            KerberosPrincipal principal = new KerberosPrincipal(user + "@" + KerberosTestUtils.getRealm());
            boolean expected = user.startsWith("HTTP/");
            Assert.assertEquals((String)("checking for " + user), (Object)expected, (Object)loginPrincipals.contains(principal));
        }
    }

    @Test(timeout=60000L)
    public void testDynamicPrincipalDiscoveryMissingPrincipals() throws Exception {
        String[] keytabUsers = new String[]{"hdfs/localhost"};
        String keytab = KerberosTestUtils.getKeytabFile();
        this.getKdc().createPrincipal(new File(keytab), keytabUsers);
        this.handler.destroy();
        Properties props = new Properties();
        props.setProperty("kerberos.keytab", keytab);
        props.setProperty("kerberos.principal", "*");
        this.handler = this.getNewAuthenticationHandler();
        try {
            this.handler.init(props);
            Assert.fail((String)"init should have failed");
        }
        catch (ServletException ex) {
            Assert.assertEquals((Object)"Principals do not exist in the keytab", (Object)ex.getCause().getMessage());
        }
        catch (Throwable t) {
            Assert.fail((String)("wrong exception: " + t));
        }
    }

    @Test(timeout=60000L)
    public void testType() throws Exception {
        Assert.assertEquals((Object)this.getExpectedType(), (Object)this.handler.getType());
    }

    public void testRequestWithoutAuthorization() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Assert.assertNull((Object)this.handler.authenticate(request, response));
        ((HttpServletResponse)Mockito.verify((Object)response)).setHeader("WWW-Authenticate", "Negotiate");
        ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(401);
    }

    public void testRequestWithInvalidAuthorization() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getHeader("Authorization")).thenReturn((Object)"invalid");
        Assert.assertNull((Object)this.handler.authenticate(request, response));
        ((HttpServletResponse)Mockito.verify((Object)response)).setHeader("WWW-Authenticate", "Negotiate");
        ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(401);
    }

    @Test(timeout=60000L)
    public void testRequestWithIncompleteAuthorization() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getHeader("Authorization")).thenReturn((Object)"Negotiate");
        try {
            this.handler.authenticate(request, response);
            Assert.fail();
        }
        catch (AuthenticationException authenticationException) {
        }
        catch (Exception ex) {
            Assert.fail();
        }
    }

    public void testRequestWithAuthorization() throws Exception {
        String token = (String)KerberosTestUtils.doAsClient((Callable)new /* Unavailable Anonymous Inner Class!! */);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getHeader("Authorization")).thenReturn((Object)("Negotiate " + token));
        Mockito.when((Object)request.getServerName()).thenReturn((Object)"localhost");
        AuthenticationToken authToken = this.handler.authenticate(request, response);
        if (authToken != null) {
            ((HttpServletResponse)Mockito.verify((Object)response)).setHeader((String)Mockito.eq((Object)"WWW-Authenticate"), Mockito.matches((String)"Negotiate .*"));
            ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(200);
            Assert.assertEquals((Object)KerberosTestUtils.getClientPrincipal(), (Object)authToken.getName());
            Assert.assertTrue((boolean)KerberosTestUtils.getClientPrincipal().startsWith(authToken.getUserName()));
            Assert.assertEquals((Object)this.getExpectedType(), (Object)authToken.getType());
        } else {
            ((HttpServletResponse)Mockito.verify((Object)response)).setHeader((String)Mockito.eq((Object)"WWW-Authenticate"), Mockito.matches((String)"Negotiate .*"));
            ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(401);
        }
    }

    public void testRequestWithInvalidKerberosAuthorization() throws Exception {
        String token = new Base64(0).encodeToString(new byte[]{0, 1, 2});
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getHeader("Authorization")).thenReturn((Object)("Negotiate" + token));
        try {
            this.handler.authenticate(request, response);
            Assert.fail();
        }
        catch (AuthenticationException authenticationException) {
        }
        catch (Exception ex) {
            Assert.fail();
        }
    }

    @After
    public void tearDown() throws Exception {
        if (this.handler != null) {
            this.handler.destroy();
            this.handler = null;
        }
    }
}

