/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Properties;
import java.util.Random;
import javax.security.auth.login.Configuration;
import javax.servlet.ServletContext;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.curator.framework.imps.DefaultACLProvider;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.authentication.util.RolloverSignerSecretProvider;
import org.apache.hadoop.security.authentication.util.ZKSignerSecretProvider;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Unstable
@InterfaceAudience.Private
public class ZKSignerSecretProvider
extends RolloverSignerSecretProvider {
    private static final String CONFIG_PREFIX = "signer.secret.provider.zookeeper.";
    public static final String ZOOKEEPER_CONNECTION_STRING = "signer.secret.provider.zookeeper.connection.string";
    public static final String ZOOKEEPER_PATH = "signer.secret.provider.zookeeper.path";
    public static final String ZOOKEEPER_AUTH_TYPE = "signer.secret.provider.zookeeper.auth.type";
    public static final String ZOOKEEPER_KERBEROS_KEYTAB = "signer.secret.provider.zookeeper.kerberos.keytab";
    public static final String ZOOKEEPER_KERBEROS_PRINCIPAL = "signer.secret.provider.zookeeper.kerberos.principal";
    public static final String DISCONNECT_FROM_ZOOKEEPER_ON_SHUTDOWN = "signer.secret.provider.zookeeper.disconnect.on.shutdown";
    public static final String ZOOKEEPER_SIGNER_SECRET_PROVIDER_CURATOR_CLIENT_ATTRIBUTE = "signer.secret.provider.zookeeper.curator.client";
    private static final String JAAS_LOGIN_ENTRY_NAME = "ZKSignerSecretProviderClient";
    private static Logger LOG = LoggerFactory.getLogger(ZKSignerSecretProvider.class);
    private String path;
    private volatile byte[] nextSecret;
    private final Random rand;
    private int zkVersion;
    private long nextRolloverDate;
    private long tokenValidity;
    private CuratorFramework client;
    private boolean shouldDisconnect;
    private static int INT_BYTES = 4;
    private static int LONG_BYTES = 8;
    private static int DATA_VERSION = 0;

    public ZKSignerSecretProvider() {
        this.rand = new SecureRandom();
    }

    @VisibleForTesting
    public ZKSignerSecretProvider(long seed) {
        this.rand = new Random(seed);
    }

    public void init(Properties config, ServletContext servletContext, long tokenValidity) throws Exception {
        Object curatorClientObj = servletContext.getAttribute(ZOOKEEPER_SIGNER_SECRET_PROVIDER_CURATOR_CLIENT_ATTRIBUTE);
        if (curatorClientObj != null && curatorClientObj instanceof CuratorFramework) {
            this.client = (CuratorFramework)curatorClientObj;
        } else {
            this.client = this.createCuratorClient(config);
            servletContext.setAttribute(ZOOKEEPER_SIGNER_SECRET_PROVIDER_CURATOR_CLIENT_ATTRIBUTE, (Object)this.client);
        }
        this.tokenValidity = tokenValidity;
        this.shouldDisconnect = Boolean.parseBoolean(config.getProperty(DISCONNECT_FROM_ZOOKEEPER_ON_SHUTDOWN, "true"));
        this.path = config.getProperty(ZOOKEEPER_PATH);
        if (this.path == null) {
            throw new IllegalArgumentException("signer.secret.provider.zookeeper.path must be specified");
        }
        try {
            this.nextRolloverDate = System.currentTimeMillis() + tokenValidity;
            this.client.create().creatingParentsIfNeeded().forPath(this.path, this.generateZKData(this.generateRandomSecret(), this.generateRandomSecret(), null));
            this.zkVersion = 0;
            LOG.info("Creating secret znode");
        }
        catch (KeeperException.NodeExistsException nee) {
            LOG.info("The secret znode already exists, retrieving data");
        }
        this.pullFromZK(true);
        long initialDelay = this.nextRolloverDate - System.currentTimeMillis();
        if (initialDelay < 1L) {
            int i = 1;
            while (initialDelay < 1L) {
                initialDelay = this.nextRolloverDate + tokenValidity * (long)i - System.currentTimeMillis();
                ++i;
            }
        }
        super.startScheduler(initialDelay, tokenValidity);
    }

    public void destroy() {
        if (this.shouldDisconnect && this.client != null) {
            this.client.close();
        }
        super.destroy();
    }

    protected synchronized void rollSecret() {
        super.rollSecret();
        this.nextRolloverDate += this.tokenValidity;
        byte[][] secrets = super.getAllSecrets();
        this.pushToZK(this.generateRandomSecret(), secrets[0], secrets[1]);
        this.pullFromZK(false);
    }

    protected byte[] generateNewSecret() {
        return this.nextSecret;
    }

    private synchronized void pushToZK(byte[] newSecret, byte[] currentSecret, byte[] previousSecret) {
        byte[] bytes = this.generateZKData(newSecret, currentSecret, previousSecret);
        try {
            ((BackgroundPathAndBytesable)this.client.setData().withVersion(this.zkVersion)).forPath(this.path, bytes);
        }
        catch (KeeperException.BadVersionException bve) {
            LOG.debug("Unable to push to znode; another server already did it");
        }
        catch (Exception ex) {
            LOG.error("An unexpected exception occured pushing data to ZooKeeper", (Throwable)ex);
        }
    }

    private synchronized byte[] generateZKData(byte[] newSecret, byte[] currentSecret, byte[] previousSecret) {
        int newSecretLength = newSecret.length;
        int currentSecretLength = currentSecret.length;
        int previousSecretLength = 0;
        if (previousSecret != null) {
            previousSecretLength = previousSecret.length;
        }
        ByteBuffer bb = ByteBuffer.allocate(INT_BYTES + INT_BYTES + newSecretLength + INT_BYTES + currentSecretLength + INT_BYTES + previousSecretLength + LONG_BYTES);
        bb.putInt(DATA_VERSION);
        bb.putInt(newSecretLength);
        bb.put(newSecret);
        bb.putInt(currentSecretLength);
        bb.put(currentSecret);
        bb.putInt(previousSecretLength);
        if (previousSecretLength > 0) {
            bb.put(previousSecret);
        }
        bb.putLong(this.nextRolloverDate);
        return bb.array();
    }

    private synchronized void pullFromZK(boolean isInit) {
        try {
            Stat stat = new Stat();
            byte[] bytes = (byte[])((WatchPathable)this.client.getData().storingStatIn(stat)).forPath(this.path);
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            int dataVersion = bb.getInt();
            if (dataVersion > DATA_VERSION) {
                throw new IllegalStateException("Cannot load data from ZooKeeper; itwas written with a newer version");
            }
            int nextSecretLength = bb.getInt();
            byte[] nextSecret = new byte[nextSecretLength];
            bb.get(nextSecret);
            this.nextSecret = nextSecret;
            this.zkVersion = stat.getVersion();
            if (isInit) {
                int currentSecretLength = bb.getInt();
                byte[] currentSecret = new byte[currentSecretLength];
                bb.get(currentSecret);
                int previousSecretLength = bb.getInt();
                byte[] previousSecret = null;
                if (previousSecretLength > 0) {
                    previousSecret = new byte[previousSecretLength];
                    bb.get(previousSecret);
                }
                super.initSecrets(currentSecret, previousSecret);
                this.nextRolloverDate = bb.getLong();
            }
        }
        catch (Exception ex) {
            LOG.error("An unexpected exception occurred while pulling data fromZooKeeper", (Throwable)ex);
        }
    }

    @VisibleForTesting
    protected byte[] generateRandomSecret() {
        byte[] secret = new byte[32];
        this.rand.nextBytes(secret);
        return secret;
    }

    protected CuratorFramework createCuratorClient(Properties config) throws Exception {
        DefaultACLProvider aclProvider;
        String connectionString = config.getProperty(ZOOKEEPER_CONNECTION_STRING, "localhost:2181");
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 3);
        String authType = config.getProperty(ZOOKEEPER_AUTH_TYPE, "none");
        if (authType.equals("sasl")) {
            LOG.info("Connecting to ZooKeeper with SASL/Kerberosand using 'sasl' ACLs");
            String principal = this.setJaasConfiguration(config);
            System.setProperty("zookeeper.sasl.clientconfig", JAAS_LOGIN_ENTRY_NAME);
            System.setProperty("zookeeper.authProvider.1", "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
            aclProvider = new SASLOwnerACLProvider(principal, null);
        } else {
            LOG.info("Connecting to ZooKeeper without authentication");
            aclProvider = new DefaultACLProvider();
        }
        CuratorFramework cf = CuratorFrameworkFactory.builder().connectString(connectionString).retryPolicy((RetryPolicy)retryPolicy).aclProvider((ACLProvider)aclProvider).build();
        cf.start();
        return cf;
    }

    private String setJaasConfiguration(Properties config) throws Exception {
        String keytabFile = config.getProperty(ZOOKEEPER_KERBEROS_KEYTAB).trim();
        if (keytabFile == null || keytabFile.length() == 0) {
            throw new IllegalArgumentException("signer.secret.provider.zookeeper.kerberos.keytab must be specified");
        }
        String principal = config.getProperty(ZOOKEEPER_KERBEROS_PRINCIPAL).trim();
        if (principal == null || principal.length() == 0) {
            throw new IllegalArgumentException("signer.secret.provider.zookeeper.kerberos.principal must be specified");
        }
        JaasConfiguration jConf = new JaasConfiguration(JAAS_LOGIN_ENTRY_NAME, principal, keytabFile);
        Configuration.setConfiguration((Configuration)jConf);
        return principal.split("[/@]")[0];
    }
}

