/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.client;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.CharacterCodingException;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.security.sasl.AuthenticationException;
import org.apache.hadoop.minikdc.KerberosSecurityTestcase;
import org.apache.hadoop.security.authentication.KerberosTestUtils;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.AuthenticatorTestCase;
import org.apache.hadoop.security.authentication.client.KerberosAuthenticator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestKerberosAuthenticator
extends KerberosSecurityTestcase {
    @Before
    public void setup() throws Exception {
        File keytabFile = new File(KerberosTestUtils.getKeytabFile());
        String clientPrincipal = KerberosTestUtils.getClientPrincipal();
        String serverPrincipal = KerberosTestUtils.getServerPrincipal();
        clientPrincipal = clientPrincipal.substring(0, clientPrincipal.lastIndexOf("@"));
        serverPrincipal = serverPrincipal.substring(0, serverPrincipal.lastIndexOf("@"));
        this.getKdc().createPrincipal(keytabFile, new String[]{clientPrincipal, serverPrincipal});
    }

    private Properties getAuthenticationHandlerConfiguration() {
        Properties props = new Properties();
        props.setProperty("type", "kerberos");
        props.setProperty("kerberos.principal", KerberosTestUtils.getServerPrincipal());
        props.setProperty("kerberos.keytab", KerberosTestUtils.getKeytabFile());
        props.setProperty("kerberos.name.rules", "RULE:[1:$1@$0](.*@" + KerberosTestUtils.getRealm() + ")s/@.*//\n");
        return props;
    }

    private Properties getMultiAuthHandlerConfiguration() {
        Properties props = new Properties();
        props.setProperty("type", "multi-scheme");
        props.setProperty("multi-scheme-auth-handler.schemes", "negotiate");
        props.setProperty(String.format("multi-scheme-auth-handler.schemes.%s.handler", "negotiate"), "kerberos");
        props.setProperty("kerberos.principal", KerberosTestUtils.getServerPrincipal());
        props.setProperty("kerberos.keytab", KerberosTestUtils.getKeytabFile());
        props.setProperty("kerberos.name.rules", "RULE:[1:$1@$0](.*@" + KerberosTestUtils.getRealm() + ")s/@.*//\n");
        return props;
    }

    @Test(timeout=60000L)
    public void testFallbacktoPseudoAuthenticator() throws Exception {
        AuthenticatorTestCase auth = new AuthenticatorTestCase();
        Properties props = new Properties();
        props.setProperty("type", "simple");
        props.setProperty("simple.anonymous.allowed", "false");
        AuthenticatorTestCase.setAuthenticationHandlerConfig(props);
        auth._testAuthentication((Authenticator)new KerberosAuthenticator(), false);
    }

    @Test(timeout=60000L)
    public void testFallbacktoPseudoAuthenticatorAnonymous() throws Exception {
        AuthenticatorTestCase auth = new AuthenticatorTestCase();
        Properties props = new Properties();
        props.setProperty("type", "simple");
        props.setProperty("simple.anonymous.allowed", "true");
        AuthenticatorTestCase.setAuthenticationHandlerConfig(props);
        auth._testAuthentication((Authenticator)new KerberosAuthenticator(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testNotAuthenticated() throws Exception {
        AuthenticatorTestCase auth = new AuthenticatorTestCase();
        AuthenticatorTestCase.setAuthenticationHandlerConfig(this.getAuthenticationHandlerConfiguration());
        auth.start();
        try {
            URL url = new URL(auth.getBaseURL());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.connect();
            Assert.assertEquals((long)401L, (long)conn.getResponseCode());
            Assert.assertTrue((conn.getHeaderField("WWW-Authenticate") != null ? 1 : 0) != 0);
        }
        finally {
            auth.stop();
        }
    }

    @Test(timeout=60000L)
    public void testAuthentication() throws Exception {
        final AuthenticatorTestCase auth = new AuthenticatorTestCase();
        AuthenticatorTestCase.setAuthenticationHandlerConfig(this.getAuthenticationHandlerConfiguration());
        KerberosTestUtils.doAsClient(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                auth._testAuthentication((Authenticator)new KerberosAuthenticator(), false);
                return null;
            }
        });
    }

    @Test(timeout=60000L)
    public void testAuthenticationPost() throws Exception {
        final AuthenticatorTestCase auth = new AuthenticatorTestCase();
        AuthenticatorTestCase.setAuthenticationHandlerConfig(this.getAuthenticationHandlerConfiguration());
        KerberosTestUtils.doAsClient(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                auth._testAuthentication((Authenticator)new KerberosAuthenticator(), true);
                return null;
            }
        });
    }

    @Test(timeout=60000L)
    public void testAuthenticationHttpClient() throws Exception {
        final AuthenticatorTestCase auth = new AuthenticatorTestCase();
        AuthenticatorTestCase.setAuthenticationHandlerConfig(this.getAuthenticationHandlerConfiguration());
        KerberosTestUtils.doAsClient(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                auth._testAuthenticationHttpClient((Authenticator)new KerberosAuthenticator(), false);
                return null;
            }
        });
    }

    @Test(timeout=60000L)
    public void testAuthenticationHttpClientPost() throws Exception {
        final AuthenticatorTestCase auth = new AuthenticatorTestCase();
        AuthenticatorTestCase.setAuthenticationHandlerConfig(this.getAuthenticationHandlerConfiguration());
        KerberosTestUtils.doAsClient(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                auth._testAuthenticationHttpClient((Authenticator)new KerberosAuthenticator(), true);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testNotAuthenticatedWithMultiAuthHandler() throws Exception {
        AuthenticatorTestCase auth = new AuthenticatorTestCase();
        AuthenticatorTestCase.setAuthenticationHandlerConfig(this.getMultiAuthHandlerConfiguration());
        auth.start();
        try {
            URL url = new URL(auth.getBaseURL());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.connect();
            Assert.assertEquals((long)401L, (long)conn.getResponseCode());
            Assert.assertTrue((conn.getHeaderField("WWW-Authenticate") != null ? 1 : 0) != 0);
        }
        finally {
            auth.stop();
        }
    }

    @Test(timeout=60000L)
    public void testAuthenticationWithMultiAuthHandler() throws Exception {
        final AuthenticatorTestCase auth = new AuthenticatorTestCase();
        AuthenticatorTestCase.setAuthenticationHandlerConfig(this.getMultiAuthHandlerConfiguration());
        KerberosTestUtils.doAsClient(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                auth._testAuthentication((Authenticator)new KerberosAuthenticator(), false);
                return null;
            }
        });
    }

    @Test(timeout=60000L)
    public void testAuthenticationHttpClientPostWithMultiAuthHandler() throws Exception {
        final AuthenticatorTestCase auth = new AuthenticatorTestCase();
        AuthenticatorTestCase.setAuthenticationHandlerConfig(this.getMultiAuthHandlerConfiguration());
        KerberosTestUtils.doAsClient(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                auth._testAuthenticationHttpClient((Authenticator)new KerberosAuthenticator(), true);
                return null;
            }
        });
    }

    @Test(timeout=60000L)
    public void testWrapExceptionWithMessage() {
        IOException ex = new IOException("Induced exception");
        ex = (IOException)KerberosAuthenticator.wrapExceptionWithMessage((Exception)ex, (String)"Error while authenticating with endpoint: localhost");
        Assert.assertEquals((Object)"Induced exception", (Object)ex.getCause().getMessage());
        Assert.assertEquals((Object)"Error while authenticating with endpoint: localhost", (Object)ex.getMessage());
        ex = new AuthenticationException("Auth exception");
        ex = (IOException)KerberosAuthenticator.wrapExceptionWithMessage((Exception)ex, (String)"Error while authenticating with endpoint: localhost");
        Assert.assertEquals((Object)"Auth exception", (Object)ex.getCause().getMessage());
        Assert.assertEquals((Object)"Error while authenticating with endpoint: localhost", (Object)ex.getMessage());
        ex = new CharacterCodingException();
        Exception ex2 = KerberosAuthenticator.wrapExceptionWithMessage((Exception)ex, (String)"Error while authenticating with endpoint: localhost");
        Assert.assertTrue((boolean)(ex instanceof CharacterCodingException));
        Assert.assertTrue((boolean)ex.equals(ex2));
    }
}

