/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication;

import java.io.File;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.hadoop.util.PlatformName;

public class KerberosTestUtils {
    private static String keytabFile = new File(System.getProperty("test.dir", "target"), UUID.randomUUID().toString()).getAbsolutePath();

    public static String getRealm() {
        return "EXAMPLE.COM";
    }

    public static String getClientPrincipal() {
        return "client@EXAMPLE.COM";
    }

    public static String getServerPrincipal() {
        return "HTTP/localhost@EXAMPLE.COM";
    }

    public static String getKeytabFile() {
        return keytabFile;
    }

    public static <T> T doAs(String principal, final Callable<T> callable) throws Exception {
        LoginContext loginContext = null;
        try {
            HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>();
            principals.add(new KerberosPrincipal(KerberosTestUtils.getClientPrincipal()));
            Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
            loginContext = new LoginContext("", subject, null, new KerberosConfiguration(principal));
            loginContext.login();
            subject = loginContext.getSubject();
            Object t = Subject.doAs(subject, new PrivilegedExceptionAction<T>(){

                @Override
                public T run() throws Exception {
                    return callable.call();
                }
            });
            return t;
        }
        catch (PrivilegedActionException ex) {
            throw ex.getException();
        }
        finally {
            if (loginContext != null) {
                loginContext.logout();
            }
        }
    }

    public static <T> T doAsClient(Callable<T> callable) throws Exception {
        return KerberosTestUtils.doAs(KerberosTestUtils.getClientPrincipal(), callable);
    }

    public static <T> T doAsServer(Callable<T> callable) throws Exception {
        return KerberosTestUtils.doAs(KerberosTestUtils.getServerPrincipal(), callable);
    }

    private static class KerberosConfiguration
    extends Configuration {
        private String principal;

        public KerberosConfiguration(String principal) {
            this.principal = principal;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, String> options = new HashMap<String, String>();
            if (PlatformName.IBM_JAVA) {
                options.put("useKeytab", KerberosTestUtils.getKeytabFile().startsWith("file://") ? KerberosTestUtils.getKeytabFile() : "file://" + KerberosTestUtils.getKeytabFile());
                options.put("principal", this.principal);
                options.put("refreshKrb5Config", "true");
                options.put("credsType", "both");
            } else {
                options.put("keyTab", KerberosTestUtils.getKeytabFile());
                options.put("principal", this.principal);
                options.put("useKeyTab", "true");
                options.put("storeKey", "true");
                options.put("doNotPrompt", "true");
                options.put("useTicketCache", "true");
                options.put("renewTGT", "true");
                options.put("refreshKrb5Config", "true");
                options.put("isInitiator", "true");
            }
            String ticketCache = System.getenv("KRB5CCNAME");
            if (ticketCache != null) {
                if (PlatformName.IBM_JAVA) {
                    System.setProperty("KRB5CCNAME", ticketCache);
                    options.put("useDefaultCcache", "true");
                    options.put("renewTGT", "true");
                } else {
                    options.put("ticketCache", ticketCache);
                }
            }
            options.put("debug", "true");
            return new AppConfigurationEntry[]{new AppConfigurationEntry(KerberosUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }
}

