/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.commit;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.commit.PathCommitException;
import org.apache.hadoop.fs.s3a.commit.ValidationFailure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommitUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CommitUtils.class);

    private CommitUtils() {
    }

    public static void verifyIsMagicCommitPath(S3AFileSystem fs, Path path) throws PathCommitException {
        CommitUtils.verifyIsMagicCommitFS(fs);
        if (!fs.isMagicCommitPath(path)) {
            throw new PathCommitException(path, "Path does not represent a magic-commit path");
        }
    }

    public static void verifyIsMagicCommitFS(S3AFileSystem fs) throws PathCommitException {
        if (!fs.isMagicCommitEnabled()) {
            String fsUri = fs.getUri().toString();
            LOG.error("{}: {}:\n{}", new Object[]{"Filesystem does not have support for 'magic' committer enabled in configuration option fs.s3a.committer.magic.enabled", fsUri, fs});
            throw new PathCommitException(fsUri, "Filesystem does not have support for 'magic' committer enabled in configuration option fs.s3a.committer.magic.enabled");
        }
    }

    public static S3AFileSystem verifyIsS3AFS(FileSystem fs, Path path) throws PathCommitException {
        if (!(fs instanceof S3AFileSystem)) {
            throw new PathCommitException(path, "Output path is not on an S3A Filesystem");
        }
        return (S3AFileSystem)fs;
    }

    public static S3AFileSystem getS3AFileSystem(Path path, Configuration conf, boolean magicCommitRequired) throws PathCommitException, IOException {
        S3AFileSystem s3AFS = CommitUtils.verifyIsS3AFS(path.getFileSystem(conf), path);
        if (magicCommitRequired) {
            CommitUtils.verifyIsMagicCommitFS(s3AFS);
        }
        return s3AFS;
    }

    public static void validateCollectionClass(Iterable it, Class classname) throws ValidationFailure {
        for (Object o : it) {
            ValidationFailure.verify(o.getClass().equals(classname), "Collection element is not a %s: %s", classname, o.getClass());
        }
    }
}

