/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.MultipartUpload;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.amazonaws.services.s3.transfer.model.UploadResult;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.S3ARetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class WriteOperationHelper {
    private static final Logger LOG = LoggerFactory.getLogger(WriteOperationHelper.class);
    private final S3AFileSystem owner;
    private final Invoker invoker;

    protected WriteOperationHelper(S3AFileSystem owner, Configuration conf) {
        this.owner = owner;
        this.invoker = new Invoker(new S3ARetryPolicy(conf), this::operationRetried);
    }

    void operationRetried(String text, Exception ex, int retries, boolean idempotent) {
        this.owner.operationRetried(text, ex, retries, idempotent);
    }

    public <T> T retry(String action, String path, boolean idempotent, Invoker.Operation<T> operation) throws IOException {
        return this.invoker.retry(action, path, idempotent, operation);
    }

    public PutObjectRequest createPutObjectRequest(String destKey, InputStream inputStream, long length) {
        return this.owner.newPutObjectRequest(destKey, this.newObjectMetadata(length), inputStream);
    }

    public PutObjectRequest createPutObjectRequest(String dest, File sourceFile) {
        Preconditions.checkState((sourceFile.length() < Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"File length is too big for a single PUT upload");
        return this.owner.newPutObjectRequest(dest, this.newObjectMetadata((int)sourceFile.length()), sourceFile);
    }

    public void writeSuccessful(long length) {
    }

    public void writeFailed(Exception ex) {
        LOG.debug("Write to {} failed", (Object)this, (Object)ex);
    }

    public ObjectMetadata newObjectMetadata(long length) {
        return this.owner.newObjectMetadata(length);
    }

    public String initiateMultiPartUpload(String destKey) throws IOException {
        LOG.debug("Initiating Multipart upload to {}", (Object)destKey);
        InitiateMultipartUploadRequest initiateMPURequest = new InitiateMultipartUploadRequest(this.owner.getBucket(), destKey, this.newObjectMetadata(-1L));
        initiateMPURequest.setCannedACL(this.owner.getCannedACL());
        this.owner.setOptionalMultipartUploadRequestParameters(initiateMPURequest);
        return this.retry("initiate MultiPartUpload", destKey, true, () -> this.owner.initiateMultipartUpload(initiateMPURequest).getUploadId());
    }

    private CompleteMultipartUploadResult finalizeMultipartUpload(String destKey, String uploadId, List<PartETag> partETags, long length, Invoker.Retried retrying) throws IOException {
        return this.invoker.retry("Completing multipart commit", destKey, true, retrying, () -> {
            CompleteMultipartUploadResult result = this.owner.getAmazonS3Client().completeMultipartUpload(new CompleteMultipartUploadRequest(this.owner.getBucket(), destKey, uploadId, new ArrayList(partETags)));
            this.owner.finishedWrite(destKey, length);
            return result;
        });
    }

    public CompleteMultipartUploadResult completeMPUwithRetries(String destKey, String uploadId, List<PartETag> partETags, long length, AtomicInteger errorCount) throws IOException {
        Preconditions.checkNotNull((Object)uploadId);
        Preconditions.checkNotNull(partETags);
        LOG.debug("Completing multipart upload {} with {} parts", (Object)uploadId, (Object)partETags.size());
        return this.finalizeMultipartUpload(destKey, uploadId, partETags, length, (text, e, r, i) -> errorCount.incrementAndGet());
    }

    public void abortMultipartUpload(String destKey, String uploadId, Invoker.Retried retrying) throws IOException {
        this.invoker.retry("Aborting multipart upload", destKey, true, retrying, () -> this.owner.abortMultipartUpload(destKey, uploadId));
    }

    public void abortMultipartUpload(MultipartUpload upload) throws IOException {
        this.invoker.retry("Aborting multipart commit", upload.getKey(), true, () -> this.owner.abortMultipartUpload(upload));
    }

    public int abortMultipartUploadsUnderPath(String prefix) throws IOException {
        LOG.debug("Aborting multipart uploads under {}", (Object)prefix);
        int count = 0;
        List<MultipartUpload> multipartUploads = this.owner.listMultipartUploads(prefix);
        LOG.debug("Number of outstanding uploads: {}", (Object)multipartUploads.size());
        for (MultipartUpload upload : multipartUploads) {
            try {
                this.abortMultipartUpload(upload);
                ++count;
            }
            catch (FileNotFoundException e) {
                LOG.debug("Already aborted: {}", (Object)upload.getKey(), (Object)e);
            }
        }
        return count;
    }

    public void abortMultipartCommit(String destKey, String uploadId) throws IOException {
        this.abortMultipartUpload(destKey, uploadId, this.invoker.getRetryCallback());
    }

    public UploadPartRequest newUploadPartRequest(String destKey, String uploadId, int partNumber, int size, InputStream uploadStream, File sourceFile, Long offset) {
        Preconditions.checkNotNull((Object)uploadId);
        Preconditions.checkArgument((boolean)(uploadStream != null ^ sourceFile != null), (Object)"Data source");
        Preconditions.checkArgument((size >= 0 ? 1 : 0) != 0, (String)"Invalid partition size %s", (int)size);
        Preconditions.checkArgument((partNumber > 0 && partNumber <= 10000 ? 1 : 0) != 0, (String)"partNumber must be between 1 and 10000 inclusive, but is %s", (int)partNumber);
        LOG.debug("Creating part upload request for {} #{} size {}", new Object[]{uploadId, partNumber, size});
        UploadPartRequest request = new UploadPartRequest().withBucketName(this.owner.getBucket()).withKey(destKey).withUploadId(uploadId).withPartNumber(partNumber).withPartSize((long)size);
        if (uploadStream != null) {
            request.setInputStream(uploadStream);
        } else {
            Preconditions.checkArgument((boolean)sourceFile.exists(), (String)"Source file does not exist: %s", (Object)sourceFile);
            Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (String)"Invalid offset %s", (Object)offset);
            long length = sourceFile.length();
            Preconditions.checkArgument((offset == 0L || offset < length ? 1 : 0) != 0, (String)"Offset %s beyond length of file %s", (Object)offset, (long)length);
            request.setFile(sourceFile);
            request.setFileOffset(offset.longValue());
        }
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WriteOperationHelper {bucket=").append(this.owner.getBucket());
        sb.append('}');
        return sb.toString();
    }

    public PutObjectResult putObject(PutObjectRequest putObjectRequest) throws IOException {
        return this.retry("put", putObjectRequest.getKey(), true, () -> this.owner.putObjectDirect(putObjectRequest));
    }

    public UploadResult uploadObject(PutObjectRequest putObjectRequest) throws IOException {
        return this.retry("put", putObjectRequest.getKey(), true, () -> this.owner.executePut(putObjectRequest, null));
    }

    public void revertCommit(String destKey) throws IOException {
        Invoker.once("revert commit", destKey, () -> {
            Path destPath = this.owner.keyToQualifiedPath(destKey);
            this.owner.deleteObjectAtPath(destPath, destKey, true);
            this.owner.maybeCreateFakeParentDirectory(destPath);
        });
    }

    public UploadPartResult uploadPart(UploadPartRequest request) throws IOException {
        return this.retry("upload part", request.getKey(), true, () -> this.owner.uploadPart(request));
    }
}

