/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkBaseException;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.DeleteObjectsResult;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.MultiObjectDeleteException;
import com.amazonaws.services.s3.model.MultipartUpload;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.SSECustomerKey;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.amazonaws.services.s3.transfer.Copy;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerConfiguration;
import com.amazonaws.services.s3.transfer.Upload;
import com.amazonaws.services.s3.transfer.model.CopyResult;
import com.amazonaws.services.s3.transfer.model.UploadResult;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.AccessDeniedException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.GlobalStorageStatistics;
import org.apache.hadoop.fs.Globber;
import org.apache.hadoop.fs.InvalidRequestException;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.fs.impl.AbstractFSBuilderImpl;
import org.apache.hadoop.fs.impl.OpenFileParameters;
import org.apache.hadoop.fs.impl.PathCapabilitiesSupport;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.s3a.AWSCredentialProviderList;
import org.apache.hadoop.fs.s3a.Constants;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.Listing;
import org.apache.hadoop.fs.s3a.MetadataPersistenceException;
import org.apache.hadoop.fs.s3a.MultipartUtils;
import org.apache.hadoop.fs.s3a.ProgressableProgressListener;
import org.apache.hadoop.fs.s3a.RemoteFileChangedException;
import org.apache.hadoop.fs.s3a.RenameFailedException;
import org.apache.hadoop.fs.s3a.S3ABlockOutputStream;
import org.apache.hadoop.fs.s3a.S3ADataBlocks;
import org.apache.hadoop.fs.s3a.S3AEncryptionMethods;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.S3AInputPolicy;
import org.apache.hadoop.fs.s3a.S3AInputStream;
import org.apache.hadoop.fs.s3a.S3AInstrumentation;
import org.apache.hadoop.fs.s3a.S3ALocatedFileStatus;
import org.apache.hadoop.fs.s3a.S3AReadOpContext;
import org.apache.hadoop.fs.s3a.S3ARetryPolicy;
import org.apache.hadoop.fs.s3a.S3AStorageStatistics;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.S3ClientFactory;
import org.apache.hadoop.fs.s3a.S3GuardExistsRetryPolicy;
import org.apache.hadoop.fs.s3a.S3ListRequest;
import org.apache.hadoop.fs.s3a.S3ListResult;
import org.apache.hadoop.fs.s3a.S3ObjectAttributes;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.Tristate;
import org.apache.hadoop.fs.s3a.UnknownStoreException;
import org.apache.hadoop.fs.s3a.UploadInfo;
import org.apache.hadoop.fs.s3a.WriteOperationHelper;
import org.apache.hadoop.fs.s3a.auth.RoleModel;
import org.apache.hadoop.fs.s3a.auth.RolePolicies;
import org.apache.hadoop.fs.s3a.auth.SignerManager;
import org.apache.hadoop.fs.s3a.auth.delegation.AWSPolicyProvider;
import org.apache.hadoop.fs.s3a.auth.delegation.AbstractS3ATokenIdentifier;
import org.apache.hadoop.fs.s3a.auth.delegation.DelegationOperations;
import org.apache.hadoop.fs.s3a.auth.delegation.DelegationTokenProvider;
import org.apache.hadoop.fs.s3a.auth.delegation.EncryptionSecretOperations;
import org.apache.hadoop.fs.s3a.auth.delegation.EncryptionSecrets;
import org.apache.hadoop.fs.s3a.auth.delegation.S3ADelegationTokens;
import org.apache.hadoop.fs.s3a.commit.MagicCommitIntegration;
import org.apache.hadoop.fs.s3a.commit.PutTracker;
import org.apache.hadoop.fs.s3a.impl.BulkDeleteRetryHandler;
import org.apache.hadoop.fs.s3a.impl.CallableSupplier;
import org.apache.hadoop.fs.s3a.impl.ChangeDetectionPolicy;
import org.apache.hadoop.fs.s3a.impl.ChangeTracker;
import org.apache.hadoop.fs.s3a.impl.ContextAccessors;
import org.apache.hadoop.fs.s3a.impl.CopyOutcome;
import org.apache.hadoop.fs.s3a.impl.DeleteOperation;
import org.apache.hadoop.fs.s3a.impl.ErrorTranslation;
import org.apache.hadoop.fs.s3a.impl.InternalConstants;
import org.apache.hadoop.fs.s3a.impl.MultiObjectDeleteSupport;
import org.apache.hadoop.fs.s3a.impl.NetworkBinding;
import org.apache.hadoop.fs.s3a.impl.OperationCallbacks;
import org.apache.hadoop.fs.s3a.impl.RenameOperation;
import org.apache.hadoop.fs.s3a.impl.StatusProbeEnum;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.fs.s3a.s3guard.BulkOperationState;
import org.apache.hadoop.fs.s3a.s3guard.DirListingMetadata;
import org.apache.hadoop.fs.s3a.s3guard.ITtlTimeProvider;
import org.apache.hadoop.fs.s3a.s3guard.MetadataStore;
import org.apache.hadoop.fs.s3a.s3guard.MetadataStoreListFilesIterator;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadata;
import org.apache.hadoop.fs.s3a.s3guard.S3Guard;
import org.apache.hadoop.fs.s3a.select.InternalSelectConstants;
import org.apache.hadoop.fs.s3a.select.SelectBinding;
import org.apache.hadoop.fs.s3native.S3xLoginHelper;
import org.apache.hadoop.fs.store.EtagChecksum;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.BlockingThreadPoolExecutorService;
import org.apache.hadoop.util.DurationInfo;
import org.apache.hadoop.util.LambdaUtils;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.SemaphoredDelegatingExecutor;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class S3AFileSystem
extends FileSystem
implements StreamCapabilities,
AWSPolicyProvider,
DelegationTokenProvider {
    public static final int DEFAULT_BLOCKSIZE = 0x2000000;
    public static final boolean DELETE_CONSIDERED_IDEMPOTENT = true;
    private URI uri;
    private Path workingDir;
    private String username;
    private AmazonS3 s3;
    private Invoker invoker = new Invoker(RetryPolicies.TRY_ONCE_THEN_FAIL, Invoker.LOG_EVENT);
    private Invoker s3guardInvoker = new Invoker(RetryPolicies.TRY_ONCE_THEN_FAIL, Invoker.LOG_EVENT);
    private final Invoker.Retried onRetry = this::operationRetried;
    private String bucket;
    private int maxKeys;
    private Listing listing;
    private long partSize;
    private boolean enableMultiObjectsDelete;
    private TransferManager transfers;
    private ListeningExecutorService boundedThreadPool;
    private ThreadPoolExecutor unboundedThreadPool;
    private int executorCapacity;
    private long multiPartThreshold;
    public static final Logger LOG = LoggerFactory.getLogger(S3AFileSystem.class);
    private static final Logger PROGRESS = LoggerFactory.getLogger((String)"org.apache.hadoop.fs.s3a.S3AFileSystem.Progress");
    private LocalDirAllocator directoryAllocator;
    private CannedAccessControlList cannedACL;
    private boolean failOnMetadataWriteError;
    private EncryptionSecrets encryptionSecrets = new EncryptionSecrets();
    private S3AInstrumentation instrumentation;
    private final S3AStorageStatistics storageStatistics = S3AFileSystem.createStorageStatistics();
    private long readAhead;
    private S3AInputPolicy inputPolicy;
    private ChangeDetectionPolicy changeDetectionPolicy;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private volatile boolean isClosed = false;
    private MetadataStore metadataStore;
    private boolean allowAuthoritativeMetadataStore;
    private Collection<String> allowAuthoritativePaths;
    private Optional<S3ADelegationTokens> delegationTokens = Optional.empty();
    private UserGroupInformation owner;
    private String blockOutputBuffer;
    private S3ADataBlocks.BlockFactory blockFactory;
    private int blockOutputActiveBlocks;
    private WriteOperationHelper writeHelper;
    private SelectBinding selectBinding;
    private boolean useListV1;
    private MagicCommitIntegration committerIntegration;
    private AWSCredentialProviderList credentials;
    private SignerManager signerManager;
    private ITtlTimeProvider ttlTimeProvider;
    private int pageSize;
    private final OperationCallbacksImpl operationCallbacks = new OperationCallbacksImpl();

    private static void addDeprecatedKeys() {
        Configuration.DeprecationDelta[] deltas = new Configuration.DeprecationDelta[0];
        if (deltas.length > 0) {
            Configuration.addDeprecations((Configuration.DeprecationDelta[])deltas);
            Configuration.reloadExistingConfigurations();
        }
    }

    public void initialize(URI name, Configuration originalConf) throws IOException {
        this.bucket = name.getHost();
        try {
            LOG.debug("Initializing S3AFileSystem for {}", (Object)this.bucket);
            Configuration conf = S3AUtils.propagateBucketOptions(originalConf, this.bucket);
            S3AUtils.patchSecurityCredentialProviders(conf);
            boolean delegationTokensEnabled = S3ADelegationTokens.hasDelegationTokenBinding(conf);
            if (delegationTokensEnabled) {
                LOG.debug("Using delegation tokens");
            }
            this.setUri(name, delegationTokensEnabled);
            super.initialize(this.uri, conf);
            this.setConf(conf);
            this.setEncryptionSecrets(new EncryptionSecrets(S3AUtils.getEncryptionAlgorithm(this.bucket, conf), S3AUtils.getServerSideEncryptionKey(this.bucket, this.getConf())));
            this.invoker = new Invoker(new S3ARetryPolicy(this.getConf()), this.onRetry);
            this.instrumentation = new S3AInstrumentation(this.uri);
            this.owner = UserGroupInformation.getCurrentUser();
            this.username = this.owner.getShortUserName();
            this.workingDir = new Path("/user", this.username).makeQualified(this.uri, this.getWorkingDirectory());
            this.s3guardInvoker = new Invoker(new S3GuardExistsRetryPolicy(this.getConf()), this.onRetry);
            this.writeHelper = new WriteOperationHelper(this, this.getConf());
            this.failOnMetadataWriteError = conf.getBoolean("fs.s3a.metadatastore.fail.on.write.error", true);
            this.maxKeys = S3AUtils.intOption(conf, "fs.s3a.paging.maximum", 5000, 1);
            this.listing = new Listing(this);
            this.partSize = S3AUtils.getMultipartSizeProperty(conf, "fs.s3a.multipart.size", 0x4000000L);
            this.multiPartThreshold = S3AUtils.getMultipartSizeProperty(conf, "fs.s3a.multipart.threshold", 0x8000000L);
            S3AUtils.longBytesOption(conf, "fs.s3a.block.size", 0x2000000L, 1L);
            this.enableMultiObjectsDelete = conf.getBoolean("fs.s3a.multiobjectdelete.enable", true);
            this.readAhead = S3AUtils.longBytesOption(conf, "fs.s3a.readahead.range", 65536L, 0L);
            this.initThreadPools(conf);
            int listVersion = conf.getInt("fs.s3a.list.version", 2);
            if (listVersion < 1 || listVersion > 2) {
                LOG.warn("Configured fs.s3a.list.version {} is invalid, forcing version 2", (Object)listVersion);
            }
            this.useListV1 = listVersion == 1;
            this.signerManager = new SignerManager(this.bucket, this, conf, this.owner);
            this.signerManager.initCustomSigners();
            this.bindAWSClient(name, delegationTokensEnabled);
            this.initTransferManager();
            this.initCannedAcls(conf);
            this.doBucketProbing();
            this.inputPolicy = S3AInputPolicy.getPolicy(conf.getTrimmed("fs.s3a.experimental.input.fadvise", "normal"));
            LOG.debug("Input fadvise policy = {}", (Object)this.inputPolicy);
            this.changeDetectionPolicy = ChangeDetectionPolicy.getPolicy(conf);
            LOG.debug("Change detection policy = {}", (Object)this.changeDetectionPolicy);
            boolean magicCommitterEnabled = conf.getBoolean("fs.s3a.committer.magic.enabled", false);
            LOG.debug("Filesystem support for magic committers {} enabled", (Object)(magicCommitterEnabled ? "is" : "is not"));
            this.committerIntegration = new MagicCommitIntegration(this, magicCommitterEnabled);
            this.selectBinding = new SelectBinding(this.writeHelper);
            boolean blockUploadEnabled = conf.getBoolean("fs.s3a.fast.upload", true);
            if (!blockUploadEnabled) {
                LOG.warn("The \"slow\" output stream is no longer supported");
            }
            this.blockOutputBuffer = conf.getTrimmed("fs.s3a.fast.upload.buffer", "disk");
            this.partSize = S3AUtils.ensureOutputParameterInRange("fs.s3a.multipart.size", this.partSize);
            this.blockFactory = S3ADataBlocks.createFactory(this, this.blockOutputBuffer);
            this.blockOutputActiveBlocks = S3AUtils.intOption(conf, "fs.s3a.fast.upload.active.blocks", 4, 1);
            LOG.debug("Using S3ABlockOutputStream with buffer = {}; block={}; queue limit={}", new Object[]{this.blockOutputBuffer, this.partSize, this.blockOutputActiveBlocks});
            long authDirTtl = conf.getTimeDuration("fs.s3a.metadatastore.metadata.ttl", Constants.DEFAULT_METADATASTORE_METADATA_TTL, TimeUnit.MILLISECONDS);
            this.ttlTimeProvider = new S3Guard.TtlTimeProvider(authDirTtl);
            this.setMetadataStore(S3Guard.getMetadataStore(this, this.ttlTimeProvider));
            this.allowAuthoritativeMetadataStore = conf.getBoolean("fs.s3a.metadatastore.authoritative", false);
            this.allowAuthoritativePaths = S3Guard.getAuthoritativePaths(this);
            if (this.hasMetadataStore()) {
                LOG.debug("Using metadata store {}, authoritative store={}, authoritative path={}", new Object[]{this.getMetadataStore(), this.allowAuthoritativeMetadataStore, this.allowAuthoritativePaths});
            }
            if (!this.hasMetadataStore()) {
                String warnLevel = conf.getTrimmed("fs.s3a.s3guard.disabled.warn.level", "SILENT");
                S3Guard.logS3GuardDisabled(LOG, warnLevel, this.bucket);
            }
            this.initMultipartUploads(conf);
            this.pageSize = S3AUtils.intOption(this.getConf(), "fs.s3a.bulk.delete.page.size", 250, 0);
        }
        catch (AmazonClientException e) {
            this.stopAllServices();
            throw S3AUtils.translateException("initializing ", new Path(name), e);
        }
        catch (IOException | RuntimeException e) {
            this.stopAllServices();
            throw e;
        }
    }

    private void doBucketProbing() throws IOException {
        int bucketProbe = this.getConf().getInt("fs.s3a.bucket.probe", 2);
        Preconditions.checkArgument((bucketProbe >= 0 ? 1 : 0) != 0, (Object)"Value of fs.s3a.bucket.probe should be >= 0");
        switch (bucketProbe) {
            case 0: {
                LOG.debug("skipping check for bucket existence");
                break;
            }
            case 1: {
                NetworkBinding.logDnsLookup(this.getConf());
                this.verifyBucketExists();
                break;
            }
            case 2: {
                NetworkBinding.logDnsLookup(this.getConf());
                this.verifyBucketExistsV2();
                break;
            }
            default: {
                LOG.warn("Unknown bucket probe option {}: {}; falling back to check #2", (Object)"fs.s3a.bucket.probe", (Object)bucketProbe);
                this.verifyBucketExistsV2();
            }
        }
    }

    private void initThreadPools(Configuration conf) {
        int maxThreads = conf.getInt("fs.s3a.threads.max", 10);
        if (maxThreads < 2) {
            LOG.warn("fs.s3a.threads.max must be at least 2: forcing to 2.");
            maxThreads = 2;
        }
        int totalTasks = S3AUtils.intOption(conf, "fs.s3a.max.total.tasks", 32, 1);
        long keepAliveTime = S3AUtils.longOption(conf, "fs.s3a.threads.keepalivetime", 60L, 0L);
        this.boundedThreadPool = BlockingThreadPoolExecutorService.newInstance((int)maxThreads, (int)(maxThreads + totalTasks), (long)keepAliveTime, (TimeUnit)TimeUnit.SECONDS, (String)"s3a-transfer-shared");
        this.unboundedThreadPool = new ThreadPoolExecutor(maxThreads, Integer.MAX_VALUE, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), BlockingThreadPoolExecutorService.newDaemonThreadFactory((String)"s3a-transfer-unbounded"));
        this.unboundedThreadPool.allowCoreThreadTimeOut(true);
        this.executorCapacity = S3AUtils.intOption(conf, "fs.s3a.executor.capacity", 16, 1);
    }

    protected static S3AStorageStatistics createStorageStatistics() {
        return (S3AStorageStatistics)GlobalStorageStatistics.INSTANCE.put("S3AStorageStatistics", () -> new S3AStorageStatistics());
    }

    protected void verifyBucketExists() throws UnknownStoreException, IOException {
        if (!this.invoker.retry("doesBucketExist", this.bucket, true, () -> this.s3.doesBucketExist(this.bucket)).booleanValue()) {
            throw new UnknownStoreException("Bucket " + this.bucket + " does not exist");
        }
    }

    protected void verifyBucketExistsV2() throws UnknownStoreException, IOException {
        if (!this.invoker.retry("doesBucketExistV2", this.bucket, true, () -> this.s3.doesBucketExistV2(this.bucket)).booleanValue()) {
            throw new UnknownStoreException("Bucket " + this.bucket + " does not exist");
        }
    }

    public S3AInstrumentation getInstrumentation() {
        return this.instrumentation;
    }

    private void bindAWSClient(URI name, boolean dtEnabled) throws IOException {
        Configuration conf = this.getConf();
        this.credentials = null;
        String uaSuffix = "";
        if (dtEnabled) {
            LOG.debug("Using delegation tokens");
            S3ADelegationTokens tokens = new S3ADelegationTokens();
            this.delegationTokens = Optional.of(tokens);
            tokens.bindToFileSystem(this.getCanonicalUri(), this.createStoreContext(), this.createDelegationOperations());
            tokens.init(conf);
            tokens.start();
            if (tokens.isBoundToDT()) {
                LOG.debug("Using existing delegation token");
            } else {
                LOG.debug("No delegation token for this instance");
            }
            this.credentials = tokens.getCredentialProviders();
            tokens.getEncryptionSecrets().ifPresent(this::setEncryptionSecrets);
            uaSuffix = tokens.getUserAgentField();
        } else {
            this.credentials = S3AUtils.createAWSCredentialProviderSet(name, conf);
        }
        LOG.debug("Using credential provider {}", (Object)this.credentials);
        Class s3ClientFactoryClass = conf.getClass("fs.s3a.s3.client.factory.impl", Constants.DEFAULT_S3_CLIENT_FACTORY_IMPL, S3ClientFactory.class);
        this.s3 = ((S3ClientFactory)ReflectionUtils.newInstance((Class)s3ClientFactoryClass, (Configuration)conf)).createS3Client(this.getUri(), this.bucket, this.credentials, uaSuffix);
    }

    @VisibleForTesting
    public DelegationOperations createDelegationOperations() {
        return new DelegationOperationsImpl();
    }

    protected void setEncryptionSecrets(EncryptionSecrets secrets) {
        this.encryptionSecrets = secrets;
    }

    public EncryptionSecrets getEncryptionSecrets() {
        return this.encryptionSecrets;
    }

    private void initTransferManager() {
        TransferManagerConfiguration transferConfiguration = new TransferManagerConfiguration();
        transferConfiguration.setMinimumUploadPartSize(this.partSize);
        transferConfiguration.setMultipartUploadThreshold(this.multiPartThreshold);
        transferConfiguration.setMultipartCopyPartSize(this.partSize);
        transferConfiguration.setMultipartCopyThreshold(this.multiPartThreshold);
        this.transfers = new TransferManager(this.s3, (ExecutorService)this.unboundedThreadPool);
        this.transfers.setConfiguration(transferConfiguration);
    }

    private void initCannedAcls(Configuration conf) {
        String cannedACLName = conf.get("fs.s3a.acl.default", "");
        this.cannedACL = !cannedACLName.isEmpty() ? CannedAccessControlList.valueOf((String)cannedACLName) : null;
    }

    private void initMultipartUploads(Configuration conf) throws IOException {
        boolean purgeExistingMultipart = conf.getBoolean("fs.s3a.multipart.purge", false);
        long purgeExistingMultipartAge = S3AUtils.longOption(conf, "fs.s3a.multipart.purge.age", 86400L, 0L);
        if (purgeExistingMultipart) {
            try {
                this.abortOutstandingMultipartUploads(purgeExistingMultipartAge);
            }
            catch (AccessDeniedException e) {
                this.instrumentation.errorIgnored();
                LOG.debug("Failed to purge multipart uploads against {}, FS may be read only", (Object)this.bucket);
            }
        }
    }

    public void abortOutstandingMultipartUploads(long seconds) throws IOException {
        Preconditions.checkArgument((seconds >= 0L ? 1 : 0) != 0);
        Date purgeBefore = new Date(new Date().getTime() - seconds * 1000L);
        LOG.debug("Purging outstanding multipart uploads older than {}", (Object)purgeBefore);
        this.invoker.retry("Purging multipart uploads", this.bucket, true, () -> this.transfers.abortMultipartUploads(this.bucket, purgeBefore));
    }

    public String getScheme() {
        return "s3a";
    }

    public URI getUri() {
        return this.uri;
    }

    @VisibleForTesting
    protected void setUri(URI fsUri, boolean canonicalize) {
        URI u = S3xLoginHelper.buildFSURI(fsUri);
        this.uri = canonicalize ? u : this.canonicalizeUri(u);
    }

    public URI getCanonicalUri() {
        return this.uri;
    }

    @VisibleForTesting
    public int getDefaultPort() {
        return 0;
    }

    AmazonS3 getAmazonS3Client() {
        return this.s3;
    }

    @VisibleForTesting
    public AmazonS3 getAmazonS3ClientForTesting(String reason) {
        LOG.warn("Access to S3A client requested, reason {}", (Object)reason);
        return this.s3;
    }

    protected void setAmazonS3Client(AmazonS3 client) {
        Preconditions.checkNotNull((Object)client, (Object)"client");
        LOG.debug("Setting S3 client to {}", (Object)client);
        this.s3 = client;
        this.initThreadPools(this.getConf());
        this.initTransferManager();
    }

    public String getBucketLocation() throws IOException {
        return this.getBucketLocation(this.bucket);
    }

    @VisibleForTesting
    public String getBucketLocation(String bucketName) throws IOException {
        String region = this.invoker.retry("getBucketLocation()", bucketName, true, () -> this.s3.getBucketLocation(bucketName));
        return NetworkBinding.fixBucketRegion(region);
    }

    @VisibleForTesting
    long getReadAheadRange() {
        return this.readAhead;
    }

    @InterfaceStability.Unstable
    public S3AInputPolicy getInputPolicy() {
        return this.inputPolicy;
    }

    @VisibleForTesting
    public ChangeDetectionPolicy getChangeDetectionPolicy() {
        return this.changeDetectionPolicy;
    }

    public S3AEncryptionMethods getServerSideEncryptionAlgorithm() {
        return this.encryptionSecrets.getEncryptionMethod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File createTmpFileForWrite(String pathStr, long size, Configuration conf) throws IOException {
        if (this.directoryAllocator == null) {
            S3AFileSystem s3AFileSystem = this;
            synchronized (s3AFileSystem) {
                String bufferDir = conf.get("fs.s3a.buffer.dir") != null ? "fs.s3a.buffer.dir" : "hadoop.tmp.dir";
                this.directoryAllocator = new LocalDirAllocator(bufferDir);
            }
        }
        Path path = this.directoryAllocator.getLocalPathForWrite(pathStr, size, conf);
        File dir = new File(path.getParent().toUri().getPath());
        String prefix = path.getName();
        return File.createTempFile(prefix, null, dir);
    }

    public String getBucket() {
        return this.bucket;
    }

    @VisibleForTesting
    protected void setBucket(String bucket) {
        this.bucket = bucket;
    }

    CannedAccessControlList getCannedACL() {
        return this.cannedACL;
    }

    @InterfaceStability.Unstable
    public void setInputPolicy(S3AInputPolicy inputPolicy) {
        Objects.requireNonNull(inputPolicy, "Null inputStrategy");
        LOG.debug("Setting input strategy: {}", (Object)inputPolicy);
        this.inputPolicy = inputPolicy;
    }

    @VisibleForTesting
    public String pathToKey(Path path) {
        if (!path.isAbsolute()) {
            path = new Path(this.workingDir, path);
        }
        if (path.toUri().getScheme() != null && path.toUri().getPath().isEmpty()) {
            return "";
        }
        return path.toUri().getPath().substring(1);
    }

    @InterfaceAudience.Private
    public String maybeAddTrailingSlash(String key) {
        return S3AUtils.maybeAddTrailingSlash(key);
    }

    Path keyToPath(String key) {
        return new Path("/" + key);
    }

    public Path keyToQualifiedPath(String key) {
        return this.qualify(this.keyToPath(key));
    }

    public Path makeQualified(Path path) {
        String urlString;
        Path q = super.makeQualified(path);
        if (!q.isRoot() && (urlString = q.toUri().toString()).endsWith("/")) {
            LOG.debug("Stripping trailing '/' from {}", (Object)q);
            q = new Path(urlString.substring(0, urlString.length() - 1));
        }
        if (!q.isRoot() && q.getName().isEmpty()) {
            q = q.getParent();
        }
        return q;
    }

    public Path qualify(Path path) {
        return this.makeQualified(path);
    }

    public void checkPath(Path path) {
        S3xLoginHelper.checkPath(this.getConf(), this.getUri(), path, this.getDefaultPort());
    }

    protected URI canonicalizeUri(URI rawUri) {
        return S3xLoginHelper.canonicalizeUri(rawUri, this.getDefaultPort());
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        return this.open(f, Optional.empty(), Optional.empty());
    }

    private FSDataInputStream open(Path file, Optional<Configuration> options, Optional<S3AFileStatus> providedStatus) throws IOException {
        S3AReadOpContext readContext;
        this.entryPoint(Statistic.INVOCATION_OPEN);
        Path path = this.qualify(file);
        S3AFileStatus fileStatus = this.extractOrFetchSimpleFileStatus(path, providedStatus);
        if (options.isPresent()) {
            Configuration o = options.get();
            S3AInputPolicy policy = S3AInputPolicy.getPolicy(o.get("fs.s3a.experimental.input.fadvise", this.inputPolicy.toString()));
            long readAheadRange2 = o.getLong("fs.s3a.readahead.range", this.readAhead);
            readContext = this.createReadContext(fileStatus, policy, this.changeDetectionPolicy, readAheadRange2);
        } else {
            readContext = this.createReadContext(fileStatus, this.inputPolicy, this.changeDetectionPolicy, this.readAhead);
        }
        LOG.debug("Opening '{}'", (Object)readContext);
        return new FSDataInputStream((InputStream)((Object)new S3AInputStream(readContext, this.createObjectAttributes(fileStatus), this.s3)));
    }

    private S3AReadOpContext createReadContext(FileStatus fileStatus, S3AInputPolicy seekPolicy, ChangeDetectionPolicy changePolicy, long readAheadRange) {
        return new S3AReadOpContext(fileStatus.getPath(), this.hasMetadataStore(), this.invoker, this.s3guardInvoker, this.statistics, this.instrumentation, fileStatus, seekPolicy, changePolicy, readAheadRange);
    }

    private S3ObjectAttributes createObjectAttributes(Path f, String eTag, String versionId, long len) {
        return new S3ObjectAttributes(this.bucket, f, this.pathToKey(f), this.getServerSideEncryptionAlgorithm(), this.encryptionSecrets.getEncryptionKey(), eTag, versionId, len);
    }

    private S3ObjectAttributes createObjectAttributes(S3AFileStatus fileStatus) {
        return this.createObjectAttributes(fileStatus.getPath(), fileStatus.getETag(), fileStatus.getVersionId(), fileStatus.getLen());
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.entryPoint(Statistic.INVOCATION_CREATE);
        Path path = this.qualify(f);
        String key = this.pathToKey(path);
        S3AFileStatus status = null;
        try {
            status = this.innerGetFileStatus(path, false, overwrite ? StatusProbeEnum.DIRECTORIES : StatusProbeEnum.ALL);
            if (status.isDirectory()) {
                throw new FileAlreadyExistsException(path + " is a directory");
            }
            if (!overwrite) {
                throw new FileAlreadyExistsException(path + " already exists");
            }
            LOG.debug("Overwriting file {}", (Object)path);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.instrumentation.fileCreated();
        PutTracker putTracker = this.committerIntegration.createTracker(path, key);
        String destKey = putTracker.getDestKey();
        return new FSDataOutputStream((OutputStream)new S3ABlockOutputStream(this, destKey, (ExecutorService)new SemaphoredDelegatingExecutor(this.boundedThreadPool, this.blockOutputActiveBlocks, true), progress, this.partSize, this.blockFactory, this.instrumentation.newOutputStreamStatistics(this.statistics), this.getWriteOperationHelper(), putTracker), null);
    }

    @InterfaceAudience.Private
    public WriteOperationHelper getWriteOperationHelper() {
        return this.writeHelper;
    }

    public FSDataOutputStream createNonRecursive(Path path, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.entryPoint(Statistic.INVOCATION_CREATE_NON_RECURSIVE);
        Path parent = path.getParent();
        if (parent != null && !this.getFileStatus(parent).isDirectory()) {
            throw new FileAlreadyExistsException("Not a directory: " + parent);
        }
        return this.create(path, permission, flags.contains(CreateFlag.OVERWRITE), bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException("Append is not supported by S3AFileSystem");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean rename(Path src, Path dst) throws IOException {
        try (DurationInfo ignored = new DurationInfo(LOG, false, "rename(%s, %s", new Object[]{src, dst});){
            long bytesCopied = this.innerRename(src, dst);
            LOG.debug("Copied {} bytes", (Object)bytesCopied);
            boolean bl = true;
            return bl;
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("rename(" + src + ", " + dst + ")", src, e);
        }
        catch (RenameFailedException e) {
            LOG.info("{}", (Object)e.getMessage());
            LOG.debug("rename failure", (Throwable)((Object)e));
            return e.getExitCode();
        }
        catch (FileNotFoundException e) {
            LOG.debug(e.toString());
            return false;
        }
    }

    private Pair<S3AFileStatus, S3AFileStatus> initiateRename(Path src, Path dst) throws IOException {
        S3AFileStatus dstStatus;
        S3AFileStatus srcStatus;
        block13: {
            String srcKey = this.pathToKey(src);
            String dstKey = this.pathToKey(dst);
            if (srcKey.isEmpty()) {
                throw new RenameFailedException(src, dst, "source is root directory");
            }
            if (dstKey.isEmpty()) {
                throw new RenameFailedException(src, dst, "dest is root directory");
            }
            srcStatus = this.innerGetFileStatus(src, true, StatusProbeEnum.ALL);
            if (srcKey.equals(dstKey)) {
                LOG.debug("rename: src and dest refer to the same file or directory: {}", (Object)dst);
                throw new RenameFailedException(src, dst, "source and dest refer to the same file or directory").withExitCode(srcStatus.isFile());
            }
            dstStatus = null;
            try {
                dstStatus = this.innerGetFileStatus(dst, true, StatusProbeEnum.ALL);
                if (srcStatus.isDirectory()) {
                    if (dstStatus.isFile()) {
                        throw new RenameFailedException(src, dst, "source is a directory and dest is a file").withExitCode(srcStatus.isFile());
                    }
                    if (dstStatus.isEmptyDirectory() != Tristate.TRUE) {
                        throw new RenameFailedException(src, dst, "Destination is a non-empty directory").withExitCode(false);
                    }
                } else if (dstStatus.isFile()) {
                    throw new RenameFailedException(src, dst, "Cannot rename onto an existing file").withExitCode(false);
                }
            }
            catch (FileNotFoundException e) {
                LOG.debug("rename: destination path {} not found", (Object)dst);
                Path parent = dst.getParent();
                if (this.pathToKey(parent).isEmpty()) break block13;
                try {
                    S3AFileStatus dstParentStatus = this.innerGetFileStatus(dst.getParent(), false, StatusProbeEnum.ALL);
                    if (!dstParentStatus.isDirectory()) {
                        throw new RenameFailedException(src, dst, "destination parent is not a directory");
                    }
                }
                catch (FileNotFoundException e2) {
                    throw new RenameFailedException(src, dst, "destination has no parent ");
                }
            }
        }
        return Pair.of((Object)((Object)srcStatus), (Object)((Object)dstStatus));
    }

    private long innerRename(Path source, Path dest) throws RenameFailedException, FileNotFoundException, IOException, AmazonClientException {
        Path src = this.qualify(source);
        Path dst = this.qualify(dest);
        LOG.debug("Rename path {} to {}", (Object)src, (Object)dst);
        this.entryPoint(Statistic.INVOCATION_RENAME);
        String srcKey = this.pathToKey(src);
        String dstKey = this.pathToKey(dst);
        Pair<S3AFileStatus, S3AFileStatus> p = this.initiateRename(src, dst);
        RenameOperation renameOperation = new RenameOperation(this.createStoreContext(), src, srcKey, (S3AFileStatus)((Object)p.getLeft()), dst, dstKey, (S3AFileStatus)((Object)p.getRight()), this.operationCallbacks, this.pageSize);
        return renameOperation.execute();
    }

    @Override
    public Token<? extends TokenIdentifier> getFsDelegationToken() throws IOException {
        return this.getDelegationToken(null);
    }

    @VisibleForTesting
    public ObjectMetadata getObjectMetadata(Path path) throws IOException {
        return this.getObjectMetadata(path, null, this.invoker, null);
    }

    @VisibleForTesting
    public ObjectMetadata getObjectMetadata(Path path, ChangeTracker changeTracker, Invoker changeInvoker, String operation) throws IOException {
        this.checkNotClosed();
        return Invoker.once("getObjectMetadata", path.toString(), () -> this.getObjectMetadata(this.pathToKey(path), changeTracker, changeInvoker, operation));
    }

    public Map<String, Object> getObjectHeaders(Path path) throws IOException {
        LOG.debug("getObjectHeaders({})", (Object)path);
        this.checkNotClosed();
        this.incrementReadOperations();
        return this.getObjectMetadata(path).getRawMetadata();
    }

    public boolean hasMetadataStore() {
        return !S3Guard.isNullMetadataStore(this.metadataStore);
    }

    @VisibleForTesting
    public boolean hasAuthoritativeMetadataStore() {
        return this.hasMetadataStore() && this.allowAuthoritativeMetadataStore;
    }

    @VisibleForTesting
    public MetadataStore getMetadataStore() {
        return this.metadataStore;
    }

    @VisibleForTesting
    void setMetadataStore(MetadataStore ms) {
        Preconditions.checkNotNull((Object)ms);
        this.metadataStore = ms;
    }

    protected void entryPoint(Statistic operation) throws IOException {
        this.checkNotClosed();
        this.incrementStatistic(operation);
    }

    protected void incrementStatistic(Statistic statistic) {
        this.incrementStatistic(statistic, 1L);
    }

    protected void incrementStatistic(Statistic statistic, long count) {
        this.instrumentation.incrementCounter(statistic, count);
        this.storageStatistics.incrementCounter(statistic, count);
    }

    protected void decrementGauge(Statistic statistic, long count) {
        this.instrumentation.decrementGauge(statistic, count);
    }

    protected void incrementGauge(Statistic statistic, long count) {
        this.instrumentation.incrementGauge(statistic, count);
    }

    public void operationRetried(Exception ex) {
        if (S3AUtils.isThrottleException(ex)) {
            this.operationThrottled(false);
        } else {
            this.incrementStatistic(Statistic.IGNORED_ERRORS);
        }
    }

    public void operationRetried(String text, Exception ex, int retries, boolean idempotent) {
        this.operationRetried(ex);
    }

    public void metastoreOperationRetried(Exception ex, int retries, boolean idempotent) {
        this.incrementStatistic(Statistic.S3GUARD_METADATASTORE_RETRY);
        if (S3AUtils.isThrottleException(ex)) {
            this.operationThrottled(true);
        } else {
            this.incrementStatistic(Statistic.IGNORED_ERRORS);
        }
    }

    private void operationThrottled(boolean metastore) {
        LOG.debug("Request throttled on {}", (Object)(metastore ? "S3" : "DynamoDB"));
        if (metastore) {
            this.incrementStatistic(Statistic.S3GUARD_METADATASTORE_THROTTLED);
            this.instrumentation.addValueToQuantiles(Statistic.S3GUARD_METADATASTORE_THROTTLE_RATE, 1L);
        } else {
            this.incrementStatistic(Statistic.STORE_IO_THROTTLED);
            this.instrumentation.addValueToQuantiles(Statistic.STORE_IO_THROTTLE_RATE, 1L);
        }
    }

    public S3AStorageStatistics getStorageStatistics() {
        return this.storageStatistics;
    }

    @VisibleForTesting
    ObjectMetadata getObjectMetadata(String key) throws IOException {
        return this.getObjectMetadata(key, null, this.invoker, null);
    }

    protected ObjectMetadata getObjectMetadata(String key, ChangeTracker changeTracker, Invoker changeInvoker, String operation) throws IOException {
        GetObjectMetadataRequest request = new GetObjectMetadataRequest(this.bucket, key);
        this.generateSSECustomerKey().ifPresent(arg_0 -> ((GetObjectMetadataRequest)request).setSSECustomerKey(arg_0));
        ObjectMetadata meta = changeInvoker.retryUntranslated("GET " + key, true, () -> {
            this.incrementStatistic(Statistic.OBJECT_METADATA_REQUESTS);
            LOG.debug("HEAD {} with change tracker {}", (Object)key, (Object)changeTracker);
            if (changeTracker != null) {
                changeTracker.maybeApplyConstraint(request);
            }
            ObjectMetadata objectMetadata = this.s3.getObjectMetadata(request);
            if (changeTracker != null) {
                changeTracker.processMetadata(objectMetadata, operation);
            }
            return objectMetadata;
        });
        this.incrementReadOperations();
        return meta;
    }

    protected S3ListResult listObjects(S3ListRequest request) throws IOException {
        this.incrementReadOperations();
        this.incrementStatistic(Statistic.OBJECT_LIST_REQUESTS);
        this.validateListArguments(request);
        try (DurationInfo ignored = new DurationInfo(LOG, false, "LIST", new Object[0]);){
            S3ListResult s3ListResult = this.invoker.retryUntranslated(request.toString(), true, () -> {
                if (this.useListV1) {
                    return S3ListResult.v1(this.s3.listObjects(request.getV1()));
                }
                return S3ListResult.v2(this.s3.listObjectsV2(request.getV2()));
            });
            return s3ListResult;
        }
    }

    private void validateListArguments(S3ListRequest request) {
        if (this.useListV1) {
            Preconditions.checkArgument((boolean)request.isV1());
        } else {
            Preconditions.checkArgument((!request.isV1() ? 1 : 0) != 0);
        }
    }

    protected S3ListResult continueListObjects(S3ListRequest request, S3ListResult prevResult) throws IOException {
        this.incrementReadOperations();
        this.validateListArguments(request);
        try (DurationInfo ignored = new DurationInfo(LOG, false, "LIST (continued)", new Object[0]);){
            S3ListResult s3ListResult = this.invoker.retryUntranslated(request.toString(), true, () -> {
                this.incrementStatistic(Statistic.OBJECT_CONTINUE_LIST_REQUESTS);
                if (this.useListV1) {
                    return S3ListResult.v1(this.s3.listNextBatchOfObjects(prevResult.getV1()));
                }
                request.getV2().setContinuationToken(prevResult.getV2().getNextContinuationToken());
                return S3ListResult.v2(this.s3.listObjectsV2(request.getV2()));
            });
            return s3ListResult;
        }
    }

    public void incrementReadOperations() {
        this.statistics.incrementReadOps(1);
    }

    public void incrementWriteOperations() {
        this.statistics.incrementWriteOps(1);
    }

    @VisibleForTesting
    protected void deleteObject(String key) throws AmazonClientException, IOException {
        this.blockRootDelete(key);
        this.incrementWriteOperations();
        try (DurationInfo ignored = new DurationInfo(LOG, false, "deleting %s", new Object[]{key});){
            this.invoker.retryUntranslated(String.format("Delete %s:/%s", this.bucket, key), true, () -> {
                this.incrementStatistic(Statistic.OBJECT_DELETE_REQUESTS);
                this.s3.deleteObject(this.bucket, key);
                return null;
            });
        }
    }

    void deleteObjectAtPath(Path f, String key, boolean isFile, @Nullable BulkOperationState operationState) throws AmazonClientException, IOException {
        if (isFile) {
            this.instrumentation.fileDeleted(1);
        } else {
            this.instrumentation.directoryDeleted();
        }
        this.deleteObject(key);
        this.metadataStore.delete(f, operationState);
    }

    private void blockRootDelete(String key) throws InvalidRequestException {
        if (key.isEmpty() || "/".equals(key)) {
            throw new InvalidRequestException("Bucket " + this.bucket + " cannot be deleted");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DeleteObjectsResult deleteObjects(DeleteObjectsRequest deleteRequest) throws MultiObjectDeleteException, AmazonClientException, IOException {
        this.incrementWriteOperations();
        BulkDeleteRetryHandler retryHandler = new BulkDeleteRetryHandler(this.createStoreContext());
        try (DurationInfo ignored = new DurationInfo(LOG, false, "DELETE %d keys", new Object[]{deleteRequest.getKeys().size()});){
            DeleteObjectsResult deleteObjectsResult = this.invoker.retryUntranslated("delete", true, (text, e, r, i) -> retryHandler.bulkDeleteRetried(deleteRequest, e), () -> {
                this.incrementStatistic(Statistic.OBJECT_DELETE_REQUESTS, 1L);
                return this.s3.deleteObjects(deleteRequest);
            });
            return deleteObjectsResult;
        }
        catch (MultiObjectDeleteException e2) {
            List errors = e2.getErrors();
            LOG.debug("Partial failure of delete, {} errors", (Object)errors.size(), (Object)e2);
            Iterator iterator = errors.iterator();
            while (iterator.hasNext()) {
                MultiObjectDeleteException.DeleteError error = (MultiObjectDeleteException.DeleteError)iterator.next();
                LOG.debug("{}: \"{}\" - {}", new Object[]{error.getKey(), error.getCode(), error.getMessage()});
            }
            throw e2;
        }
    }

    public PutObjectRequest newPutObjectRequest(String key, ObjectMetadata metadata, File srcfile) {
        Preconditions.checkNotNull((Object)srcfile);
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucket, key, srcfile);
        this.setOptionalPutRequestParameters(putObjectRequest);
        putObjectRequest.setCannedAcl(this.cannedACL);
        putObjectRequest.setMetadata(metadata);
        return putObjectRequest;
    }

    PutObjectRequest newPutObjectRequest(String key, ObjectMetadata metadata, InputStream inputStream) {
        Preconditions.checkNotNull((Object)inputStream);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)key), (Object)"Null/empty key");
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucket, key, inputStream, metadata);
        this.setOptionalPutRequestParameters(putObjectRequest);
        putObjectRequest.setCannedAcl(this.cannedACL);
        return putObjectRequest;
    }

    public ObjectMetadata newObjectMetadata() {
        ObjectMetadata om = new ObjectMetadata();
        this.setOptionalObjectMetadata(om);
        return om;
    }

    public ObjectMetadata newObjectMetadata(long length) {
        ObjectMetadata om = this.newObjectMetadata();
        if (length >= 0L) {
            om.setContentLength(length);
        }
        return om;
    }

    public UploadInfo putObject(PutObjectRequest putObjectRequest) {
        long len = this.getPutRequestLength(putObjectRequest);
        LOG.debug("PUT {} bytes to {} via transfer manager ", (Object)len, (Object)putObjectRequest.getKey());
        this.incrementPutStartStatistics(len);
        Upload upload = this.transfers.upload(putObjectRequest);
        return new UploadInfo(upload, len);
    }

    PutObjectResult putObjectDirect(PutObjectRequest putObjectRequest) throws AmazonClientException, MetadataPersistenceException {
        long len = this.getPutRequestLength(putObjectRequest);
        LOG.debug("PUT {} bytes to {}", (Object)len, (Object)putObjectRequest.getKey());
        this.incrementPutStartStatistics(len);
        try {
            PutObjectResult result = this.s3.putObject(putObjectRequest);
            this.incrementPutCompletedStatistics(true, len);
            this.finishedWrite(putObjectRequest.getKey(), len, result.getETag(), result.getVersionId(), null);
            return result;
        }
        catch (AmazonClientException e) {
            this.incrementPutCompletedStatistics(false, len);
            throw e;
        }
    }

    private long getPutRequestLength(PutObjectRequest putObjectRequest) {
        long len = putObjectRequest.getFile() != null ? putObjectRequest.getFile().length() : putObjectRequest.getMetadata().getContentLength();
        Preconditions.checkState((len >= 0L ? 1 : 0) != 0, (Object)"Cannot PUT object of unknown length");
        return len;
    }

    UploadPartResult uploadPart(UploadPartRequest request) throws AmazonClientException {
        long len = request.getPartSize();
        this.incrementPutStartStatistics(len);
        try {
            this.setOptionalUploadPartRequestParameters(request);
            UploadPartResult uploadPartResult = this.s3.uploadPart(request);
            this.incrementPutCompletedStatistics(true, len);
            return uploadPartResult;
        }
        catch (AmazonClientException e) {
            this.incrementPutCompletedStatistics(false, len);
            throw e;
        }
    }

    public void incrementPutStartStatistics(long bytes) {
        LOG.debug("PUT start {} bytes", (Object)bytes);
        this.incrementWriteOperations();
        this.incrementStatistic(Statistic.OBJECT_PUT_REQUESTS);
        this.incrementGauge(Statistic.OBJECT_PUT_REQUESTS_ACTIVE, 1L);
        if (bytes > 0L) {
            this.incrementGauge(Statistic.OBJECT_PUT_BYTES_PENDING, bytes);
        }
    }

    public void incrementPutCompletedStatistics(boolean success, long bytes) {
        LOG.debug("PUT completed success={}; {} bytes", (Object)success, (Object)bytes);
        this.incrementWriteOperations();
        if (bytes > 0L) {
            this.incrementStatistic(Statistic.OBJECT_PUT_BYTES, bytes);
            this.decrementGauge(Statistic.OBJECT_PUT_BYTES_PENDING, bytes);
        }
        this.incrementStatistic(Statistic.OBJECT_PUT_REQUESTS_COMPLETED);
        this.decrementGauge(Statistic.OBJECT_PUT_REQUESTS_ACTIVE, 1L);
    }

    public void incrementPutProgressStatistics(String key, long bytes) {
        PROGRESS.debug("PUT {}: {} bytes", (Object)key, (Object)bytes);
        this.incrementWriteOperations();
        if (bytes > 0L) {
            this.statistics.incrementBytesWritten(bytes);
        }
    }

    private DeleteObjectsResult removeKeysS3(List<DeleteObjectsRequest.KeyVersion> keysToDelete, boolean deleteFakeDir, boolean quiet) throws MultiObjectDeleteException, AmazonClientException, IOException {
        DeleteObjectsResult result = null;
        if (keysToDelete.isEmpty()) {
            return result;
        }
        for (DeleteObjectsRequest.KeyVersion keyVersion : keysToDelete) {
            this.blockRootDelete(keyVersion.getKey());
        }
        try {
            if (this.enableMultiObjectsDelete) {
                result = this.deleteObjects(new DeleteObjectsRequest(this.bucket).withKeys(keysToDelete).withQuiet(quiet));
            } else {
                for (DeleteObjectsRequest.KeyVersion keyVersion : keysToDelete) {
                    this.deleteObject(keyVersion.getKey());
                }
            }
        }
        catch (MultiObjectDeleteException ex) {
            int rejected = ex.getErrors().size();
            this.noteDeleted(keysToDelete.size() - rejected, deleteFakeDir);
            this.incrementStatistic(Statistic.FILES_DELETE_REJECTED, rejected);
            throw ex;
        }
        this.noteDeleted(keysToDelete.size(), deleteFakeDir);
        return result;
    }

    private void noteDeleted(int count, boolean deleteFakeDir) {
        if (!deleteFakeDir) {
            this.instrumentation.fileDeleted(count);
        } else {
            this.instrumentation.fakeDirsDeleted(count);
        }
    }

    @VisibleForTesting
    public void removeKeys(List<DeleteObjectsRequest.KeyVersion> keysToDelete, boolean deleteFakeDir, BulkOperationState operationState) throws MultiObjectDeleteException, AmazonClientException, IOException {
        this.removeKeys(keysToDelete, deleteFakeDir, new ArrayList<Path>(), operationState, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    DeleteObjectsResult removeKeys(List<DeleteObjectsRequest.KeyVersion> keysToDelete, boolean deleteFakeDir, List<Path> undeletedObjectsOnFailure, BulkOperationState operationState, boolean quiet) throws MultiObjectDeleteException, AmazonClientException, IOException {
        undeletedObjectsOnFailure.clear();
        try (DurationInfo ignored = new DurationInfo(LOG, false, "Deleting", new Object[0]);){
            DeleteObjectsResult deleteObjectsResult = this.removeKeysS3(keysToDelete, deleteFakeDir, quiet);
            return deleteObjectsResult;
        }
        catch (MultiObjectDeleteException ex) {
            LOG.debug("Partial delete failure");
            if (deleteFakeDir) throw ex;
            Triple<List<Path>, List<Path>, List<Pair<Path, IOException>>> results = new MultiObjectDeleteSupport(this.createStoreContext(), operationState).processDeleteFailure(ex, keysToDelete);
            undeletedObjectsOnFailure.addAll((Collection)results.getMiddle());
            throw ex;
        }
        catch (AmazonClientException | IOException ex) {
            List<Path> paths = new MultiObjectDeleteSupport(this.createStoreContext(), operationState).processDeleteFailureGenericException((Exception)ex, keysToDelete);
            undeletedObjectsOnFailure.addAll(paths);
            throw ex;
        }
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        try {
            this.entryPoint(Statistic.INVOCATION_DELETE);
            DeleteOperation deleteOperation = new DeleteOperation(this.createStoreContext(), this.innerGetFileStatus(f, true, StatusProbeEnum.ALL), recursive, this.operationCallbacks, this.pageSize);
            boolean outcome = deleteOperation.execute();
            if (outcome) {
                try {
                    this.maybeCreateFakeParentDirectory(f);
                }
                catch (AccessDeniedException e) {
                    LOG.warn("Cannot create directory marker at {}: {}", (Object)f.getParent(), (Object)e.toString());
                    LOG.debug("Failed to create fake dir above {}", (Object)f, (Object)e);
                }
            }
            return outcome;
        }
        catch (FileNotFoundException e) {
            LOG.debug("Couldn't delete {} - does not exist: {}", (Object)f, (Object)e.toString());
            this.instrumentation.errorIgnored();
            return false;
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("delete", f, e);
        }
    }

    private void createFakeDirectoryIfNecessary(Path f) throws IOException, AmazonClientException {
        String key = this.pathToKey(f);
        if (!key.isEmpty() && !this.s3Exists(f, EnumSet.of(StatusProbeEnum.List))) {
            LOG.debug("Creating new fake directory at {}", (Object)f);
            this.createFakeDirectory(key);
        }
    }

    void maybeCreateFakeParentDirectory(Path path) throws IOException, AmazonClientException {
        Path parent = path.getParent();
        if (parent != null) {
            this.createFakeDirectoryIfNecessary(parent);
        }
    }

    public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
        return Invoker.once("listStatus", f.toString(), () -> this.innerListStatus(f));
    }

    public FileStatus[] innerListStatus(Path f) throws FileNotFoundException, IOException, AmazonClientException {
        Path path = this.qualify(f);
        String key = this.pathToKey(path);
        LOG.debug("List status for path: {}", (Object)path);
        this.entryPoint(Statistic.INVOCATION_LIST_STATUS);
        FileStatus fileStatus = this.getFileStatus(path);
        if (fileStatus.isDirectory()) {
            if (!key.isEmpty()) {
                key = key + '/';
            }
            boolean allowAuthoritative = this.allowAuthoritative(f);
            DirListingMetadata dirMeta = S3Guard.listChildrenWithTtl(this.metadataStore, path, this.ttlTimeProvider, allowAuthoritative);
            if (allowAuthoritative && dirMeta != null && dirMeta.isAuthoritative()) {
                return S3Guard.dirMetaToStatuses(dirMeta);
            }
            S3ListRequest request = this.createListObjectsRequest(key, "/");
            LOG.debug("listStatus: doing listObjects for directory {}", (Object)key);
            Listing.FileStatusListingIterator files = this.listing.createFileStatusListingIterator(path, request, S3AUtils.ACCEPT_ALL, new Listing.AcceptAllButSelfAndS3nDirs(path));
            ArrayList<S3AFileStatus> result = new ArrayList<S3AFileStatus>(files.getBatchSize());
            while (files.hasNext()) {
                result.add(files.next());
            }
            return S3Guard.dirListingUnion(this.metadataStore, path, result, dirMeta, allowAuthoritative, this.ttlTimeProvider);
        }
        LOG.debug("Adding: rd (not a dir): {}", (Object)path);
        FileStatus[] stats = new FileStatus[]{fileStatus};
        return stats;
    }

    public boolean allowAuthoritative(Path path) {
        return S3Guard.allowAuthoritative(path, this, this.allowAuthoritativeMetadataStore, this.allowAuthoritativePaths);
    }

    @VisibleForTesting
    public S3ListRequest createListObjectsRequest(String key, String delimiter) {
        return this.createListObjectsRequest(key, delimiter, null);
    }

    private S3ListRequest createListObjectsRequest(String key, String delimiter, Integer overrideMaxKeys) {
        if (!this.useListV1) {
            ListObjectsV2Request request = new ListObjectsV2Request().withBucketName(this.bucket).withMaxKeys(Integer.valueOf(this.maxKeys)).withPrefix(key);
            if (delimiter != null) {
                request.setDelimiter(delimiter);
            }
            if (overrideMaxKeys != null) {
                request.setMaxKeys(overrideMaxKeys);
            }
            return S3ListRequest.v2(request);
        }
        ListObjectsRequest request = new ListObjectsRequest();
        request.setBucketName(this.bucket);
        request.setMaxKeys(Integer.valueOf(this.maxKeys));
        request.setPrefix(key);
        if (delimiter != null) {
            request.setDelimiter(delimiter);
        }
        if (overrideMaxKeys != null) {
            request.setMaxKeys(overrideMaxKeys);
        }
        return S3ListRequest.v1(request);
    }

    public void setWorkingDirectory(Path newDir) {
        this.workingDir = this.makeQualified(newDir);
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public String getUsername() {
        return this.username;
    }

    public UserGroupInformation getOwner() {
        return this.owner;
    }

    public boolean mkdirs(Path path, FsPermission permission) throws IOException, FileAlreadyExistsException {
        try {
            return this.innerMkdirs(path, permission);
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("innerMkdirs", path, e);
        }
    }

    private boolean innerMkdirs(Path p, FsPermission permission) throws IOException, FileAlreadyExistsException, AmazonClientException {
        Path f = this.qualify(p);
        LOG.debug("Making directory: {}", (Object)f);
        this.entryPoint(Statistic.INVOCATION_MKDIRS);
        try {
            FileStatus fileStatus = this.getFileStatus(f);
            if (fileStatus.isDirectory()) {
                return true;
            }
            throw new FileAlreadyExistsException("Path is a file: " + f);
        }
        catch (FileNotFoundException e) {
            for (Path fPart = f.getParent(); fPart != null; fPart = fPart.getParent()) {
                try {
                    FileStatus fileStatus = this.getFileStatus(fPart);
                    if (fileStatus.isDirectory()) break;
                    if (!fileStatus.isFile()) continue;
                    throw new FileAlreadyExistsException(String.format("Can't make directory for path '%s' since it is a file.", fPart));
                }
                catch (FileNotFoundException fnfe) {
                    this.instrumentation.errorIgnored();
                }
            }
            String key = this.pathToKey(f);
            this.createFakeDirectory(key);
            return true;
        }
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        this.entryPoint(Statistic.INVOCATION_GET_FILE_STATUS);
        return this.innerGetFileStatus(f, false, StatusProbeEnum.ALL);
    }

    @VisibleForTesting
    S3AFileStatus innerGetFileStatus(Path f, boolean needEmptyDirectoryFlag, Set<StatusProbeEnum> probes) throws IOException {
        Path path = this.qualify(f);
        String key = this.pathToKey(path);
        LOG.debug("Getting path status for {}  ({})", (Object)path, (Object)key);
        boolean allowAuthoritative = this.allowAuthoritative(path);
        PathMetadata pm = null;
        if (this.hasMetadataStore()) {
            pm = S3Guard.getWithTtl(this.metadataStore, path, this.ttlTimeProvider, needEmptyDirectoryFlag, allowAuthoritative);
        }
        Set<Path> tombstones = Collections.emptySet();
        if (pm != null) {
            S3AFileStatus s3FileStatus;
            if (pm.isDeleted()) {
                OffsetDateTime deletedAt = OffsetDateTime.ofInstant(Instant.ofEpochMilli(pm.getFileStatus().getModificationTime()), ZoneOffset.UTC);
                throw new FileNotFoundException("Path " + path + " is recorded as deleted by S3Guard at " + deletedAt);
            }
            if (!pm.getFileStatus().isDirectory() && !allowAuthoritative && probes.contains((Object)StatusProbeEnum.Head)) {
                S3AFileStatus s3AFileStatus;
                LOG.debug("Metadata for {} found in the non-auth metastore.", (Object)path);
                long msModTime = pm.getFileStatus().getModificationTime();
                try {
                    s3AFileStatus = this.s3GetFileStatus(path, key, probes, tombstones);
                }
                catch (FileNotFoundException fne) {
                    s3AFileStatus = null;
                }
                if (s3AFileStatus == null) {
                    LOG.warn("Failed to find file {}. Either it is not yet visible, or it has been deleted.", (Object)path);
                } else {
                    long s3ModTime = s3AFileStatus.getModificationTime();
                    if (s3ModTime > msModTime) {
                        LOG.debug("S3Guard metadata for {} is outdated; s3modtime={}; msModTime={} updating metastore", new Object[]{path, s3ModTime, msModTime});
                        return S3Guard.putAndReturn(this.metadataStore, s3AFileStatus, this.ttlTimeProvider);
                    }
                }
            }
            S3AFileStatus msStatus = pm.getFileStatus();
            if (needEmptyDirectoryFlag && msStatus.isDirectory()) {
                if (pm.isEmptyDirectory() != Tristate.UNKNOWN) {
                    return msStatus;
                }
                DirListingMetadata children = S3Guard.listChildrenWithTtl(this.metadataStore, path, this.ttlTimeProvider, allowAuthoritative);
                if (children != null) {
                    tombstones = children.listTombstones();
                }
            } else {
                return msStatus;
            }
            LOG.debug("MetadataStore doesn't know if dir is empty, using S3.");
            try {
                s3FileStatus = this.s3GetFileStatus(path, key, probes, tombstones);
            }
            catch (FileNotFoundException e) {
                return S3AFileStatus.fromFileStatus(msStatus, Tristate.TRUE, null, null);
            }
            return S3Guard.putAndReturn(this.metadataStore, s3FileStatus, this.ttlTimeProvider);
        }
        return S3Guard.putAndReturn(this.metadataStore, this.s3GetFileStatus(path, key, probes, tombstones), this.ttlTimeProvider);
    }

    @VisibleForTesting
    S3AFileStatus s3GetFileStatus(Path path, String key, Set<StatusProbeEnum> probes, @Nullable Set<Path> tombstones) throws IOException {
        if (!key.isEmpty()) {
            if (probes.contains((Object)StatusProbeEnum.Head) && !key.endsWith("/")) {
                try {
                    ObjectMetadata meta = this.getObjectMetadata(key);
                    LOG.debug("Found exact file: normal file {}", (Object)key);
                    return new S3AFileStatus(meta.getContentLength(), S3AUtils.dateToLong(meta.getLastModified()), path, this.getDefaultBlockSize(path), this.username, meta.getETag(), meta.getVersionId());
                }
                catch (AmazonServiceException e) {
                    if (e.getStatusCode() != 404 || ErrorTranslation.isUnknownBucket(e)) {
                        throw S3AUtils.translateException("getFileStatus", path, (AmazonClientException)((Object)e));
                    }
                }
                catch (AmazonClientException e) {
                    throw S3AUtils.translateException("getFileStatus", path, e);
                }
            }
            if (probes.contains((Object)StatusProbeEnum.DirMarker)) {
                String newKey = this.maybeAddTrailingSlash(key);
                try {
                    ObjectMetadata meta = this.getObjectMetadata(newKey);
                    if (S3AUtils.objectRepresentsDirectory(newKey, meta.getContentLength())) {
                        LOG.debug("Found file (with /): fake directory");
                        return new S3AFileStatus(Tristate.TRUE, path, this.username);
                    }
                    LOG.warn("Found file (with /): real file? should not happen: {}", (Object)key);
                    return new S3AFileStatus(meta.getContentLength(), S3AUtils.dateToLong(meta.getLastModified()), path, this.getDefaultBlockSize(path), this.username, meta.getETag(), meta.getVersionId());
                }
                catch (AmazonServiceException e) {
                    if (e.getStatusCode() != 404 || ErrorTranslation.isUnknownBucket(e)) {
                        throw S3AUtils.translateException("getFileStatus", newKey, (SdkBaseException)e);
                    }
                }
                catch (AmazonClientException e) {
                    throw S3AUtils.translateException("getFileStatus", newKey, (SdkBaseException)e);
                }
            }
        }
        if (probes.contains((Object)StatusProbeEnum.List)) {
            try {
                String dirKey = this.maybeAddTrailingSlash(key);
                S3ListRequest request = this.createListObjectsRequest(dirKey, "/", 1);
                S3ListResult objects = this.listObjects(request);
                List<String> prefixes = objects.getCommonPrefixes();
                List<S3ObjectSummary> summaries = objects.getObjectSummaries();
                if (!this.isEmptyOfKeys(prefixes, tombstones) || !this.isEmptyOfObjects(summaries, tombstones)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Found path as directory (with /): {}/{}", (Object)prefixes.size(), (Object)summaries.size());
                        for (S3ObjectSummary summary : summaries) {
                            LOG.debug("Summary: {} {}", (Object)summary.getKey(), (Object)summary.getSize());
                        }
                        for (String prefix : prefixes) {
                            LOG.debug("Prefix: {}", (Object)prefix);
                        }
                    }
                    return new S3AFileStatus(Tristate.FALSE, path, this.username);
                }
                if (key.isEmpty()) {
                    LOG.debug("Found root directory");
                    return new S3AFileStatus(Tristate.TRUE, path, this.username);
                }
            }
            catch (AmazonServiceException e) {
                if (e.getStatusCode() != 404 || ErrorTranslation.isUnknownBucket(e)) {
                    throw S3AUtils.translateException("getFileStatus", path, (AmazonClientException)((Object)e));
                }
            }
            catch (AmazonClientException e) {
                throw S3AUtils.translateException("getFileStatus", path, e);
            }
        }
        LOG.debug("Not Found: {}", (Object)path);
        throw new FileNotFoundException("No such file or directory: " + path);
    }

    private boolean isEmptyOfKeys(Collection<String> keys, Set<Path> tombstones) {
        if (tombstones == null) {
            return keys.isEmpty();
        }
        for (String key : keys) {
            Path qualified = this.keyToQualifiedPath(key);
            if (tombstones.contains(qualified)) continue;
            return false;
        }
        return true;
    }

    private boolean isEmptyOfObjects(Collection<S3ObjectSummary> summaries, Set<Path> tombstones) {
        if (tombstones == null) {
            return summaries.isEmpty();
        }
        ArrayList<String> stringCollection = new ArrayList<String>(summaries.size());
        for (S3ObjectSummary summary : summaries) {
            stringCollection.add(summary.getKey());
        }
        return this.isEmptyOfKeys(stringCollection, tombstones);
    }

    private boolean s3Exists(Path path, Set<StatusProbeEnum> probes) throws IOException {
        String key = this.pathToKey(path);
        try {
            this.s3GetFileStatus(path, key, probes, null);
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException {
        this.entryPoint(Statistic.INVOCATION_COPY_FROM_LOCAL_FILE);
        LOG.debug("Copying local file from {} to {}", (Object)src, (Object)dst);
        super.copyFromLocalFile(delSrc, overwrite, src, dst);
    }

    private void innerCopyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException, FileAlreadyExistsException, AmazonClientException {
        this.entryPoint(Statistic.INVOCATION_COPY_FROM_LOCAL_FILE);
        LOG.debug("Copying local file from {} to {}", (Object)src, (Object)dst);
        LocalFileSystem local = S3AFileSystem.getLocal((Configuration)this.getConf());
        File srcfile = local.pathToFile(src);
        if (!srcfile.exists()) {
            throw new FileNotFoundException("No file: " + src);
        }
        if (!srcfile.isFile()) {
            throw new FileNotFoundException("Not a file: " + src);
        }
        try {
            FileStatus status = this.getFileStatus(dst);
            if (!status.isFile()) {
                throw new FileAlreadyExistsException(dst + " exists and is not a file");
            }
            if (!overwrite) {
                throw new FileAlreadyExistsException(dst + " already exists");
            }
        }
        catch (FileNotFoundException status) {
            // empty catch block
        }
        String key = this.pathToKey(dst);
        ObjectMetadata om = this.newObjectMetadata(srcfile.length());
        Progressable progress = null;
        PutObjectRequest putObjectRequest = this.newPutObjectRequest(key, om, srcfile);
        this.invoker.retry("copyFromLocalFile(" + src + ")", dst.toString(), true, () -> this.executePut(putObjectRequest, progress));
        if (delSrc) {
            local.delete(src, false);
        }
    }

    UploadResult executePut(PutObjectRequest putObjectRequest, Progressable progress) throws InterruptedIOException, MetadataPersistenceException {
        String key = putObjectRequest.getKey();
        UploadInfo info = this.putObject(putObjectRequest);
        Upload upload = info.getUpload();
        ProgressableProgressListener listener = new ProgressableProgressListener(this, key, upload, progress);
        upload.addProgressListener((ProgressListener)listener);
        UploadResult result = this.waitForUploadCompletion(key, info);
        listener.uploadCompleted();
        this.finishedWrite(key, info.getLength(), result.getETag(), result.getVersionId(), null);
        return result;
    }

    UploadResult waitForUploadCompletion(String key, UploadInfo uploadInfo) throws InterruptedIOException {
        Upload upload = uploadInfo.getUpload();
        try {
            UploadResult result = upload.waitForUploadResult();
            this.incrementPutCompletedStatistics(true, uploadInfo.getLength());
            return result;
        }
        catch (InterruptedException e) {
            LOG.info("Interrupted: aborting upload");
            this.incrementPutCompletedStatistics(false, uploadInfo.getLength());
            upload.abort();
            throw (InterruptedIOException)new InterruptedIOException("Interrupted in PUT to " + this.keyToQualifiedPath(key)).initCause(e);
        }
    }

    public void close() throws IOException {
        if (this.closed.getAndSet(true)) {
            return;
        }
        this.isClosed = true;
        LOG.debug("Filesystem {} is closed", (Object)this.uri);
        try {
            super.close();
        }
        finally {
            this.stopAllServices();
        }
    }

    protected synchronized void stopAllServices() {
        if (this.transfers != null) {
            try {
                this.transfers.shutdownNow(true);
            }
            catch (RuntimeException e) {
                LOG.debug("When shutting down", (Throwable)e);
            }
            this.transfers = null;
        }
        HadoopExecutors.shutdown((ExecutorService)this.boundedThreadPool, (Logger)LOG, (long)30L, (TimeUnit)TimeUnit.SECONDS);
        this.boundedThreadPool = null;
        HadoopExecutors.shutdown((ExecutorService)this.unboundedThreadPool, (Logger)LOG, (long)30L, (TimeUnit)TimeUnit.SECONDS);
        this.unboundedThreadPool = null;
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.metadataStore, this.instrumentation, this.delegationTokens.orElse(null), this.signerManager});
        S3AUtils.closeAutocloseables(LOG, this.credentials);
        this.delegationTokens = Optional.empty();
        this.signerManager = null;
        this.credentials = null;
    }

    private void checkNotClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException(this.uri + ": " + "FileSystem is closed!");
        }
    }

    @VisibleForTesting
    public Optional<S3ADelegationTokens> getDelegationTokens() {
        return this.delegationTokens;
    }

    public String getCanonicalServiceName() {
        if (!this.delegationTokens.isPresent()) {
            return null;
        }
        S3ADelegationTokens dt = this.delegationTokens.get();
        return dt.getTokenIssuingPolicy() != S3ADelegationTokens.TokenIssuingPolicy.NoTokensAvailable ? dt.getCanonicalServiceName() : null;
    }

    public Token<AbstractS3ATokenIdentifier> getDelegationToken(String renewer) throws IOException {
        this.entryPoint(Statistic.INVOCATION_GET_DELEGATION_TOKEN);
        LOG.debug("Delegation token requested");
        if (this.delegationTokens.isPresent()) {
            return this.delegationTokens.get().getBoundOrNewDT(this.encryptionSecrets, renewer != null ? new Text(renewer) : new Text());
        }
        LOG.debug("Token support is not enabled");
        return null;
    }

    @Override
    public List<RoleModel.Statement> listAWSPolicyRules(Set<AWSPolicyProvider.AccessLevel> access) {
        if (access.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RoleModel.Statement> statements = new ArrayList<RoleModel.Statement>(RolePolicies.allowS3Operations(this.bucket, access.contains((Object)AWSPolicyProvider.AccessLevel.WRITE) || access.contains((Object)AWSPolicyProvider.AccessLevel.ADMIN)));
        statements.add(RolePolicies.STATEMENT_ALLOW_SSE_KMS_RW);
        if (this.metadataStore instanceof AWSPolicyProvider) {
            statements.addAll(((AWSPolicyProvider)((Object)this.metadataStore)).listAWSPolicyRules(access));
        }
        return statements;
    }

    private CopyResult copyFile(String srcKey, String dstKey, long size, S3ObjectAttributes srcAttributes, S3AReadOpContext readContext) throws IOException, InterruptedIOException {
        ObjectMetadata srcom;
        LOG.debug("copyFile {} -> {} ", (Object)srcKey, (Object)dstKey);
        ProgressListener progressListener = progressEvent -> {
            switch (progressEvent.getEventType()) {
                case TRANSFER_PART_COMPLETED_EVENT: {
                    this.incrementWriteOperations();
                    break;
                }
            }
        };
        ChangeTracker changeTracker = new ChangeTracker(this.keyToQualifiedPath(srcKey).toString(), this.changeDetectionPolicy, readContext.instrumentation.newInputStreamStatistics().getVersionMismatchCounter(), srcAttributes);
        String action = "copyFile(" + srcKey + ", " + dstKey + ")";
        Invoker readInvoker = readContext.getReadInvoker();
        try {
            srcom = Invoker.once(action, srcKey, () -> this.getObjectMetadata(srcKey, changeTracker, readInvoker, "copy"));
        }
        catch (FileNotFoundException e) {
            LOG.debug("getObjectMetadata({}) failed to find an expected file", (Object)srcKey, (Object)e);
            String message = this.hasMetadataStore() ? "File to rename not found on guarded S3 store after repeated attempts" : "File to rename not found on unguarded S3 store";
            throw new RemoteFileChangedException(this.keyToQualifiedPath(srcKey).toString(), action, message, e);
        }
        ObjectMetadata dstom = this.cloneObjectMetadata(srcom);
        this.setOptionalObjectMetadata(dstom);
        return readInvoker.retry(action, srcKey, true, () -> {
            CopyObjectRequest copyObjectRequest = new CopyObjectRequest(this.bucket, srcKey, this.bucket, dstKey);
            changeTracker.maybeApplyConstraint(copyObjectRequest);
            this.setOptionalCopyObjectRequestParameters(srcom, copyObjectRequest);
            copyObjectRequest.setCannedAccessControlList(this.cannedACL);
            copyObjectRequest.setNewObjectMetadata(dstom);
            Optional.ofNullable(srcom.getStorageClass()).ifPresent(arg_0 -> ((CopyObjectRequest)copyObjectRequest).setStorageClass(arg_0));
            Copy copy = this.transfers.copy(copyObjectRequest);
            copy.addProgressListener(progressListener);
            CopyOutcome copyOutcome = CopyOutcome.waitForCopy(copy);
            InterruptedException interruptedException = copyOutcome.getInterruptedException();
            if (interruptedException != null) {
                throw (IOException)new InterruptedIOException("Interrupted copying " + srcKey + " to " + dstKey + ", cancelling").initCause(interruptedException);
            }
            SdkBaseException awsException = copyOutcome.getAwsException();
            if (awsException != null) {
                changeTracker.processException(awsException, "copy");
                throw awsException;
            }
            CopyResult result = copyOutcome.getCopyResult();
            changeTracker.processResponse(result);
            this.incrementWriteOperations();
            this.instrumentation.filesCopied(1, size);
            return result;
        });
    }

    private void setOptionalCopyObjectRequestParameters(ObjectMetadata srcom, CopyObjectRequest copyObjectRequest) {
        String sourceKMSId = srcom.getSSEAwsKmsKeyId();
        if (StringUtils.isNotEmpty((CharSequence)sourceKMSId)) {
            LOG.debug("Propagating SSE-KMS settings from source {}", (Object)sourceKMSId);
            copyObjectRequest.setSSEAwsKeyManagementParams(new SSEAwsKeyManagementParams(sourceKMSId));
        }
        switch (this.getServerSideEncryptionAlgorithm()) {
            case SSE_C: {
                this.generateSSECustomerKey().ifPresent(customerKey -> {
                    copyObjectRequest.setSourceSSECustomerKey(customerKey);
                    copyObjectRequest.setDestinationSSECustomerKey(customerKey);
                });
                break;
            }
            case SSE_KMS: {
                this.generateSSEAwsKeyParams().ifPresent(arg_0 -> ((CopyObjectRequest)copyObjectRequest).setSSEAwsKeyManagementParams(arg_0));
                break;
            }
        }
    }

    protected void setOptionalMultipartUploadRequestParameters(InitiateMultipartUploadRequest request) {
        this.generateSSEAwsKeyParams().ifPresent(arg_0 -> ((InitiateMultipartUploadRequest)request).setSSEAwsKeyManagementParams(arg_0));
        this.generateSSECustomerKey().ifPresent(arg_0 -> ((InitiateMultipartUploadRequest)request).setSSECustomerKey(arg_0));
    }

    protected void setOptionalUploadPartRequestParameters(UploadPartRequest request) {
        this.generateSSECustomerKey().ifPresent(arg_0 -> ((UploadPartRequest)request).setSSECustomerKey(arg_0));
    }

    InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest request) throws IOException {
        LOG.debug("Initiate multipart upload to {}", (Object)request.getKey());
        this.incrementStatistic(Statistic.OBJECT_MULTIPART_UPLOAD_INITIATED);
        return this.getAmazonS3Client().initiateMultipartUpload(request);
    }

    private void setOptionalPutRequestParameters(PutObjectRequest request) {
        this.generateSSEAwsKeyParams().ifPresent(arg_0 -> ((PutObjectRequest)request).setSSEAwsKeyManagementParams(arg_0));
        this.generateSSECustomerKey().ifPresent(arg_0 -> ((PutObjectRequest)request).setSSECustomerKey(arg_0));
    }

    private void setOptionalObjectMetadata(ObjectMetadata metadata) {
        S3AEncryptionMethods algorithm = this.getServerSideEncryptionAlgorithm();
        if (S3AEncryptionMethods.SSE_S3.equals((Object)algorithm)) {
            metadata.setSSEAlgorithm(algorithm.getMethod());
        }
    }

    private Optional<SSEAwsKeyManagementParams> generateSSEAwsKeyParams() {
        return EncryptionSecretOperations.createSSEAwsKeyManagementParams(this.encryptionSecrets);
    }

    private Optional<SSECustomerKey> generateSSECustomerKey() {
        return EncryptionSecretOperations.createSSECustomerKey(this.encryptionSecrets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    void finishedWrite(String key, long length, String eTag, String versionId, @Nullable BulkOperationState operationState) throws MetadataPersistenceException {
        LOG.debug("Finished write to {}, len {}. etag {}, version {}", new Object[]{key, length, eTag, versionId});
        Path p = this.keyToQualifiedPath(key);
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0, (Object)"content length is negative");
        boolean isDir = S3AUtils.objectRepresentsDirectory(key, length);
        CompletableFuture<Object> deletion = CallableSupplier.submit(this.unboundedThreadPool, () -> {
            this.deleteUnnecessaryFakeDirectories(p.getParent());
            return null;
        });
        BulkOperationState stateToClose = null;
        try {
            if (this.hasMetadataStore()) {
                BulkOperationState activeState = operationState;
                if (activeState == null) {
                    activeState = stateToClose = S3Guard.initiateBulkWrite(this.metadataStore, isDir ? BulkOperationState.OperationType.Mkdir : BulkOperationState.OperationType.Put, this.keyToPath(key));
                }
                S3Guard.addAncestors(this.metadataStore, p, this.ttlTimeProvider, activeState);
                S3AFileStatus status = S3AUtils.createUploadFileStatus(p, isDir, length, this.getDefaultBlockSize(p), this.username, eTag, versionId);
                boolean authoritative = false;
                if (isDir) {
                    status.setIsEmptyDirectory(Tristate.TRUE);
                    authoritative = this.allowAuthoritative(p);
                }
                if (!authoritative) {
                    S3Guard.putAndReturn(this.metadataStore, status, this.ttlTimeProvider, activeState);
                } else {
                    S3Guard.putAuthDirectoryMarker(this.metadataStore, status, this.ttlTimeProvider, activeState);
                }
            }
            CallableSupplier.waitForCompletionIgnoringExceptions(deletion);
        }
        catch (IOException e) {
            try {
                if (this.failOnMetadataWriteError) {
                    throw new MetadataPersistenceException(p.toString(), e);
                }
                LOG.error("S3Guard: Error updating MetadataStore for write to {}", (Object)p, (Object)e);
                this.instrumentation.errorIgnored();
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{stateToClose});
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{stateToClose});
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{stateToClose});
    }

    private void deleteUnnecessaryFakeDirectories(Path path) {
        block4: {
            ArrayList<DeleteObjectsRequest.KeyVersion> keysToRemove = new ArrayList<DeleteObjectsRequest.KeyVersion>();
            while (!path.isRoot()) {
                String key = this.pathToKey(path);
                key = key.endsWith("/") ? key : key + "/";
                LOG.trace("To delete unnecessary fake directory {} for {}", (Object)key, (Object)path);
                keysToRemove.add(new DeleteObjectsRequest.KeyVersion(key));
                path = path.getParent();
            }
            try {
                this.removeKeys(keysToRemove, true, null);
            }
            catch (AmazonClientException | IOException e) {
                this.instrumentation.errorIgnored();
                if (!LOG.isDebugEnabled()) break block4;
                StringBuilder sb = new StringBuilder();
                for (DeleteObjectsRequest.KeyVersion kv : keysToRemove) {
                    sb.append(kv.getKey()).append(",");
                }
                LOG.debug("While deleting keys {} ", (Object)sb.toString(), (Object)e);
            }
        }
    }

    private void createFakeDirectory(String objectName) throws IOException {
        if (!objectName.endsWith("/")) {
            this.createEmptyObject(objectName + "/");
        } else {
            this.createEmptyObject(objectName);
        }
    }

    private void createEmptyObject(String objectName) throws IOException {
        InputStream im = new InputStream(){

            @Override
            public int read() throws IOException {
                return -1;
            }
        };
        PutObjectRequest putObjectRequest = this.newPutObjectRequest(objectName, this.newObjectMetadata(0L), im);
        this.invoker.retry("PUT 0-byte object ", objectName, true, () -> this.putObjectDirect(putObjectRequest));
        this.incrementPutProgressStatistics(objectName, 0L);
        this.instrumentation.directoryCreated();
    }

    private ObjectMetadata cloneObjectMetadata(ObjectMetadata source) {
        ObjectMetadata ret = this.newObjectMetadata(source.getContentLength());
        if (source.getCacheControl() != null) {
            ret.setCacheControl(source.getCacheControl());
        }
        if (source.getContentDisposition() != null) {
            ret.setContentDisposition(source.getContentDisposition());
        }
        if (source.getContentEncoding() != null) {
            ret.setContentEncoding(source.getContentEncoding());
        }
        if (source.getContentMD5() != null) {
            ret.setContentMD5(source.getContentMD5());
        }
        if (source.getContentType() != null) {
            ret.setContentType(source.getContentType());
        }
        if (source.getExpirationTime() != null) {
            ret.setExpirationTime(source.getExpirationTime());
        }
        if (source.getExpirationTimeRuleId() != null) {
            ret.setExpirationTimeRuleId(source.getExpirationTimeRuleId());
        }
        if (source.getHttpExpiresDate() != null) {
            ret.setHttpExpiresDate(source.getHttpExpiresDate());
        }
        if (source.getLastModified() != null) {
            ret.setLastModified(source.getLastModified());
        }
        if (source.getOngoingRestore() != null) {
            ret.setOngoingRestore(source.getOngoingRestore().booleanValue());
        }
        if (source.getRestoreExpirationTime() != null) {
            ret.setRestoreExpirationTime(source.getRestoreExpirationTime());
        }
        if (source.getSSEAlgorithm() != null) {
            ret.setSSEAlgorithm(source.getSSEAlgorithm());
        }
        if (source.getSSECustomerAlgorithm() != null) {
            ret.setSSECustomerAlgorithm(source.getSSECustomerAlgorithm());
        }
        if (source.getSSECustomerKeyMd5() != null) {
            ret.setSSECustomerKeyMd5(source.getSSECustomerKeyMd5());
        }
        for (Map.Entry e : source.getUserMetadata().entrySet()) {
            ret.addUserMetadata((String)e.getKey(), (String)e.getValue());
        }
        return ret;
    }

    @Deprecated
    public long getDefaultBlockSize() {
        return this.getConf().getLongBytes("fs.s3a.block.size", 0x2000000L);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("S3AFileSystem{");
        sb.append("uri=").append(this.uri);
        sb.append(", workingDir=").append(this.workingDir);
        sb.append(", inputPolicy=").append((Object)this.inputPolicy);
        sb.append(", partSize=").append(this.partSize);
        sb.append(", enableMultiObjectsDelete=").append(this.enableMultiObjectsDelete);
        sb.append(", maxKeys=").append(this.maxKeys);
        if (this.cannedACL != null) {
            sb.append(", cannedACL=").append(this.cannedACL.toString());
        }
        sb.append(", readAhead=").append(this.readAhead);
        if (this.getConf() != null) {
            sb.append(", blockSize=").append(this.getDefaultBlockSize());
        }
        sb.append(", multiPartThreshold=").append(this.multiPartThreshold);
        if (this.getServerSideEncryptionAlgorithm() != null) {
            sb.append(", serverSideEncryptionAlgorithm='").append((Object)this.getServerSideEncryptionAlgorithm()).append('\'');
        }
        if (this.blockFactory != null) {
            sb.append(", blockFactory=").append(this.blockFactory);
        }
        sb.append(", metastore=").append(this.metadataStore);
        sb.append(", authoritativeStore=").append(this.allowAuthoritativeMetadataStore);
        sb.append(", authoritativePath=").append(this.allowAuthoritativePaths);
        sb.append(", useListV1=").append(this.useListV1);
        if (this.committerIntegration != null) {
            sb.append(", magicCommitter=").append(this.isMagicCommitEnabled());
        }
        sb.append(", boundedExecutor=").append(this.boundedThreadPool);
        sb.append(", unboundedExecutor=").append(this.unboundedThreadPool);
        sb.append(", credentials=").append(this.credentials);
        sb.append(", delegation tokens=").append(this.delegationTokens.map(Objects::toString).orElse("disabled"));
        sb.append(", statistics {").append(this.statistics).append("}");
        if (this.instrumentation != null) {
            sb.append(", metrics {").append(this.instrumentation.dump("{", "=", "} ", true)).append("}");
        }
        sb.append('}');
        return sb.toString();
    }

    public long getPartitionSize() {
        return this.partSize;
    }

    public long getMultiPartThreshold() {
        return this.multiPartThreshold;
    }

    int getMaxKeys() {
        return this.maxKeys;
    }

    public boolean isMagicCommitEnabled() {
        return this.committerIntegration.isMagicCommitEnabled();
    }

    public boolean isMagicCommitPath(Path path) {
        return this.committerIntegration.isMagicCommitPath(path);
    }

    public FileStatus[] globStatus(Path pathPattern) throws IOException {
        return this.globStatus(pathPattern, S3AUtils.ACCEPT_ALL);
    }

    public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
        this.entryPoint(Statistic.INVOCATION_GLOB_STATUS);
        return Globber.createGlobber((FileSystem)this).withPathPattern(pathPattern).withPathFiltern(filter).withResolveSymlinks(true).build().glob();
    }

    public boolean exists(Path f) throws IOException {
        this.entryPoint(Statistic.INVOCATION_EXISTS);
        return super.exists(f);
    }

    public boolean isDirectory(Path f) throws IOException {
        this.entryPoint(Statistic.INVOCATION_IS_DIRECTORY);
        return super.isDirectory(f);
    }

    public boolean isFile(Path f) throws IOException {
        this.entryPoint(Statistic.INVOCATION_IS_FILE);
        return super.isFile(f);
    }

    public EtagChecksum getFileChecksum(Path f, long length) throws IOException {
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0);
        this.entryPoint(Statistic.INVOCATION_GET_FILE_CHECKSUM);
        if (this.getConf().getBoolean("fs.s3a.etag.checksum.enabled", false)) {
            Path path = this.qualify(f);
            LOG.debug("getFileChecksum({})", (Object)path);
            ObjectMetadata headers = this.getObjectMetadata(path);
            String eTag = headers.getETag();
            return eTag != null ? new EtagChecksum(eTag) : null;
        }
        return null;
    }

    public RemoteIterator<LocatedFileStatus> listFiles(Path f, boolean recursive) throws FileNotFoundException, IOException {
        return S3AFileSystem.toLocatedFileStatusIterator(this.innerListFiles(f, recursive, new Listing.AcceptFilesOnly(this.qualify(f)), null, true, false));
    }

    private static RemoteIterator<LocatedFileStatus> toLocatedFileStatusIterator(final RemoteIterator<? extends LocatedFileStatus> iterator) {
        return new RemoteIterator<LocatedFileStatus>(){

            public boolean hasNext() throws IOException {
                return iterator.hasNext();
            }

            public LocatedFileStatus next() throws IOException {
                return (LocatedFileStatus)iterator.next();
            }
        };
    }

    public RemoteIterator<S3ALocatedFileStatus> listFilesAndEmptyDirectories(Path f, boolean recursive) throws IOException {
        return this.innerListFiles(f, recursive, Listing.ACCEPT_ALL_BUT_S3N, null, true, false);
    }

    public RemoteIterator<S3ALocatedFileStatus> listFilesAndEmptyDirectoriesForceNonAuth(Path f, boolean recursive) throws IOException {
        return this.innerListFiles(f, recursive, Listing.ACCEPT_ALL_BUT_S3N, null, true, true);
    }

    private RemoteIterator<S3ALocatedFileStatus> innerListFiles(Path f, boolean recursive, Listing.FileStatusAcceptor acceptor, S3AFileStatus status, boolean collectTombstones, boolean forceNonAuthoritativeMS) throws IOException {
        this.entryPoint(Statistic.INVOCATION_LIST_FILES);
        Path path = this.qualify(f);
        LOG.debug("listFiles({}, {})", (Object)path, (Object)recursive);
        try {
            Object cachedFilesIterator;
            Set<Path> tombstones;
            S3AFileStatus fileStatus;
            S3AFileStatus s3AFileStatus = fileStatus = status != null ? status : (S3AFileStatus)this.getFileStatus(path);
            if (fileStatus.isFile()) {
                LOG.debug("Path is a file");
                return new Listing.SingleStatusRemoteIterator(this.toLocatedFileStatus(fileStatus));
            }
            String key = this.maybeAddTrailingSlash(this.pathToKey(path));
            String delimiter = recursive ? null : "/";
            LOG.debug("Requesting all entries under {} with delimiter '{}'", (Object)key, (Object)delimiter);
            boolean allowAuthoritative = this.allowAuthoritative(f);
            if (recursive) {
                PathMetadata pm = this.metadataStore.get(path, true);
                MetadataStoreListFilesIterator metadataStoreListFilesIterator = new MetadataStoreListFilesIterator(this.metadataStore, pm, allowAuthoritative);
                tombstones = metadataStoreListFilesIterator.listTombstones();
                if (!forceNonAuthoritativeMS && allowAuthoritative && metadataStoreListFilesIterator.isRecursivelyAuthoritative()) {
                    S3AFileStatus[] statuses = S3Guard.iteratorToStatuses(metadataStoreListFilesIterator, tombstones);
                    Listing.ProvidedFileStatusIterator cachedFilesIterator2 = this.listing.createProvidedFileStatusIterator(statuses, S3AUtils.ACCEPT_ALL, acceptor);
                    return this.listing.createLocatedFileStatusIterator(cachedFilesIterator2);
                }
                cachedFilesIterator = metadataStoreListFilesIterator;
            } else {
                DirListingMetadata meta = S3Guard.listChildrenWithTtl(this.metadataStore, path, this.ttlTimeProvider, allowAuthoritative);
                tombstones = meta != null ? meta.listTombstones() : null;
                cachedFilesIterator = this.listing.createProvidedFileStatusIterator(S3Guard.dirMetaToStatuses(meta), S3AUtils.ACCEPT_ALL, acceptor);
                if (allowAuthoritative && meta != null && meta.isAuthoritative()) {
                    return this.listing.createLocatedFileStatusIterator((RemoteIterator<S3AFileStatus>)cachedFilesIterator);
                }
            }
            return this.listing.createTombstoneReconcilingIterator(this.listing.createLocatedFileStatusIterator(this.listing.createFileStatusListingIterator(path, this.createListObjectsRequest(key, delimiter), S3AUtils.ACCEPT_ALL, acceptor, (RemoteIterator<S3AFileStatus>)cachedFilesIterator)), collectTombstones ? tombstones : null);
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("listFiles", path, e);
        }
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws FileNotFoundException, IOException {
        return this.listLocatedStatus(f, S3AUtils.ACCEPT_ALL);
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f, PathFilter filter) throws FileNotFoundException, IOException {
        this.entryPoint(Statistic.INVOCATION_LIST_LOCATED_STATUS);
        Path path = this.qualify(f);
        LOG.debug("listLocatedStatus({}, {}", (Object)path, (Object)filter);
        RemoteIterator iterator = Invoker.once("listLocatedStatus", path.toString(), () -> {
            S3AFileStatus fileStatus;
            RemoteIterator<S3ALocatedFileStatus> locatedFileStatusIteratorForDir = this.getLocatedFileStatusIteratorForDir(path, filter);
            if (!locatedFileStatusIteratorForDir.hasNext() && (fileStatus = (S3AFileStatus)this.getFileStatus(path)).isFile()) {
                LOG.debug("Path is a file");
                return new Listing.SingleStatusRemoteIterator(filter.accept(path) ? this.toLocatedFileStatus(fileStatus) : null);
            }
            return locatedFileStatusIteratorForDir;
        });
        return S3AFileSystem.toLocatedFileStatusIterator((RemoteIterator<? extends LocatedFileStatus>)iterator);
    }

    private RemoteIterator<S3ALocatedFileStatus> getLocatedFileStatusIteratorForDir(Path dir, PathFilter filter) throws IOException {
        String key = this.maybeAddTrailingSlash(this.pathToKey(dir));
        Listing.AcceptAllButSelfAndS3nDirs acceptor = new Listing.AcceptAllButSelfAndS3nDirs(dir);
        boolean allowAuthoritative = this.allowAuthoritative(dir);
        DirListingMetadata meta = S3Guard.listChildrenWithTtl(this.metadataStore, dir, this.ttlTimeProvider, allowAuthoritative);
        Set<Path> tombstones = meta != null ? meta.listTombstones() : null;
        Listing.ProvidedFileStatusIterator cachedFileStatusIterator = this.listing.createProvidedFileStatusIterator(S3Guard.dirMetaToStatuses(meta), filter, acceptor);
        return allowAuthoritative && meta != null && meta.isAuthoritative() ? this.listing.createLocatedFileStatusIterator(cachedFileStatusIterator) : this.listing.createTombstoneReconcilingIterator(this.listing.createLocatedFileStatusIterator(this.listing.createFileStatusListingIterator(dir, this.createListObjectsRequest(key, "/"), filter, acceptor, cachedFileStatusIterator)), tombstones);
    }

    S3ALocatedFileStatus toLocatedFileStatus(S3AFileStatus status) throws IOException {
        return new S3ALocatedFileStatus(status, status.isFile() ? this.getFileBlockLocations(status, 0L, status.getLen()) : null);
    }

    public MultipartUtils.UploadIterator listUploads(@Nullable String prefix) throws IOException {
        return MultipartUtils.listMultipartUploads(this.s3, this.invoker, this.bucket, this.maxKeys, prefix);
    }

    @InterfaceAudience.Private
    public List<MultipartUpload> listMultipartUploads(String prefix) throws IOException {
        ListMultipartUploadsRequest request = new ListMultipartUploadsRequest(this.bucket);
        if (!prefix.isEmpty()) {
            if (!prefix.endsWith("/")) {
                prefix = prefix + "/";
            }
            request.setPrefix(prefix);
        }
        return this.invoker.retry("listMultipartUploads", prefix, true, () -> this.s3.listMultipartUploads(request).getMultipartUploads());
    }

    void abortMultipartUpload(String destKey, String uploadId) {
        LOG.debug("Aborting multipart upload {} to {}", (Object)uploadId, (Object)destKey);
        this.getAmazonS3Client().abortMultipartUpload(new AbortMultipartUploadRequest(this.getBucket(), destKey, uploadId));
    }

    void abortMultipartUpload(MultipartUpload upload) {
        String destKey = upload.getKey();
        String uploadId = upload.getUploadId();
        if (LOG.isInfoEnabled()) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            LOG.debug("Aborting multipart upload {} to {} initiated by {} on {}", new Object[]{uploadId, destKey, upload.getInitiator(), df.format(upload.getInitiated())});
        }
        this.getAmazonS3Client().abortMultipartUpload(new AbortMultipartUploadRequest(this.getBucket(), destKey, uploadId));
    }

    public S3AInstrumentation.CommitterStatistics newCommitterStatistics() {
        return this.instrumentation.newCommitterStatistics();
    }

    public boolean hasPathCapability(Path path, String capability) throws IOException {
        Path p = this.makeQualified(path);
        switch (PathCapabilitiesSupport.validatePathCapabilityArgs((Path)p, (String)capability)) {
            case "fs.s3a.capability.magic.committer": 
            case "s3a:magic.committer": {
                return this.isMagicCommitEnabled();
            }
            case "fs.s3a.capability.select.sql": {
                return this.selectBinding.isEnabled();
            }
            case "fs.capability.paths.checksums": {
                return this.getConf().getBoolean("fs.s3a.etag.checksum.enabled", false);
            }
        }
        return super.hasPathCapability(p, capability);
    }

    @Deprecated
    public boolean hasCapability(String capability) {
        try {
            return this.hasPathCapability(this.workingDir, capability);
        }
        catch (IOException ex) {
            LOG.debug("Ignoring exception on hasCapability({}})", (Object)capability, (Object)ex);
            return false;
        }
    }

    public AWSCredentialProviderList shareCredentials(String purpose) {
        LOG.debug("Sharing credentials for: {}", (Object)purpose);
        return this.credentials.share();
    }

    @VisibleForTesting
    public ITtlTimeProvider getTtlTimeProvider() {
        return this.ttlTimeProvider;
    }

    @VisibleForTesting
    protected void setTtlTimeProvider(ITtlTimeProvider ttlTimeProvider) {
        this.ttlTimeProvider = ttlTimeProvider;
        this.metadataStore.setTtlTimeProvider(ttlTimeProvider);
    }

    private FSDataInputStream select(Path source, String expression, Configuration options, Optional<S3AFileStatus> providedStatus) throws IOException {
        this.entryPoint(Statistic.OBJECT_SELECT_REQUESTS);
        this.requireSelectSupport(source);
        Path path = this.makeQualified(source);
        S3AFileStatus fileStatus = this.extractOrFetchSimpleFileStatus(path, providedStatus);
        long ra = options.getLong("fs.s3a.readahead.range", this.readAhead);
        S3ObjectAttributes objectAttributes = this.createObjectAttributes(fileStatus);
        S3AReadOpContext readContext = this.createReadContext(fileStatus, this.inputPolicy, this.changeDetectionPolicy, ra);
        if (this.changeDetectionPolicy.getSource() != ChangeDetectionPolicy.Source.None && fileStatus.getETag() != null) {
            ChangeTracker changeTracker = new ChangeTracker(this.uri.toString(), this.changeDetectionPolicy, readContext.instrumentation.newInputStreamStatistics().getVersionMismatchCounter(), objectAttributes);
            Invoker readInvoker = readContext.getReadInvoker();
            this.getObjectMetadata(path, changeTracker, readInvoker, "select");
        }
        return this.selectBinding.select(readContext, expression, options, this.generateSSECustomerKey(), objectAttributes);
    }

    private void requireSelectSupport(Path source) throws UnsupportedOperationException {
        if (!this.selectBinding.isEnabled()) {
            throw new UnsupportedOperationException("S3 Select is not supported");
        }
    }

    private S3AFileStatus extractOrFetchSimpleFileStatus(Path path, Optional<S3AFileStatus> optStatus) throws IOException {
        S3AFileStatus fileStatus = optStatus.isPresent() ? optStatus.get() : this.innerGetFileStatus(path, false, StatusProbeEnum.HEAD_ONLY);
        if (fileStatus.isDirectory()) {
            throw new FileNotFoundException(path.toString() + " is a directory");
        }
        return fileStatus;
    }

    public CompletableFuture<FSDataInputStream> openFileWithOptions(Path rawPath, OpenFileParameters parameters) throws IOException {
        S3AFileStatus fileStatus;
        boolean isSelect;
        Path path = this.qualify(rawPath);
        Configuration options = parameters.getOptions();
        Set mandatoryKeys = parameters.getMandatoryKeys();
        String sql = options.get("fs.s3a.select.sql", null);
        boolean bl = isSelect = sql != null;
        if (isSelect) {
            AbstractFSBuilderImpl.rejectUnknownMandatoryKeys((Set)mandatoryKeys, InternalSelectConstants.SELECT_OPTIONS, (String)("for " + path + " in S3 Select operation"));
        } else {
            AbstractFSBuilderImpl.rejectUnknownMandatoryKeys((Set)mandatoryKeys, InternalConstants.STANDARD_OPENFILE_KEYS, (String)("for " + path + " in non-select file I/O"));
        }
        FileStatus providedStatus = parameters.getStatus();
        if (providedStatus != null) {
            Preconditions.checkArgument((boolean)path.equals((Object)providedStatus.getPath()), (String)"FileStatus parameter is not for the path %s: %s", (Object)path, (Object)providedStatus);
            if (providedStatus instanceof S3AFileStatus) {
                LOG.debug("File was opened with a supplied S3AFileStatus; skipping getFileStatus call in open() operation: {}", (Object)providedStatus);
                fileStatus = (S3AFileStatus)providedStatus;
            } else if (providedStatus instanceof S3ALocatedFileStatus) {
                LOG.debug("File was opened with a supplied S3ALocatedFileStatus; skipping getFileStatus call in open() operation: {}", (Object)providedStatus);
                fileStatus = ((S3ALocatedFileStatus)providedStatus).toS3AFileStatus();
            } else {
                LOG.debug("Ignoring file status {}", (Object)providedStatus);
                fileStatus = null;
            }
        } else {
            fileStatus = null;
        }
        Optional<Object> ost = Optional.ofNullable(fileStatus);
        CompletableFuture<FSDataInputStream> result = new CompletableFuture<FSDataInputStream>();
        if (!isSelect) {
            this.unboundedThreadPool.submit(() -> LambdaUtils.eval((CompletableFuture)result, () -> this.open(path, Optional.of(options), ost)));
        } else {
            this.requireSelectSupport(path);
            this.unboundedThreadPool.submit(() -> LambdaUtils.eval((CompletableFuture)result, () -> this.select(path, sql, options, ost)));
        }
        return result;
    }

    @InterfaceAudience.Private
    public StoreContext createStoreContext() {
        return new StoreContext(this.getUri(), this.getBucket(), this.getConf(), this.getUsername(), this.owner, this.boundedThreadPool, this.executorCapacity, this.invoker, this.getInstrumentation(), this.getStorageStatistics(), this.getInputPolicy(), this.changeDetectionPolicy, this.enableMultiObjectsDelete, this.metadataStore, this.useListV1, new ContextAccessorsImpl(), this.getTtlTimeProvider());
    }

    static {
        S3AFileSystem.addDeprecatedKeys();
    }

    private class ContextAccessorsImpl
    implements ContextAccessors {
        private ContextAccessorsImpl() {
        }

        @Override
        public Path keyToPath(String key) {
            return S3AFileSystem.this.keyToQualifiedPath(key);
        }

        @Override
        public String pathToKey(Path path) {
            return S3AFileSystem.this.pathToKey(path);
        }

        @Override
        public File createTempFile(String prefix, long size) throws IOException {
            return S3AFileSystem.this.createTmpFileForWrite(prefix, size, S3AFileSystem.this.getConf());
        }

        @Override
        public String getBucketLocation() throws IOException {
            return S3AFileSystem.this.getBucketLocation();
        }
    }

    private class OperationCallbacksImpl
    implements OperationCallbacks {
        private OperationCallbacksImpl() {
        }

        @Override
        public S3ObjectAttributes createObjectAttributes(Path path, String eTag, String versionId, long len) {
            return S3AFileSystem.this.createObjectAttributes(path, eTag, versionId, len);
        }

        @Override
        public S3ObjectAttributes createObjectAttributes(S3AFileStatus fileStatus) {
            return S3AFileSystem.this.createObjectAttributes(fileStatus);
        }

        @Override
        public S3AReadOpContext createReadContext(FileStatus fileStatus) {
            return S3AFileSystem.this.createReadContext(fileStatus, S3AFileSystem.this.inputPolicy, S3AFileSystem.this.changeDetectionPolicy, S3AFileSystem.this.readAhead);
        }

        @Override
        public void deleteObjectAtPath(Path path, String key, boolean isFile, BulkOperationState operationState) throws IOException {
            Invoker.once("delete", key, () -> S3AFileSystem.this.deleteObjectAtPath(path, key, isFile, operationState));
        }

        @Override
        public RemoteIterator<S3ALocatedFileStatus> listFilesAndEmptyDirectories(Path path, S3AFileStatus status, boolean collectTombstones, boolean includeSelf) throws IOException {
            return S3AFileSystem.this.innerListFiles(path, true, includeSelf ? Listing.ACCEPT_ALL_BUT_S3N : new Listing.AcceptAllButSelfAndS3nDirs(path), status, collectTombstones, true);
        }

        @Override
        public CopyResult copyFile(String srcKey, String destKey, S3ObjectAttributes srcAttributes, S3AReadOpContext readContext) throws IOException {
            return S3AFileSystem.this.copyFile(srcKey, destKey, srcAttributes.getLen(), srcAttributes, readContext);
        }

        @Override
        public DeleteObjectsResult removeKeys(List<DeleteObjectsRequest.KeyVersion> keysToDelete, boolean deleteFakeDir, List<Path> undeletedObjectsOnFailure, BulkOperationState operationState, boolean quiet) throws MultiObjectDeleteException, AmazonClientException, IOException {
            return S3AFileSystem.this.removeKeys(keysToDelete, deleteFakeDir, undeletedObjectsOnFailure, operationState, quiet);
        }

        @Override
        public void finishRename(Path sourceRenamed, Path destCreated) throws IOException {
            Path destParent = destCreated.getParent();
            if (!sourceRenamed.getParent().equals((Object)destParent)) {
                LOG.debug("source & dest parents are different; fix up dir markers");
                S3AFileSystem.this.deleteUnnecessaryFakeDirectories(destParent);
                S3AFileSystem.this.maybeCreateFakeParentDirectory(sourceRenamed);
            }
        }

        @Override
        public boolean allowAuthoritative(Path p) {
            return S3AFileSystem.this.allowAuthoritative(p);
        }

        @Override
        public RemoteIterator<S3AFileStatus> listObjects(Path path, String key) throws IOException {
            return Invoker.once("listObjects", key, () -> S3AFileSystem.this.listing.createFileStatusListingIterator(path, S3AFileSystem.this.createListObjectsRequest(key, null), S3AUtils.ACCEPT_ALL, Listing.ACCEPT_ALL_BUT_S3N, null));
        }
    }

    private class DelegationOperationsImpl
    implements DelegationOperations {
        private DelegationOperationsImpl() {
        }

        @Override
        public List<RoleModel.Statement> listAWSPolicyRules(Set<AWSPolicyProvider.AccessLevel> access) {
            return S3AFileSystem.this.listAWSPolicyRules(access);
        }
    }
}

