/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.commit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Tasks {
    private static final Logger LOG = LoggerFactory.getLogger(Tasks.class);

    private Tasks() {
    }

    private static void waitFor(Collection<Future<?>> futures) {
        int size = futures.size();
        LOG.debug("Waiting for {} tasks to complete", (Object)size);
        int oldNumFinished = 0;
        while (true) {
            int numFinished;
            if (oldNumFinished != (numFinished = (int)futures.stream().filter(Future::isDone).count())) {
                LOG.debug("Finished count -> {}/{}", (Object)numFinished, (Object)size);
                oldNumFinished = numFinished;
            }
            if (numFinished == size) break;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                futures.forEach(future -> future.cancel(true));
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    public static <I> Builder<I> foreach(Iterable<I> items) {
        return new Builder<I>(items);
    }

    public static <I> Builder<I> foreach(I[] items) {
        return new Builder<I>(Arrays.asList(items));
    }

    private static <E extends Exception> void throwOne(Collection<Exception> exceptions) throws E {
        Iterator<Exception> iter = exceptions.iterator();
        Exception e = iter.next();
        Class<?> exceptionClass = e.getClass();
        while (iter.hasNext()) {
            Exception other = iter.next();
            if (exceptionClass.isInstance(other)) continue;
            e.addSuppressed(other);
        }
        Tasks.castAndThrow(e);
    }

    private static <E extends Exception> void castAndThrow(Exception e) throws E {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw e;
    }

    public static interface Submitter {
        public Future<?> submit(Runnable var1);
    }

    public static class Builder<I> {
        private final Iterable<I> items;
        private Submitter service = null;
        private FailureTask<I, ?> onFailure = null;
        private boolean stopOnFailure = false;
        private boolean suppressExceptions = false;
        private Task<I, ?> revertTask = null;
        private boolean stopRevertsOnFailure = false;
        private Task<I, ?> abortTask = null;
        private boolean stopAbortsOnFailure = false;

        Builder(Iterable<I> items) {
            this.items = items;
        }

        public Builder<I> executeWith(Submitter submitter) {
            this.service = submitter;
            return this;
        }

        public Builder<I> onFailure(FailureTask<I, ?> task) {
            this.onFailure = task;
            return this;
        }

        public Builder<I> stopOnFailure() {
            this.stopOnFailure = true;
            return this;
        }

        public Builder<I> suppressExceptions() {
            return this.suppressExceptions(true);
        }

        public Builder<I> suppressExceptions(boolean suppress) {
            this.suppressExceptions = suppress;
            return this;
        }

        public Builder<I> revertWith(Task<I, ?> task) {
            this.revertTask = task;
            return this;
        }

        public Builder<I> stopRevertsOnFailure() {
            this.stopRevertsOnFailure = true;
            return this;
        }

        public Builder<I> abortWith(Task<I, ?> task) {
            this.abortTask = task;
            return this;
        }

        public Builder<I> stopAbortsOnFailure() {
            this.stopAbortsOnFailure = true;
            return this;
        }

        public <E extends Exception> boolean run(Task<I, E> task) throws E {
            if (this.service != null) {
                return this.runParallel(task);
            }
            return this.runSingleThreaded(task);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private <E extends Exception> boolean runSingleThreaded(Task<I, E> task) throws E {
            boolean threw;
            ArrayList<Exception> exceptions;
            block24: {
                Iterator<I> iterator;
                block25: {
                    Iterator e2;
                    boolean failed;
                    ArrayList<I> succeeded = new ArrayList<I>();
                    exceptions = new ArrayList<Exception>();
                    iterator = this.items.iterator();
                    threw = true;
                    try {
                        while (iterator.hasNext()) {
                            I item = iterator.next();
                            try {
                                task.run(item);
                                succeeded.add(item);
                            }
                            catch (Exception e2) {
                                exceptions.add(e2);
                                if (this.onFailure != null) {
                                    try {
                                        this.onFailure.run(item, e2);
                                    }
                                    catch (Exception failException) {
                                        LOG.error("Failed to clean up on failure", (Throwable)e2);
                                    }
                                }
                                if (!this.stopOnFailure) continue;
                            }
                        }
                        if (!(threw = false) && exceptions.isEmpty()) break block24;
                        if (this.revertTask == null) break block25;
                        failed = false;
                        e2 = succeeded.iterator();
                    }
                    catch (Throwable throwable) {
                        boolean failed2;
                        if (!threw) {
                            if (exceptions.isEmpty()) throw throwable;
                        }
                        if (this.revertTask != null) {
                            failed2 = false;
                            for (Object item : succeeded) {
                                try {
                                    this.revertTask.run(item);
                                }
                                catch (Exception e3) {
                                    LOG.error("Failed to revert task", (Throwable)e3);
                                    failed2 = true;
                                }
                                if (!this.stopRevertsOnFailure || !failed2) continue;
                            }
                        }
                        if (this.abortTask == null) throw throwable;
                        failed2 = false;
                        do {
                            if (!iterator.hasNext()) throw throwable;
                            try {
                                this.abortTask.run(iterator.next());
                            }
                            catch (Exception e4) {
                                failed2 = true;
                                LOG.error("Failed to abort task", (Throwable)e4);
                            }
                        } while (!this.stopAbortsOnFailure || !failed2);
                        throw throwable;
                    }
                    while (e2.hasNext()) {
                        Object item = e2.next();
                        try {
                            this.revertTask.run(item);
                        }
                        catch (Exception e5) {
                            LOG.error("Failed to revert task", (Throwable)e5);
                            failed = true;
                        }
                        if (!this.stopRevertsOnFailure || !failed) continue;
                    }
                }
                if (this.abortTask != null) {
                    boolean failed = false;
                    while (iterator.hasNext()) {
                        try {
                            this.abortTask.run(iterator.next());
                        }
                        catch (Exception e) {
                            failed = true;
                            LOG.error("Failed to abort task", (Throwable)e);
                        }
                        if (!this.stopAbortsOnFailure || !failed) continue;
                    }
                }
            }
            if (!this.suppressExceptions && !exceptions.isEmpty()) {
                Tasks.throwOne(exceptions);
            }
            if (threw) return false;
            if (!exceptions.isEmpty()) return false;
            return true;
        }

        private <E extends Exception> boolean runParallel(final Task<I, E> task) throws E {
            final ConcurrentLinkedQueue succeeded = new ConcurrentLinkedQueue();
            final ConcurrentLinkedQueue exceptions = new ConcurrentLinkedQueue();
            final AtomicBoolean taskFailed = new AtomicBoolean(false);
            final AtomicBoolean abortFailed = new AtomicBoolean(false);
            AtomicBoolean revertFailed = new AtomicBoolean(false);
            ArrayList futures = new ArrayList();
            for (final I item : this.items) {
                futures.add(this.service.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void run() {
                        if (!stopOnFailure || !taskFailed.get()) {
                            boolean threw = true;
                            try {
                                LOG.debug("Executing task");
                                task.run(item);
                                succeeded.add(item);
                                LOG.debug("Task succeeded");
                                threw = false;
                                return;
                            }
                            catch (Exception e) {
                                taskFailed.set(true);
                                exceptions.add(e);
                                LOG.info("Task failed", (Throwable)e);
                                if (onFailure == null) return;
                                try {
                                    onFailure.run(item, e);
                                    return;
                                }
                                catch (Exception failException) {
                                    LOG.error("Failed to clean up on failure", (Throwable)e);
                                }
                                return;
                            }
                            finally {
                                if (threw) {
                                    taskFailed.set(true);
                                }
                            }
                        }
                        if (abortTask == null) return;
                        if (stopAbortsOnFailure && abortFailed.get()) {
                            return;
                        }
                        boolean failed = true;
                        try {
                            LOG.info("Aborting task");
                            abortTask.run(item);
                            failed = false;
                            return;
                        }
                        catch (Exception e) {
                            LOG.error("Failed to abort task", (Throwable)e);
                            return;
                        }
                        finally {
                            if (failed) {
                                abortFailed.set(true);
                            }
                        }
                    }
                }));
            }
            Tasks.waitFor(futures);
            int futureCount = futures.size();
            futures.clear();
            if (taskFailed.get() && this.revertTask != null) {
                LOG.info("Reverting all {} succeeded tasks from {} futures", (Object)succeeded.size(), (Object)futureCount);
                for (Object item : succeeded) {
                    futures.add(this.service.submit(() -> {
                        if (this.stopRevertsOnFailure && revertFailed.get()) {
                            return;
                        }
                        boolean failed = true;
                        try {
                            this.revertTask.run(item);
                            failed = false;
                        }
                        catch (Exception e) {
                            LOG.error("Failed to revert task", (Throwable)e);
                        }
                        finally {
                            if (failed) {
                                revertFailed.set(true);
                            }
                        }
                    }));
                }
                Tasks.waitFor(futures);
            }
            if (!this.suppressExceptions && !exceptions.isEmpty()) {
                Tasks.throwOne(exceptions);
            }
            return !taskFailed.get();
        }
    }

    @FunctionalInterface
    public static interface FailureTask<I, E extends Exception> {
        public void run(I var1, Exception var2) throws E;
    }

    @FunctionalInterface
    public static interface Task<I, E extends Exception> {
        public void run(I var1) throws E;
    }
}

