/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import java.io.FileNotFoundException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.RemoteFileChangedException;
import org.apache.hadoop.fs.s3a.S3ARetryPolicy;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3GuardExistsRetryPolicy
extends S3ARetryPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(S3GuardExistsRetryPolicy.class);

    public S3GuardExistsRetryPolicy(Configuration conf) {
        super(conf);
    }

    @Override
    protected Map<Class<? extends Exception>, RetryPolicy> createExceptionMap() {
        Map<Class<? extends Exception>, RetryPolicy> b = super.createExceptionMap();
        Configuration conf = this.getConfiguration();
        int limit = conf.getInt("fs.s3a.s3guard.consistency.retry.limit", 7);
        long interval = conf.getTimeDuration("fs.s3a.s3guard.consistency.retry.interval", "2s", TimeUnit.MILLISECONDS);
        RetryPolicy retryPolicy = RetryPolicies.retryUpToMaximumCountWithProportionalSleep((int)limit, (long)interval, (TimeUnit)TimeUnit.MILLISECONDS);
        LOG.debug("Retrying on recoverable S3Guard table/S3 inconsistencies {} times with an initial interval of {}ms", (Object)limit, (Object)interval);
        b.put(FileNotFoundException.class, retryPolicy);
        b.put(RemoteFileChangedException.class, retryPolicy);
        return b;
    }
}

