/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import software.amazon.awssdk.transfer.s3.model.ObjectTransfer;
import software.amazon.awssdk.transfer.s3.progress.TransferListener;

public class ProgressableProgressListener
implements TransferListener {
    private static final Logger LOG = S3AFileSystem.LOG;
    private final S3AFileSystem fs;
    private final String key;
    private final Progressable progress;
    private long lastBytesTransferred;

    public ProgressableProgressListener(S3AFileSystem fs, String key, Progressable progress) {
        this.fs = fs;
        this.key = key;
        this.progress = progress;
        this.lastBytesTransferred = 0L;
    }

    public void transferInitiated(TransferListener.Context.TransferInitiated context) {
        this.fs.incrementWriteOperations();
    }

    public void transferComplete(TransferListener.Context.TransferComplete context) {
        this.fs.incrementWriteOperations();
    }

    public void bytesTransferred(TransferListener.Context.BytesTransferred context) {
        if (this.progress != null) {
            this.progress.progress();
        }
        long transferred = context.progressSnapshot().transferredBytes();
        long delta = transferred - this.lastBytesTransferred;
        this.fs.incrementPutProgressStatistics(this.key, delta);
        this.lastBytesTransferred = transferred;
    }

    public long uploadCompleted(ObjectTransfer upload) {
        long delta = upload.progress().snapshot().transferredBytes() - this.lastBytesTransferred;
        if (delta > 0L) {
            LOG.debug("S3A write delta changed after finished: {} bytes", (Object)delta);
            this.fs.incrementPutProgressStatistics(this.key, delta);
        }
        return delta;
    }
}

