/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.auth.NoAwsCredentialsException;
import org.apache.hadoop.fs.s3native.S3xLoginHelper;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class SimpleAWSCredentialsProvider
implements AwsCredentialsProvider {
    public static final String NAME = "org.apache.hadoop.fs.s3a.SimpleAWSCredentialsProvider";
    private final String accessKey;
    private final String secretKey;

    public SimpleAWSCredentialsProvider(URI uri, Configuration conf) throws IOException {
        this(S3AUtils.getAWSAccessKeys(uri, conf));
    }

    @VisibleForTesting
    SimpleAWSCredentialsProvider(S3xLoginHelper.Login login) throws IOException {
        this.accessKey = login.getUser();
        this.secretKey = login.getPassword();
    }

    public AwsCredentials resolveCredentials() {
        if (!StringUtils.isEmpty((CharSequence)this.accessKey) && !StringUtils.isEmpty((CharSequence)this.secretKey)) {
            return AwsBasicCredentials.create((String)this.accessKey, (String)this.secretKey);
        }
        throw new NoAwsCredentialsException("SimpleAWSCredentialsProvider", "No AWS credentials in the Hadoop configuration");
    }

    public String toString() {
        return "SimpleAWSCredentialsProvider{accessKey.empty=" + this.accessKey.isEmpty() + ", secretKey.empty=" + this.secretKey.isEmpty() + '}';
    }
}

