/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl.streams;

import java.lang.reflect.Constructor;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.VectoredIOContext;
import org.apache.hadoop.fs.s3a.impl.streams.InputStreamType;
import org.apache.hadoop.fs.s3a.impl.streams.ObjectInputStreamFactory;
import org.apache.hadoop.fs.store.LogExactlyOnce;
import org.apache.hadoop.util.ConfigurationHelper;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StreamIntegration {
    public static final String CLASSIC = "classic";
    public static final String PREFETCH = "prefetch";
    public static final String ANALYTICS = "analytics";
    public static final String CUSTOM = "custom";
    public static final String DEFAULT = "default";
    public static final InputStreamType DEFAULT_STREAM_TYPE = InputStreamType.Classic;
    private static final Logger LOG_DEPRECATION = LoggerFactory.getLogger((String)"org.apache.hadoop.conf.Configuration.deprecation");
    private static final LogExactlyOnce WARN_PREFETCH_KEY = new LogExactlyOnce(LOG_DEPRECATION);
    public static final String E_EMPTY_CUSTOM_CLASSNAME = "Configuration option fs.s3a.input.stream.custom.factory is required when the input stream type is \"custom\"";
    public static final String E_INVALID_STREAM_TYPE = "Invalid stream type:";

    private StreamIntegration() {
    }

    public static ObjectInputStreamFactory factoryFromConfig(Configuration conf) {
        return StreamIntegration.determineInputStreamType(conf).factory().apply(conf);
    }

    public static InputStreamType determineInputStreamType(Configuration conf) {
        if (conf.getBoolean("fs.s3a.prefetch.enabled", false)) {
            WARN_PREFETCH_KEY.info("Using {} is deprecated: choose the appropriate stream in {}", new Object[]{"fs.s3a.prefetch.enabled", "fs.s3a.input.stream.type"});
            return InputStreamType.Prefetch;
        }
        return (InputStreamType)ConfigurationHelper.resolveEnum((Configuration)conf, (String)"fs.s3a.input.stream.type", InputStreamType.class, s -> {
            if (StringUtils.isEmpty((CharSequence)s) || DEFAULT.equalsIgnoreCase((String)s)) {
                return DEFAULT_STREAM_TYPE;
            }
            throw new IllegalArgumentException("Invalid stream type: \"" + s + "\"");
        });
    }

    static ObjectInputStreamFactory loadCustomFactory(Configuration conf) {
        String name = conf.getTrimmed("fs.s3a.input.stream.custom.factory", "");
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)name) ? 1 : 0) != 0, (Object)E_EMPTY_CUSTOM_CLASSNAME);
        Class factoryClass = conf.getClass("fs.s3a.input.stream.custom.factory", null, ObjectInputStreamFactory.class);
        try {
            Constructor ctor = factoryClass.getConstructor(new Class[0]);
            return (ObjectInputStreamFactory)ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate custom class " + name + " " + e, e);
        }
    }

    public static VectoredIOContext populateVectoredIOContext(Configuration conf) {
        int minSeekVectored = (int)S3AUtils.longBytesOption(conf, "fs.s3a.vectored.read.min.seek.size", 131072L, 0L);
        int maxReadSizeVectored = (int)S3AUtils.longBytesOption(conf, "fs.s3a.vectored.read.max.merged.size", 0x200000L, 0L);
        int vectoredActiveRangeReads = S3AUtils.intOption(conf, "fs.s3a.vectored.active.ranged.reads", 4, 1);
        return new VectoredIOContext().setMinSeekForVectoredReads(minSeekVectored).setMaxReadSizeForVectoredReads(maxReadSizeVectored).setVectoredActiveRangeReads(vectoredActiveRangeReads);
    }
}

