/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.RetryPolicyFactory;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.azure.StorageInterface;
import org.apache.hadoop.fs.azure.StorageInterfaceImpl;

@InterfaceAudience.Private
class StorageInterfaceImpl
extends StorageInterface {
    private CloudBlobClient serviceClient;

    StorageInterfaceImpl() {
    }

    public void setRetryPolicyFactory(RetryPolicyFactory retryPolicyFactory) {
        this.serviceClient.getDefaultRequestOptions().setRetryPolicyFactory(retryPolicyFactory);
    }

    public void setTimeoutInMs(int timeoutInMs) {
        this.serviceClient.getDefaultRequestOptions().setTimeoutIntervalInMs(Integer.valueOf(timeoutInMs));
    }

    public void createBlobClient(CloudStorageAccount account) {
        this.serviceClient = account.createCloudBlobClient();
    }

    public void createBlobClient(URI baseUri) {
        this.serviceClient = new CloudBlobClient(baseUri);
    }

    public void createBlobClient(URI baseUri, StorageCredentials credentials) {
        this.serviceClient = new CloudBlobClient(baseUri, credentials);
    }

    public StorageCredentials getCredentials() {
        return this.serviceClient.getCredentials();
    }

    public StorageInterface.CloudBlobContainerWrapper getContainerReference(String uri) throws URISyntaxException, StorageException {
        return new CloudBlobContainerWrapperImpl(this.serviceClient.getContainerReference(uri));
    }
}

