/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.TestAzureConcurrentOutOfBandIo;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestAzureConcurrentOutOfBandIo {
    static final int DOWNLOAD_BLOCK_SIZE = 0x800000;
    static final int UPLOAD_BLOCK_SIZE = 0x400000;
    static final int BLOB_SIZE = 0x2000000;
    private static final int NUMBER_OF_BLOCKS = 2;
    private AzureBlobStorageTestAccount testAccount;

    @Before
    public void setUp() throws Exception {
        this.testAccount = AzureBlobStorageTestAccount.createOutOfBandStore((int)0x400000, (int)0x800000);
        Assume.assumeNotNull((Object[])new Object[]{this.testAccount});
    }

    @After
    public void tearDown() throws Exception {
        if (this.testAccount != null) {
            this.testAccount.cleanup();
            this.testAccount = null;
        }
    }

    @Test
    public void testReadOOBWrites() throws Exception {
        byte[] dataBlockWrite = new byte[0x400000];
        byte[] dataBlockRead = new byte[0x400000];
        DataOutputStream outputStream = this.testAccount.getStore().storefile("WASB_String.txt", new PermissionStatus("", "", FsPermission.getDefault()));
        Arrays.fill(dataBlockWrite, (byte)-1);
        for (int i = 0; i < 2; ++i) {
            ((OutputStream)outputStream).write(dataBlockWrite);
        }
        ((OutputStream)outputStream).flush();
        ((OutputStream)outputStream).close();
        DataBlockWriter writeBlockTask = new DataBlockWriter(this, this.testAccount, "WASB_String.txt");
        writeBlockTask.startWriting();
        int count = 0;
        DataInputStream inputStream = null;
        for (int i = 0; i < 5; ++i) {
            try {
                inputStream = this.testAccount.getStore().retrieve("WASB_String.txt");
                count = 0;
                int c = 0;
                while (c >= 0 && (c = inputStream.read(dataBlockRead, 0, 0x400000)) >= 0) {
                    count += c;
                }
            }
            catch (IOException e) {
                System.out.println(e.getCause().toString());
                e.printStackTrace();
                Assert.fail();
            }
            if (null == inputStream) continue;
            inputStream.close();
        }
        writeBlockTask.stopWriting();
        Assert.assertEquals((long)0x800000L, (long)count);
    }
}

