/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.azure.TestBlobTypeSpeedDifference;
import org.apache.hadoop.fs.azure.metrics.AzureFileSystemInstrumentation;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestBlobTypeSpeedDifference
extends TestCase {
    private static void writeTestFile(OutputStream writeStream, long size, long flushInterval) throws IOException {
        int bufferSize = (int)Math.min(1000L, flushInterval);
        byte[] buffer = new byte[bufferSize];
        Arrays.fill(buffer, (byte)7);
        int bytesWritten = 0;
        int bytesUnflushed = 0;
        while ((long)bytesWritten < size) {
            int numberToWrite = (int)Math.min((long)bufferSize, size - (long)bytesWritten);
            writeStream.write(buffer, 0, numberToWrite);
            bytesWritten += numberToWrite;
            if ((long)(bytesUnflushed += numberToWrite) < flushInterval) continue;
            writeStream.flush();
            bytesUnflushed = 0;
        }
    }

    private static TestResult writeTestFile(NativeAzureFileSystem fs, Path path, long size, long flushInterval) throws IOException {
        AzureFileSystemInstrumentation instrumentation = fs.getInstrumentation();
        long initialRequests = instrumentation.getCurrentWebResponses();
        Date start = new Date();
        FSDataOutputStream output = fs.create(path);
        TestBlobTypeSpeedDifference.writeTestFile((OutputStream)output, (long)size, (long)flushInterval);
        output.close();
        long finalRequests = instrumentation.getCurrentWebResponses();
        return new TestResult(new Date().getTime() - start.getTime(), finalRequests - initialRequests);
    }

    private static TestResult writeBlockBlobTestFile(NativeAzureFileSystem fs, long size, long flushInterval) throws IOException {
        return TestBlobTypeSpeedDifference.writeTestFile((NativeAzureFileSystem)fs, (Path)new Path("/blockBlob"), (long)size, (long)flushInterval);
    }

    private static TestResult writePageBlobTestFile(NativeAzureFileSystem fs, long size, long flushInterval) throws IOException {
        return TestBlobTypeSpeedDifference.writeTestFile((NativeAzureFileSystem)fs, (Path)AzureBlobStorageTestAccount.pageBlobPath((String)"pageBlob"), (long)size, (long)flushInterval);
    }

    @Test
    public void testTenKbFileFrequentFlush() throws Exception {
        AzureBlobStorageTestAccount testAccount = AzureBlobStorageTestAccount.create();
        if (testAccount == null) {
            return;
        }
        try {
            TestBlobTypeSpeedDifference.testForSizeAndFlushInterval((NativeAzureFileSystem)testAccount.getFileSystem(), (long)10000L, (long)500L);
        }
        finally {
            testAccount.cleanup();
        }
    }

    private static void testForSizeAndFlushInterval(NativeAzureFileSystem fs, long size, long flushInterval) throws IOException {
        for (int i = 0; i < 5; ++i) {
            TestResult pageBlobResults = TestBlobTypeSpeedDifference.writePageBlobTestFile((NativeAzureFileSystem)fs, (long)size, (long)flushInterval);
            System.out.printf("Page blob upload took %d ms. Total number of requests: %d.\n", pageBlobResults.timeTakenInMs, pageBlobResults.totalNumberOfRequests);
            TestResult blockBlobResults = TestBlobTypeSpeedDifference.writeBlockBlobTestFile((NativeAzureFileSystem)fs, (long)size, (long)flushInterval);
            System.out.printf("Block blob upload took %d ms. Total number of requests: %d.\n", blockBlobResults.timeTakenInMs, blockBlobResults.totalNumberOfRequests);
        }
    }

    public static void main(String[] argv) throws Exception {
        Configuration conf = new Configuration();
        long size = 10000000L;
        long flushInterval = 2000L;
        if (argv.length > 0) {
            size = Long.parseLong(argv[0]);
        }
        if (argv.length > 1) {
            flushInterval = Long.parseLong(argv[1]);
        }
        TestBlobTypeSpeedDifference.testForSizeAndFlushInterval((NativeAzureFileSystem)((NativeAzureFileSystem)FileSystem.get((Configuration)conf)), (long)size, (long)flushInterval);
    }
}

