/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import com.microsoft.azure.storage.blob.BlobOutputStream;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import java.io.FileNotFoundException;
import java.util.EnumSet;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.AzureException;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestContainerChecks {
    private AzureBlobStorageTestAccount testAccount;

    @After
    public void tearDown() throws Exception {
        if (this.testAccount != null) {
            this.testAccount.cleanup();
            this.testAccount = null;
        }
    }

    @Test
    public void testContainerExistAfterDoesNotExist() throws Exception {
        this.testAccount = AzureBlobStorageTestAccount.create((String)"", EnumSet.noneOf(AzureBlobStorageTestAccount.CreateOptions.class));
        Assume.assumeNotNull((Object[])new Object[]{this.testAccount});
        CloudBlobContainer container = this.testAccount.getRealContainer();
        NativeAzureFileSystem fs = this.testAccount.getFileSystem();
        Assert.assertFalse((boolean)container.exists());
        try {
            fs.listStatus(new Path("/"));
            Assert.assertTrue((String)"Should've thrown.", (boolean)false);
        }
        catch (FileNotFoundException ex) {
            Assert.assertTrue((String)("Unexpected exception: " + ex), (boolean)ex.getMessage().contains("does not exist."));
        }
        Assert.assertFalse((boolean)container.exists());
        container.create();
        CloudBlockBlob blob = this.testAccount.getBlobReference("foo");
        BlobOutputStream outputStream = blob.openOutputStream();
        outputStream.write(new byte[10]);
        outputStream.close();
        Assert.assertTrue((boolean)fs.exists(new Path("/foo")));
        Assert.assertTrue((boolean)container.exists());
    }

    @Test
    public void testContainerCreateAfterDoesNotExist() throws Exception {
        this.testAccount = AzureBlobStorageTestAccount.create((String)"", EnumSet.noneOf(AzureBlobStorageTestAccount.CreateOptions.class));
        Assume.assumeNotNull((Object[])new Object[]{this.testAccount});
        CloudBlobContainer container = this.testAccount.getRealContainer();
        NativeAzureFileSystem fs = this.testAccount.getFileSystem();
        Assert.assertFalse((boolean)container.exists());
        try {
            Assert.assertNull((Object)fs.listStatus(new Path("/")));
            Assert.assertTrue((String)"Should've thrown.", (boolean)false);
        }
        catch (FileNotFoundException ex) {
            Assert.assertTrue((String)("Unexpected exception: " + ex), (boolean)ex.getMessage().contains("does not exist."));
        }
        Assert.assertFalse((boolean)container.exists());
        container.create();
        Assert.assertTrue((boolean)fs.createNewFile(new Path("/foo")));
        Assert.assertTrue((boolean)container.exists());
    }

    @Test
    public void testContainerCreateOnWrite() throws Exception {
        this.testAccount = AzureBlobStorageTestAccount.create((String)"", EnumSet.noneOf(AzureBlobStorageTestAccount.CreateOptions.class));
        Assume.assumeNotNull((Object[])new Object[]{this.testAccount});
        CloudBlobContainer container = this.testAccount.getRealContainer();
        NativeAzureFileSystem fs = this.testAccount.getFileSystem();
        Assert.assertFalse((boolean)container.exists());
        try {
            fs.listStatus(new Path("/"));
            Assert.assertTrue((String)"Should've thrown.", (boolean)false);
        }
        catch (FileNotFoundException ex) {
            Assert.assertTrue((String)("Unexpected exception: " + ex), (boolean)ex.getMessage().contains("does not exist."));
        }
        Assert.assertFalse((boolean)container.exists());
        try {
            fs.open(new Path("/foo"));
            Assert.assertFalse((String)"Should've thrown.", (boolean)true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)container.exists());
        Assert.assertFalse((boolean)fs.rename(new Path("/foo"), new Path("/bar")));
        Assert.assertFalse((boolean)container.exists());
        Assert.assertTrue((boolean)fs.createNewFile(new Path("/foo")));
        Assert.assertTrue((boolean)container.exists());
    }

    @Test
    public void testContainerChecksWithSas() throws Exception {
        this.testAccount = AzureBlobStorageTestAccount.create((String)"", EnumSet.of(AzureBlobStorageTestAccount.CreateOptions.UseSas));
        Assume.assumeNotNull((Object[])new Object[]{this.testAccount});
        CloudBlobContainer container = this.testAccount.getRealContainer();
        NativeAzureFileSystem fs = this.testAccount.getFileSystem();
        Assert.assertFalse((boolean)container.exists());
        try {
            fs.createNewFile(new Path("/foo"));
            Assert.assertFalse((String)"Should've thrown.", (boolean)true);
        }
        catch (AzureException azureException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)container.exists());
    }
}

