/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestNativeAzureFileSystemBlockLocations {
    @Test
    public void testNumberOfBlocks() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.azure.block.size", "500");
        AzureBlobStorageTestAccount testAccount = AzureBlobStorageTestAccount.createMock((Configuration)conf);
        NativeAzureFileSystem fs = testAccount.getFileSystem();
        Path testFile = TestNativeAzureFileSystemBlockLocations.createTestFile((FileSystem)fs, (int)1200);
        FileStatus stat = fs.getFileStatus(testFile);
        Assert.assertEquals((long)500L, (long)stat.getBlockSize());
        testAccount.cleanup();
    }

    @Test
    public void testBlockLocationsTypical() throws Exception {
        BlockLocation[] locations = TestNativeAzureFileSystemBlockLocations.getBlockLocationsOutput((int)210, (int)50, (long)0L, (long)210L);
        Assert.assertEquals((long)5L, (long)locations.length);
        Assert.assertEquals((Object)"localhost", (Object)locations[0].getHosts()[0]);
        Assert.assertEquals((long)50L, (long)locations[0].getLength());
        Assert.assertEquals((long)10L, (long)locations[4].getLength());
        Assert.assertEquals((long)100L, (long)locations[2].getOffset());
    }

    @Test
    public void testBlockLocationsEmptyFile() throws Exception {
        BlockLocation[] locations = TestNativeAzureFileSystemBlockLocations.getBlockLocationsOutput((int)0, (int)50, (long)0L, (long)0L);
        Assert.assertEquals((long)0L, (long)locations.length);
    }

    @Test
    public void testBlockLocationsSmallFile() throws Exception {
        BlockLocation[] locations = TestNativeAzureFileSystemBlockLocations.getBlockLocationsOutput((int)1, (int)50, (long)0L, (long)1L);
        Assert.assertEquals((long)1L, (long)locations.length);
        Assert.assertEquals((long)1L, (long)locations[0].getLength());
    }

    @Test
    public void testBlockLocationsExactBlockSizeMultiple() throws Exception {
        BlockLocation[] locations = TestNativeAzureFileSystemBlockLocations.getBlockLocationsOutput((int)200, (int)50, (long)0L, (long)200L);
        Assert.assertEquals((long)4L, (long)locations.length);
        Assert.assertEquals((long)150L, (long)locations[3].getOffset());
        Assert.assertEquals((long)50L, (long)locations[3].getLength());
    }

    @Test
    public void testBlockLocationsSubsetOfFile() throws Exception {
        BlockLocation[] locations = TestNativeAzureFileSystemBlockLocations.getBlockLocationsOutput((int)205, (int)10, (long)15L, (long)35L);
        Assert.assertEquals((long)4L, (long)locations.length);
        Assert.assertEquals((long)10L, (long)locations[0].getLength());
        Assert.assertEquals((long)15L, (long)locations[0].getOffset());
        Assert.assertEquals((long)5L, (long)locations[3].getLength());
        Assert.assertEquals((long)45L, (long)locations[3].getOffset());
    }

    @Test
    public void testBlockLocationsOutOfRangeSubsetOfFile() throws Exception {
        BlockLocation[] locations = TestNativeAzureFileSystemBlockLocations.getBlockLocationsOutput((int)205, (int)10, (long)300L, (long)10L);
        Assert.assertEquals((long)0L, (long)locations.length);
    }

    @Test
    public void testBlockLocationsEmptySubsetOfFile() throws Exception {
        BlockLocation[] locations = TestNativeAzureFileSystemBlockLocations.getBlockLocationsOutput((int)205, (int)10, (long)0L, (long)0L);
        Assert.assertEquals((long)0L, (long)locations.length);
    }

    @Test
    public void testBlockLocationsDifferentLocationHost() throws Exception {
        BlockLocation[] locations = TestNativeAzureFileSystemBlockLocations.getBlockLocationsOutput((int)100, (int)10, (long)0L, (long)100L, (String)"myblobhost");
        Assert.assertEquals((long)10L, (long)locations.length);
        Assert.assertEquals((Object)"myblobhost", (Object)locations[0].getHosts()[0]);
    }

    private static BlockLocation[] getBlockLocationsOutput(int fileSize, int blockSize, long start, long len) throws Exception {
        return TestNativeAzureFileSystemBlockLocations.getBlockLocationsOutput((int)fileSize, (int)blockSize, (long)start, (long)len, null);
    }

    private static BlockLocation[] getBlockLocationsOutput(int fileSize, int blockSize, long start, long len, String blockLocationHost) throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.azure.block.size", "" + blockSize);
        if (blockLocationHost != null) {
            conf.set("fs.azure.block.location.impersonatedhost", blockLocationHost);
        }
        AzureBlobStorageTestAccount testAccount = AzureBlobStorageTestAccount.createMock((Configuration)conf);
        NativeAzureFileSystem fs = testAccount.getFileSystem();
        Path testFile = TestNativeAzureFileSystemBlockLocations.createTestFile((FileSystem)fs, (int)fileSize);
        FileStatus stat = fs.getFileStatus(testFile);
        BlockLocation[] locations = fs.getFileBlockLocations(stat, start, len);
        testAccount.cleanup();
        return locations;
    }

    private static Path createTestFile(FileSystem fs, int size) throws Exception {
        Path testFile = new Path("/testFile");
        FSDataOutputStream outputStream = fs.create(testFile);
        outputStream.write(new byte[size]);
        outputStream.close();
        return testFile;
    }
}

