/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure.metrics;

import java.util.Arrays;
import java.util.Date;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.AzureException;
import org.apache.hadoop.fs.azure.AzureNativeFileSystemStore;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.azure.metrics.AzureFileSystemInstrumentation;
import org.apache.hadoop.fs.azure.metrics.AzureMetricsTestUtil;
import org.apache.hadoop.fs.azure.metrics.BandwidthGaugeUpdater;
import org.apache.hadoop.fs.azure.metrics.TestAzureFileSystemInstrumentation;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.test.MetricsAsserts;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestAzureFileSystemInstrumentation {
    private FileSystem fs;
    private AzureBlobStorageTestAccount testAccount;

    @Before
    public void setUp() throws Exception {
        this.testAccount = AzureBlobStorageTestAccount.create();
        if (this.testAccount != null) {
            this.fs = this.testAccount.getFileSystem();
        }
        Assume.assumeNotNull((Object[])new Object[]{this.testAccount});
    }

    @After
    public void tearDown() throws Exception {
        if (this.testAccount != null) {
            this.testAccount.cleanup();
            this.testAccount = null;
            this.fs = null;
        }
    }

    @Test
    public void testMetricTags() throws Exception {
        String accountName = this.testAccount.getRealAccount().getBlobEndpoint().getAuthority();
        String containerName = this.testAccount.getRealContainer().getName();
        MetricsRecordBuilder myMetrics = this.getMyMetrics();
        ((MetricsRecordBuilder)Mockito.verify((Object)myMetrics)).add((MetricsTag)Matchers.argThat((Matcher)new TagMatcher("accountName", accountName)));
        ((MetricsRecordBuilder)Mockito.verify((Object)myMetrics)).add((MetricsTag)Matchers.argThat((Matcher)new TagMatcher("containerName", containerName)));
        ((MetricsRecordBuilder)Mockito.verify((Object)myMetrics)).add((MetricsTag)Matchers.argThat((Matcher)new TagMatcher("Context", "azureFileSystem")));
        ((MetricsRecordBuilder)Mockito.verify((Object)myMetrics)).add((MetricsTag)Matchers.argThat((Matcher)new TagExistsMatcher("wasbFileSystemId")));
    }

    @Test
    public void testMetricsOnMkdirList() throws Exception {
        long base = this.getBaseWebResponses();
        Assert.assertTrue((boolean)this.fs.mkdirs(new Path("a")));
        base = this.assertWebResponsesInRange(base, 1L, 12L);
        Assert.assertEquals((long)1L, (long)AzureMetricsTestUtil.getLongCounterValue((AzureFileSystemInstrumentation)this.getInstrumentation(), (String)"wasb_directories_created"));
        Assert.assertEquals((long)1L, (long)this.fs.listStatus(new Path("/")).length);
        base = this.assertWebResponsesEquals(base, 1L);
        this.assertNoErrors();
    }

    private BandwidthGaugeUpdater getBandwidthGaugeUpdater() {
        NativeAzureFileSystem azureFs = (NativeAzureFileSystem)this.fs;
        AzureNativeFileSystemStore azureStore = azureFs.getStore();
        return azureStore.getBandwidthGaugeUpdater();
    }

    private static byte[] nonZeroByteArray(int size) {
        byte[] data = new byte[size];
        Arrays.fill(data, (byte)5);
        return data;
    }

    @Test
    public void testMetricsOnFileCreateRead() throws Exception {
        long base = this.getBaseWebResponses();
        Assert.assertEquals((long)0L, (long)AzureMetricsTestUtil.getCurrentBytesWritten((AzureFileSystemInstrumentation)this.getInstrumentation()));
        Path filePath = new Path("/metricsTest_webResponses");
        int FILE_SIZE = 1000;
        this.getBandwidthGaugeUpdater().suppressAutoUpdate();
        Date start = new Date();
        FSDataOutputStream outputStream = this.fs.create(filePath);
        outputStream.write(TestAzureFileSystemInstrumentation.nonZeroByteArray((int)1000));
        outputStream.close();
        long uploadDurationMs = new Date().getTime() - start.getTime();
        this.logOpResponseCount("Creating a 1K file", base);
        base = this.assertWebResponsesInRange(base, 2L, 15L);
        this.getBandwidthGaugeUpdater().triggerUpdate(true);
        long bytesWritten = AzureMetricsTestUtil.getCurrentBytesWritten((AzureFileSystemInstrumentation)this.getInstrumentation());
        Assert.assertTrue((String)("The bytes written in the last second " + bytesWritten + " is pretty far from the expected range of around " + 1000 + " bytes plus a little overhead."), (bytesWritten > 500L && bytesWritten < 2000L ? 1 : 0) != 0);
        long totalBytesWritten = AzureMetricsTestUtil.getCurrentTotalBytesWritten((AzureFileSystemInstrumentation)this.getInstrumentation());
        Assert.assertTrue((String)("The total bytes written  " + totalBytesWritten + " is pretty far from the expected range of around " + 1000 + " bytes plus a little overhead."), (totalBytesWritten >= 1000L && totalBytesWritten < 2000L ? 1 : 0) != 0);
        long uploadRate = AzureMetricsTestUtil.getLongGaugeValue((AzureFileSystemInstrumentation)this.getInstrumentation(), (String)"wasb_maximum_upload_bytes_per_second");
        System.out.println("Upload rate: " + uploadRate + " bytes/second.");
        long expectedRate = 1000000L / uploadDurationMs;
        Assert.assertTrue((String)("The upload rate " + uploadRate + " is below the expected range of around " + expectedRate + " bytes/second that the unit test observed. This should never be" + " the case since the test underestimates the rate by looking at " + " end-to-end time instead of just block upload time."), (uploadRate >= expectedRate ? 1 : 0) != 0);
        long uploadLatency = AzureMetricsTestUtil.getLongGaugeValue((AzureFileSystemInstrumentation)this.getInstrumentation(), (String)"wasb_average_block_upload_latency_ms");
        System.out.println("Upload latency: " + uploadLatency);
        long expectedLatency = uploadDurationMs;
        Assert.assertTrue((String)("The upload latency " + uploadLatency + " should be greater than zero now that I've just uploaded a file."), (uploadLatency > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)("The upload latency " + uploadLatency + " is more than the expected range of around " + expectedLatency + " milliseconds that the unit test observed. This should never be" + " the case since the test overestimates the latency by looking at " + " end-to-end time instead of just block upload time."), (uploadLatency <= expectedLatency ? 1 : 0) != 0);
        start = new Date();
        FSDataInputStream inputStream = this.fs.open(filePath);
        int count = 0;
        while (inputStream.read() >= 0) {
            ++count;
        }
        inputStream.close();
        long downloadDurationMs = new Date().getTime() - start.getTime();
        Assert.assertEquals((long)1000L, (long)count);
        this.logOpResponseCount("Reading a 1K file", base);
        base = this.assertWebResponsesInRange(base, 1L, 10L);
        this.getBandwidthGaugeUpdater().triggerUpdate(false);
        long totalBytesRead = AzureMetricsTestUtil.getCurrentTotalBytesRead((AzureFileSystemInstrumentation)this.getInstrumentation());
        Assert.assertEquals((long)1000L, (long)totalBytesRead);
        long bytesRead = AzureMetricsTestUtil.getCurrentBytesRead((AzureFileSystemInstrumentation)this.getInstrumentation());
        Assert.assertTrue((String)("The bytes read in the last second " + bytesRead + " is pretty far from the expected range of around " + 1000 + " bytes plus a little overhead."), (bytesRead > 500L && bytesRead < 2000L ? 1 : 0) != 0);
        long downloadRate = AzureMetricsTestUtil.getLongGaugeValue((AzureFileSystemInstrumentation)this.getInstrumentation(), (String)"wasb_maximum_download_bytes_per_second");
        System.out.println("Download rate: " + downloadRate + " bytes/second.");
        expectedRate = 1000000L / downloadDurationMs;
        Assert.assertTrue((String)("The download rate " + downloadRate + " is below the expected range of around " + expectedRate + " bytes/second that the unit test observed. This should never be" + " the case since the test underestimates the rate by looking at " + " end-to-end time instead of just block download time."), (downloadRate >= expectedRate ? 1 : 0) != 0);
        long downloadLatency = AzureMetricsTestUtil.getLongGaugeValue((AzureFileSystemInstrumentation)this.getInstrumentation(), (String)"wasb_average_block_download_latency_ms");
        System.out.println("Download latency: " + downloadLatency);
        expectedLatency = downloadDurationMs;
        Assert.assertTrue((String)("The download latency " + downloadLatency + " should be greater than zero now that I've just downloaded a file."), (downloadLatency > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)("The download latency " + downloadLatency + " is more than the expected range of around " + expectedLatency + " milliseconds that the unit test observed. This should never be" + " the case since the test overestimates the latency by looking at " + " end-to-end time instead of just block download time."), (downloadLatency <= expectedLatency ? 1 : 0) != 0);
        this.assertNoErrors();
    }

    @Test
    public void testMetricsOnBigFileCreateRead() throws Exception {
        long base = this.getBaseWebResponses();
        Assert.assertEquals((long)0L, (long)AzureMetricsTestUtil.getCurrentBytesWritten((AzureFileSystemInstrumentation)this.getInstrumentation()));
        Path filePath = new Path("/metricsTest_webResponses");
        int FILE_SIZE = 0x6400000;
        this.getBandwidthGaugeUpdater().suppressAutoUpdate();
        FSDataOutputStream outputStream = this.fs.create(filePath);
        outputStream.write(new byte[0x6400000]);
        outputStream.close();
        this.logOpResponseCount("Creating a 100 MB file", base);
        base = this.assertWebResponsesInRange(base, 20L, 50L);
        this.getBandwidthGaugeUpdater().triggerUpdate(true);
        long totalBytesWritten = AzureMetricsTestUtil.getCurrentTotalBytesWritten((AzureFileSystemInstrumentation)this.getInstrumentation());
        Assert.assertTrue((String)("The total bytes written  " + totalBytesWritten + " is pretty far from the expected range of around " + 0x6400000 + " bytes plus a little overhead."), (totalBytesWritten >= 0x6400000L && totalBytesWritten < 0xC800000L ? 1 : 0) != 0);
        long uploadRate = AzureMetricsTestUtil.getLongGaugeValue((AzureFileSystemInstrumentation)this.getInstrumentation(), (String)"wasb_maximum_upload_bytes_per_second");
        System.out.println("Upload rate: " + uploadRate + " bytes/second.");
        long uploadLatency = AzureMetricsTestUtil.getLongGaugeValue((AzureFileSystemInstrumentation)this.getInstrumentation(), (String)"wasb_average_block_upload_latency_ms");
        System.out.println("Upload latency: " + uploadLatency);
        Assert.assertTrue((String)("The upload latency " + uploadLatency + " should be greater than zero now that I've just uploaded a file."), (uploadLatency > 0L ? 1 : 0) != 0);
        FSDataInputStream inputStream = this.fs.open(filePath);
        int count = 0;
        while (inputStream.read() >= 0) {
            ++count;
        }
        inputStream.close();
        Assert.assertEquals((long)0x6400000L, (long)count);
        this.logOpResponseCount("Reading a 100 MB file", base);
        base = this.assertWebResponsesInRange(base, 20L, 40L);
        this.getBandwidthGaugeUpdater().triggerUpdate(false);
        long totalBytesRead = AzureMetricsTestUtil.getCurrentTotalBytesRead((AzureFileSystemInstrumentation)this.getInstrumentation());
        Assert.assertEquals((long)0x6400000L, (long)totalBytesRead);
        long downloadRate = AzureMetricsTestUtil.getLongGaugeValue((AzureFileSystemInstrumentation)this.getInstrumentation(), (String)"wasb_maximum_download_bytes_per_second");
        System.out.println("Download rate: " + downloadRate + " bytes/second.");
        long downloadLatency = AzureMetricsTestUtil.getLongGaugeValue((AzureFileSystemInstrumentation)this.getInstrumentation(), (String)"wasb_average_block_download_latency_ms");
        System.out.println("Download latency: " + downloadLatency);
        Assert.assertTrue((String)("The download latency " + downloadLatency + " should be greater than zero now that I've just downloaded a file."), (downloadLatency > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testMetricsOnFileRename() throws Exception {
        long base = this.getBaseWebResponses();
        Path originalPath = new Path("/metricsTest_RenameStart");
        Path destinationPath = new Path("/metricsTest_RenameFinal");
        Assert.assertEquals((long)0L, (long)AzureMetricsTestUtil.getLongCounterValue((AzureFileSystemInstrumentation)this.getInstrumentation(), (String)"wasb_files_created"));
        Assert.assertTrue((boolean)this.fs.createNewFile(originalPath));
        this.logOpResponseCount("Creating an empty file", base);
        base = this.assertWebResponsesInRange(base, 2L, 20L);
        Assert.assertEquals((long)1L, (long)AzureMetricsTestUtil.getLongCounterValue((AzureFileSystemInstrumentation)this.getInstrumentation(), (String)"wasb_files_created"));
        Assert.assertTrue((boolean)this.fs.rename(originalPath, destinationPath));
        this.logOpResponseCount("Renaming a file", base);
        base = this.assertWebResponsesInRange(base, 2L, 15L);
        this.assertNoErrors();
    }

    @Test
    public void testMetricsOnFileExistsDelete() throws Exception {
        long base = this.getBaseWebResponses();
        Path filePath = new Path("/metricsTest_delete");
        Assert.assertFalse((boolean)this.fs.exists(filePath));
        this.logOpResponseCount("Checking file existence for non-existent file", base);
        base = this.assertWebResponsesInRange(base, 1L, 3L);
        Assert.assertTrue((boolean)this.fs.createNewFile(filePath));
        base = this.getCurrentWebResponses();
        Assert.assertTrue((boolean)this.fs.exists(filePath));
        this.logOpResponseCount("Checking file existence for existent file", base);
        base = this.assertWebResponsesInRange(base, 1L, 2L);
        Assert.assertEquals((long)0L, (long)AzureMetricsTestUtil.getLongCounterValue((AzureFileSystemInstrumentation)this.getInstrumentation(), (String)"wasb_files_deleted"));
        Assert.assertTrue((boolean)this.fs.delete(filePath, false));
        this.logOpResponseCount("Deleting a file", base);
        base = this.assertWebResponsesInRange(base, 1L, 4L);
        Assert.assertEquals((long)1L, (long)AzureMetricsTestUtil.getLongCounterValue((AzureFileSystemInstrumentation)this.getInstrumentation(), (String)"wasb_files_deleted"));
        this.assertNoErrors();
    }

    @Test
    public void testMetricsOnDirRename() throws Exception {
        long base = this.getBaseWebResponses();
        Path originalDirName = new Path("/metricsTestDirectory_RenameStart");
        Path innerFileName = new Path(originalDirName, "innerFile");
        Path destDirName = new Path("/metricsTestDirectory_RenameFinal");
        Assert.assertTrue((boolean)this.fs.mkdirs(originalDirName));
        base = this.getCurrentWebResponses();
        Assert.assertTrue((boolean)this.fs.createNewFile(innerFileName));
        base = this.getCurrentWebResponses();
        Assert.assertTrue((boolean)this.fs.rename(originalDirName, destDirName));
        this.logOpResponseCount("Renaming a directory", base);
        base = this.assertWebResponsesInRange(base, 1L, 20L);
        this.assertNoErrors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientErrorMetrics() throws Exception {
        String directoryName = "metricsTestDirectory_ClientError";
        Path directoryPath = new Path("/" + directoryName);
        Assert.assertTrue((boolean)this.fs.mkdirs(directoryPath));
        String leaseID = this.testAccount.acquireShortLease(directoryName);
        try {
            try {
                this.fs.delete(directoryPath, true);
                Assert.assertTrue((String)"Should've thrown.", (boolean)false);
            }
            catch (AzureException ex) {
                Assert.assertTrue((String)("Unexpected exception: " + (Object)((Object)ex)), (boolean)ex.getMessage().contains("lease"));
            }
            Assert.assertEquals((long)1L, (long)AzureMetricsTestUtil.getLongCounterValue((AzureFileSystemInstrumentation)this.getInstrumentation(), (String)"wasb_client_errors"));
            Assert.assertEquals((long)0L, (long)AzureMetricsTestUtil.getLongCounterValue((AzureFileSystemInstrumentation)this.getInstrumentation(), (String)"wasb_server_errors"));
        }
        finally {
            this.testAccount.releaseLease(leaseID, directoryName);
        }
    }

    private void logOpResponseCount(String opName, long base) {
        System.out.println(opName + " took " + (this.getCurrentWebResponses() - base) + " web responses to complete.");
    }

    private long getBaseWebResponses() {
        return this.assertWebResponsesEquals(0L, 0L);
    }

    private long getCurrentWebResponses() {
        return AzureMetricsTestUtil.getCurrentWebResponses((AzureFileSystemInstrumentation)this.getInstrumentation());
    }

    private long assertWebResponsesEquals(long base, long expected) {
        MetricsAsserts.assertCounter((String)"wasb_web_responses", (long)(base + expected), (MetricsRecordBuilder)this.getMyMetrics());
        return base + expected;
    }

    private void assertNoErrors() {
        Assert.assertEquals((long)0L, (long)AzureMetricsTestUtil.getLongCounterValue((AzureFileSystemInstrumentation)this.getInstrumentation(), (String)"wasb_client_errors"));
        Assert.assertEquals((long)0L, (long)AzureMetricsTestUtil.getLongCounterValue((AzureFileSystemInstrumentation)this.getInstrumentation(), (String)"wasb_server_errors"));
    }

    private long assertWebResponsesInRange(long base, long inclusiveLowerLimit, long inclusiveUpperLimit) {
        long currentResponses = this.getCurrentWebResponses();
        long justOperation = currentResponses - base;
        Assert.assertTrue((String)String.format("Web responses expected in range [%d, %d], but was %d.", inclusiveLowerLimit, inclusiveUpperLimit, justOperation), (justOperation >= inclusiveLowerLimit && justOperation <= inclusiveUpperLimit ? 1 : 0) != 0);
        return currentResponses;
    }

    private MetricsRecordBuilder getMyMetrics() {
        return MetricsAsserts.getMetrics((MetricsSource)this.getInstrumentation());
    }

    private AzureFileSystemInstrumentation getInstrumentation() {
        return ((NativeAzureFileSystem)this.fs).getInstrumentation();
    }
}

