/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azure.KeyProvider;
import org.apache.hadoop.fs.azure.KeyProviderException;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.security.ProviderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SimpleKeyProvider
implements KeyProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleKeyProvider.class);
    protected static final String KEY_ACCOUNT_KEY_PREFIX = "fs.azure.account.key.";

    @Override
    public String getStorageAccountKey(String accountName, Configuration conf) throws KeyProviderException {
        String key = null;
        try {
            Configuration c = ProviderUtils.excludeIncompatibleCredentialProviders((Configuration)conf, NativeAzureFileSystem.class);
            char[] keyChars = c.getPassword(this.getStorageAccountKeyName(accountName));
            if (keyChars != null) {
                key = new String(keyChars);
            }
        }
        catch (IOException ioe) {
            LOG.warn("Unable to get key from credential providers.", (Throwable)ioe);
        }
        return key;
    }

    protected String getStorageAccountKeyName(String accountName) {
        return KEY_ACCOUNT_KEY_PREFIX + accountName;
    }
}

