/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.RetryPolicyFactory;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobListingDetails;
import com.microsoft.azure.storage.blob.BlobProperties;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.BlockEntry;
import com.microsoft.azure.storage.blob.BlockListingFilter;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CopyState;
import com.microsoft.azure.storage.blob.ListBlobItem;
import com.microsoft.azure.storage.blob.PageRange;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.azure.SelfRenewingLease;

@InterfaceAudience.Private
abstract class StorageInterface {
    StorageInterface() {
    }

    public abstract void setTimeoutInMs(int var1);

    public abstract void setRetryPolicyFactory(RetryPolicyFactory var1);

    public abstract void createBlobClient(CloudStorageAccount var1);

    public abstract void createBlobClient(URI var1);

    public abstract void createBlobClient(URI var1, StorageCredentials var2);

    public abstract StorageCredentials getCredentials();

    public abstract CloudBlobContainerWrapper getContainerReference(String var1) throws URISyntaxException, StorageException;

    public static interface CloudPageBlobWrapper
    extends CloudBlobWrapper {
        public void create(long var1, BlobRequestOptions var3, OperationContext var4) throws StorageException;

        public void uploadPages(InputStream var1, long var2, long var4, BlobRequestOptions var6, OperationContext var7) throws StorageException, IOException;

        public ArrayList<PageRange> downloadPageRanges(BlobRequestOptions var1, OperationContext var2) throws StorageException;

        @Override
        public void uploadMetadata(OperationContext var1) throws StorageException;
    }

    public static interface CloudBlockBlobWrapper
    extends CloudBlobWrapper {
        public OutputStream openOutputStream(BlobRequestOptions var1, OperationContext var2) throws StorageException;

        public List<BlockEntry> downloadBlockList(BlockListingFilter var1, BlobRequestOptions var2, OperationContext var3) throws IOException, StorageException;

        public void uploadBlock(String var1, AccessCondition var2, InputStream var3, long var4, BlobRequestOptions var6, OperationContext var7) throws IOException, StorageException;

        public void commitBlockList(List<BlockEntry> var1, AccessCondition var2, BlobRequestOptions var3, OperationContext var4) throws IOException, StorageException;
    }

    @InterfaceAudience.Private
    public static interface CloudBlobWrapper
    extends ListBlobItem {
        public URI getUri();

        public HashMap<String, String> getMetadata();

        public void setMetadata(HashMap<String, String> var1);

        public void startCopyFromBlob(CloudBlobWrapper var1, BlobRequestOptions var2, OperationContext var3, boolean var4) throws StorageException, URISyntaxException;

        public CopyState getCopyState();

        public void downloadRange(long var1, long var3, OutputStream var5, BlobRequestOptions var6, OperationContext var7) throws StorageException, IOException;

        public void delete(OperationContext var1, SelfRenewingLease var2) throws StorageException;

        public boolean exists(OperationContext var1) throws StorageException;

        public void downloadAttributes(OperationContext var1) throws StorageException;

        public BlobProperties getProperties();

        public InputStream openInputStream(BlobRequestOptions var1, OperationContext var2) throws StorageException;

        public void uploadMetadata(OperationContext var1) throws StorageException;

        public void uploadMetadata(AccessCondition var1, BlobRequestOptions var2, OperationContext var3) throws StorageException;

        public void uploadProperties(OperationContext var1, SelfRenewingLease var2) throws StorageException;

        public SelfRenewingLease acquireLease() throws StorageException;

        public int getStreamMinimumReadSizeInBytes();

        public void setStreamMinimumReadSizeInBytes(int var1);

        public void setWriteBlockSizeInBytes(int var1);

        public CloudBlob getBlob();
    }

    @InterfaceAudience.Private
    public static abstract class CloudBlobContainerWrapper {
        public abstract String getName();

        public abstract boolean exists(OperationContext var1) throws StorageException;

        public abstract HashMap<String, String> getMetadata();

        public abstract void setMetadata(HashMap<String, String> var1);

        public abstract void downloadAttributes(OperationContext var1) throws StorageException;

        public abstract void uploadMetadata(OperationContext var1) throws StorageException;

        public abstract void create(OperationContext var1) throws StorageException;

        public abstract CloudBlobDirectoryWrapper getDirectoryReference(String var1) throws URISyntaxException, StorageException;

        public abstract CloudBlobWrapper getBlockBlobReference(String var1) throws URISyntaxException, StorageException;

        public abstract CloudBlobWrapper getPageBlobReference(String var1) throws URISyntaxException, StorageException;
    }

    @InterfaceAudience.Private
    public static abstract class CloudBlobDirectoryWrapper
    implements ListBlobItem {
        public abstract URI getUri();

        public abstract Iterable<ListBlobItem> listBlobs(String var1, boolean var2, EnumSet<BlobListingDetails> var3, BlobRequestOptions var4, OperationContext var5) throws URISyntaxException, StorageException;
    }
}

