/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public final class EncodingHelper {
    private EncodingHelper() {
    }

    public static byte[] getSHA256Hash(byte[] key) {
        try {
            MessageDigest digester = MessageDigest.getInstance("SHA-256");
            return digester.digest(key);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("SHA-256 algorithm not found in MessageDigest", noSuchAlgorithmException);
        }
    }

    public static String getBase64EncodedString(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }
}

