/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.net.URI;
import java.util.EnumSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class HdfsLocatedFileStatus
extends HdfsFileStatus {
    private static final long serialVersionUID = 600257320L;
    private transient LocatedBlocks locations;

    public HdfsLocatedFileStatus(long length, boolean isdir, int block_replication, long blocksize, long modification_time, long access_time, FsPermission permission, EnumSet<HdfsFileStatus.Flags> flags, String owner, String group, byte[] symlink, byte[] path, long fileId, LocatedBlocks locations, int childrenNum, FileEncryptionInfo feInfo, byte storagePolicy, ErasureCodingPolicy ecPolicy) {
        super(length, isdir, block_replication, blocksize, modification_time, access_time, permission, flags, owner, group, symlink, path, fileId, childrenNum, feInfo, storagePolicy, ecPolicy);
        this.locations = locations;
    }

    public LocatedBlocks getBlockLocations() {
        return this.locations;
    }

    public final LocatedFileStatus makeQualifiedLocated(URI defaultUri, Path path) {
        this.makeQualified(defaultUri, path);
        return new LocatedFileStatus(this, DFSUtilClient.locatedBlocks2Locations(this.getBlockLocations()));
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

