/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.crypto.key.KeyProviderFactory;
import org.apache.hadoop.crypto.key.kms.KMSClientProvider;
import org.apache.hadoop.shaded.org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class KMSUtil {
    public static final Logger LOG = LoggerFactory.getLogger(KMSUtil.class);

    private KMSUtil() {
    }

    public static KeyProvider createKeyProvider(Configuration conf, String configKeyName) throws IOException {
        LOG.debug("Creating key provider with config key {}", (Object)configKeyName);
        String providerUriStr = conf.getTrimmed(configKeyName);
        if (providerUriStr == null || providerUriStr.isEmpty()) {
            return null;
        }
        return KMSUtil.createKeyProviderFromUri(conf, URI.create(providerUriStr));
    }

    public static KeyProvider createKeyProviderFromUri(Configuration conf, URI providerUri) throws IOException {
        KeyProvider keyProvider = KeyProviderFactory.get(providerUri, conf);
        if (keyProvider == null) {
            throw new IOException("Could not instantiate KeyProvider for uri: " + providerUri);
        }
        if (keyProvider.isTransient()) {
            throw new IOException("KeyProvider " + keyProvider.toString() + " was found but it is a transient provider.");
        }
        return keyProvider;
    }

    public static Map toJSON(KeyProvider.KeyVersion keyVersion) {
        HashMap<String, String> json = new HashMap<String, String>();
        if (keyVersion != null) {
            json.put("name", keyVersion.getName());
            json.put("versionName", keyVersion.getVersionName());
            json.put("material", Base64.encodeBase64URLSafeString((byte[])keyVersion.getMaterial()));
        }
        return json;
    }

    public static Map toJSON(KeyProviderCryptoExtension.EncryptedKeyVersion encryptedKeyVersion) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        if (encryptedKeyVersion != null) {
            json.put("versionName", encryptedKeyVersion.getEncryptionKeyVersionName());
            json.put("iv", Base64.encodeBase64URLSafeString((byte[])encryptedKeyVersion.getEncryptedKeyIv()));
            json.put("encryptedKeyVersion", KMSUtil.toJSON(encryptedKeyVersion.getEncryptedKeyVersion()));
        }
        return json;
    }

    public static <T> T checkNotNull(T o, String name) throws IllegalArgumentException {
        if (o == null) {
            throw new IllegalArgumentException("Parameter '" + name + "' cannot be null");
        }
        return o;
    }

    public static String checkNotEmpty(String s, String name) throws IllegalArgumentException {
        KMSUtil.checkNotNull(s, name);
        if (s.isEmpty()) {
            throw new IllegalArgumentException("Parameter '" + name + "' cannot be empty");
        }
        return s;
    }

    public static List<KeyProviderCryptoExtension.EncryptedKeyVersion> parseJSONEncKeyVersions(String keyName, List valueList) {
        KMSUtil.checkNotNull(valueList, "valueList");
        ArrayList<KeyProviderCryptoExtension.EncryptedKeyVersion> ekvs = new ArrayList<KeyProviderCryptoExtension.EncryptedKeyVersion>(valueList.size());
        if (!valueList.isEmpty()) {
            for (Object values : valueList) {
                Map valueMap = (Map)values;
                ekvs.add(KMSUtil.parseJSONEncKeyVersion(keyName, valueMap));
            }
        }
        return ekvs;
    }

    public static KeyProviderCryptoExtension.EncryptedKeyVersion parseJSONEncKeyVersion(String keyName, Map valueMap) {
        KMSUtil.checkNotNull(valueMap, "valueMap");
        String versionName = KMSUtil.checkNotNull((String)valueMap.get("versionName"), "versionName");
        byte[] iv = Base64.decodeBase64((String)KMSUtil.checkNotNull((String)valueMap.get("iv"), "iv"));
        Map encValueMap = KMSUtil.checkNotNull((Map)valueMap.get("encryptedKeyVersion"), "encryptedKeyVersion");
        String encVersionName = KMSUtil.checkNotNull((String)encValueMap.get("versionName"), "versionName");
        byte[] encKeyMaterial = Base64.decodeBase64((String)KMSUtil.checkNotNull((String)encValueMap.get("material"), "material"));
        return new KMSClientProvider.KMSEncryptedKeyVersion(keyName, versionName, iv, encVersionName, encKeyMaterial);
    }

    public static KeyProvider.KeyVersion parseJSONKeyVersion(Map valueMap) {
        KMSUtil.checkNotNull(valueMap, "valueMap");
        KMSClientProvider.KMSKeyVersion keyVersion = null;
        if (!valueMap.isEmpty()) {
            byte[] material = valueMap.containsKey("material") ? Base64.decodeBase64((String)((String)valueMap.get("material"))) : null;
            String versionName = (String)valueMap.get("versionName");
            String keyName = (String)valueMap.get("name");
            keyVersion = new KMSClientProvider.KMSKeyVersion(keyName, versionName, material);
        }
        return keyVersion;
    }

    public static KeyProvider.Metadata parseJSONMetadata(Map valueMap) {
        KMSUtil.checkNotNull(valueMap, "valueMap");
        KMSClientProvider.KMSMetadata metadata = null;
        if (!valueMap.isEmpty()) {
            metadata = new KMSClientProvider.KMSMetadata((String)valueMap.get("cipher"), (Integer)valueMap.get("length"), (String)valueMap.get("description"), (Map)valueMap.get("attributes"), new Date((Long)valueMap.get("created")), (Integer)valueMap.get("versions"));
        }
        return metadata;
    }
}

