/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.shaded.com.google.protobuf.MessageOrBuilder;
import org.apache.hadoop.shaded.com.google.protobuf.TextFormat;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationAttemptIdPBImpl;
import org.apache.hadoop.yarn.proto.YarnSecurityTokenProtos;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AMRMTokenIdentifier
extends TokenIdentifier {
    public static final Text KIND_NAME = new Text("YARN_AM_RM_TOKEN");
    private YarnSecurityTokenProtos.AMRMTokenIdentifierProto proto;

    public AMRMTokenIdentifier() {
    }

    public AMRMTokenIdentifier(ApplicationAttemptId appAttemptId, int masterKeyId) {
        YarnSecurityTokenProtos.AMRMTokenIdentifierProto.Builder builder = YarnSecurityTokenProtos.AMRMTokenIdentifierProto.newBuilder();
        if (appAttemptId != null) {
            builder.setAppAttemptId(((ApplicationAttemptIdPBImpl)appAttemptId).getProto());
        }
        builder.setKeyId(masterKeyId);
        this.proto = builder.build();
    }

    @InterfaceAudience.Private
    public ApplicationAttemptId getApplicationAttemptId() {
        if (!this.proto.hasAppAttemptId()) {
            return null;
        }
        return new ApplicationAttemptIdPBImpl(this.proto.getAppAttemptId());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.write(this.proto.toByteArray());
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.proto = YarnSecurityTokenProtos.AMRMTokenIdentifierProto.parseFrom((DataInputStream)in);
    }

    @Override
    public Text getKind() {
        return KIND_NAME;
    }

    @Override
    public UserGroupInformation getUser() {
        String appAttemptId = null;
        if (this.proto.hasAppAttemptId()) {
            appAttemptId = new ApplicationAttemptIdPBImpl(this.proto.getAppAttemptId()).toString();
        }
        return UserGroupInformation.createRemoteUser(appAttemptId);
    }

    public int getKeyId() {
        return this.proto.getKeyId();
    }

    public YarnSecurityTokenProtos.AMRMTokenIdentifierProto getProto() {
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((AMRMTokenIdentifier)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    @InterfaceAudience.Private
    public static class Renewer
    extends Token.TrivialRenewer {
        @Override
        protected Text getKind() {
            return KIND_NAME;
        }
    }
}

