/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.shaded.com.google.protobuf.MessageOrBuilder;
import org.apache.hadoop.shaded.com.google.protobuf.TextFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ApplicationTimeoutType;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerLaunchContextPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.LogAggregationContextPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.PriorityPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.ReservationIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourceRequestPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ApplicationSubmissionContextPBImpl
extends ApplicationSubmissionContext {
    YarnProtos.ApplicationSubmissionContextProto proto = YarnProtos.ApplicationSubmissionContextProto.getDefaultInstance();
    YarnProtos.ApplicationSubmissionContextProto.Builder builder = null;
    boolean viaProto = false;
    private ApplicationId applicationId = null;
    private Priority priority = null;
    private ContainerLaunchContext amContainer = null;
    private Resource resource = null;
    private Set<String> applicationTags = null;
    private List<ResourceRequest> amResourceRequests = null;
    private LogAggregationContext logAggregationContext = null;
    private ReservationId reservationId = null;
    private Map<ApplicationTimeoutType, Long> applicationTimeouts = null;
    private Map<String, String> schedulingProperties = null;

    public ApplicationSubmissionContextPBImpl() {
        this.builder = YarnProtos.ApplicationSubmissionContextProto.newBuilder();
    }

    public ApplicationSubmissionContextPBImpl(YarnProtos.ApplicationSubmissionContextProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public synchronized YarnProtos.ApplicationSubmissionContextProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((ApplicationSubmissionContextPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    private void mergeLocalToBuilder() {
        if (this.applicationId != null) {
            this.builder.setApplicationId(this.convertToProtoFormat(this.applicationId));
        }
        if (this.priority != null) {
            this.builder.setPriority(this.convertToProtoFormat(this.priority));
        }
        if (this.amContainer != null) {
            this.builder.setAmContainerSpec(this.convertToProtoFormat(this.amContainer));
        }
        if (this.resource != null) {
            this.builder.setResource(this.convertToProtoFormat(this.resource));
        }
        if (this.applicationTags != null && !this.applicationTags.isEmpty()) {
            this.builder.clearApplicationTags();
            this.builder.addAllApplicationTags(this.applicationTags);
        }
        if (this.amResourceRequests != null) {
            this.builder.clearAmContainerResourceRequest();
            this.builder.addAllAmContainerResourceRequest(this.convertToProtoFormat(this.amResourceRequests));
        }
        if (this.logAggregationContext != null) {
            this.builder.setLogAggregationContext(this.convertToProtoFormat(this.logAggregationContext));
        }
        if (this.reservationId != null) {
            this.builder.setReservationId(this.convertToProtoFormat(this.reservationId));
        }
        if (this.applicationTimeouts != null) {
            this.addApplicationTimeouts();
        }
        if (this.schedulingProperties != null) {
            this.addApplicationSchedulingProperties();
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ApplicationSubmissionContextProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public synchronized Priority getPriority() {
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder p;
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder applicationSubmissionContextProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.priority != null) {
            return this.priority;
        }
        if (!p.hasPriority()) {
            return null;
        }
        this.priority = this.convertFromProtoFormat(p.getPriority());
        return this.priority;
    }

    @Override
    public synchronized void setPriority(Priority priority) {
        this.maybeInitBuilder();
        if (priority == null) {
            this.builder.clearPriority();
        }
        this.priority = priority;
    }

    @Override
    public synchronized ApplicationId getApplicationId() {
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder p;
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder applicationSubmissionContextProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.applicationId != null) {
            return this.applicationId;
        }
        if (!p.hasApplicationId()) {
            return null;
        }
        this.applicationId = this.convertFromProtoFormat(p.getApplicationId());
        return this.applicationId;
    }

    @Override
    public synchronized void setApplicationId(ApplicationId applicationId) {
        this.maybeInitBuilder();
        if (applicationId == null) {
            this.builder.clearApplicationId();
        }
        this.applicationId = applicationId;
    }

    @Override
    public synchronized String getApplicationName() {
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder p;
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder applicationSubmissionContextProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasApplicationName()) {
            return null;
        }
        return p.getApplicationName();
    }

    @Override
    public synchronized void setApplicationName(String applicationName) {
        this.maybeInitBuilder();
        if (applicationName == null) {
            this.builder.clearApplicationName();
            return;
        }
        this.builder.setApplicationName(applicationName);
    }

    @Override
    public synchronized String getQueue() {
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder p;
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder applicationSubmissionContextProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasQueue()) {
            return null;
        }
        return p.getQueue();
    }

    @Override
    public synchronized String getApplicationType() {
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder p;
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder applicationSubmissionContextProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasApplicationType()) {
            return null;
        }
        return p.getApplicationType();
    }

    private void initApplicationTags() {
        if (this.applicationTags != null) {
            return;
        }
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        this.applicationTags = new HashSet<String>();
        this.applicationTags.addAll(p.getApplicationTagsList());
    }

    @Override
    public synchronized Set<String> getApplicationTags() {
        this.initApplicationTags();
        return this.applicationTags;
    }

    @Override
    public synchronized void setQueue(String queue) {
        this.maybeInitBuilder();
        if (queue == null) {
            this.builder.clearQueue();
            return;
        }
        this.builder.setQueue(queue);
    }

    @Override
    public synchronized void setApplicationType(String applicationType) {
        this.maybeInitBuilder();
        if (applicationType == null) {
            this.builder.clearApplicationType();
            return;
        }
        this.builder.setApplicationType(applicationType);
    }

    private void checkTags(Set<String> tags) {
        if (tags.size() > 10) {
            throw new IllegalArgumentException("Too many applicationTags, a maximum of only 10 are allowed!");
        }
        for (String tag : tags) {
            if (tag.length() > 100) {
                throw new IllegalArgumentException("Tag " + tag + " is too long, " + "maximum allowed length of a tag is " + 100);
            }
            if (org.apache.hadoop.shaded.org.apache.commons.lang3.StringUtils.isAsciiPrintable((CharSequence)tag)) continue;
            throw new IllegalArgumentException("A tag can only have ASCII characters! Invalid tag - " + tag);
        }
    }

    @Override
    public synchronized void setApplicationTags(Set<String> tags) {
        this.maybeInitBuilder();
        if (tags == null || tags.isEmpty()) {
            this.builder.clearApplicationTags();
            this.applicationTags = null;
            return;
        }
        this.checkTags(tags);
        this.applicationTags = new HashSet<String>();
        for (String tag : tags) {
            this.applicationTags.add(StringUtils.toLowerCase(tag));
        }
    }

    @Override
    public synchronized ContainerLaunchContext getAMContainerSpec() {
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder p;
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder applicationSubmissionContextProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.amContainer != null) {
            return this.amContainer;
        }
        if (!p.hasAmContainerSpec()) {
            return null;
        }
        this.amContainer = this.convertFromProtoFormat(p.getAmContainerSpec());
        return this.amContainer;
    }

    @Override
    public synchronized void setAMContainerSpec(ContainerLaunchContext amContainer) {
        this.maybeInitBuilder();
        if (amContainer == null) {
            this.builder.clearAmContainerSpec();
        }
        this.amContainer = amContainer;
    }

    @Override
    public synchronized boolean getUnmanagedAM() {
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getUnmanagedAm();
    }

    @Override
    public synchronized void setUnmanagedAM(boolean value) {
        this.maybeInitBuilder();
        this.builder.setUnmanagedAm(value);
    }

    @Override
    public synchronized boolean getCancelTokensWhenComplete() {
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getCancelTokensWhenComplete();
    }

    @Override
    public synchronized void setCancelTokensWhenComplete(boolean cancel) {
        this.maybeInitBuilder();
        this.builder.setCancelTokensWhenComplete(cancel);
    }

    @Override
    public synchronized int getMaxAppAttempts() {
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getMaxAppAttempts();
    }

    @Override
    public synchronized void setMaxAppAttempts(int maxAppAttempts) {
        this.maybeInitBuilder();
        this.builder.setMaxAppAttempts(maxAppAttempts);
    }

    @Override
    public synchronized Resource getResource() {
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder p;
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder applicationSubmissionContextProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.resource != null) {
            return this.resource;
        }
        if (!p.hasResource()) {
            return null;
        }
        this.resource = this.convertFromProtoFormat(p.getResource());
        return this.resource;
    }

    @Override
    public synchronized void setResource(Resource resource) {
        this.maybeInitBuilder();
        if (resource == null) {
            this.builder.clearResource();
        }
        this.resource = resource;
    }

    @Override
    public synchronized ReservationId getReservationID() {
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder p;
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder applicationSubmissionContextProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.reservationId != null) {
            return this.reservationId;
        }
        if (!p.hasReservationId()) {
            return null;
        }
        this.reservationId = this.convertFromProtoFormat(p.getReservationId());
        return this.reservationId;
    }

    @Override
    public synchronized void setReservationID(ReservationId reservationID) {
        this.maybeInitBuilder();
        if (reservationID == null) {
            this.builder.clearReservationId();
            return;
        }
        this.reservationId = reservationID;
    }

    @Override
    public synchronized void setKeepContainersAcrossApplicationAttempts(boolean keepContainers) {
        this.maybeInitBuilder();
        this.builder.setKeepContainersAcrossApplicationAttempts(keepContainers);
    }

    @Override
    public synchronized boolean getKeepContainersAcrossApplicationAttempts() {
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getKeepContainersAcrossApplicationAttempts();
    }

    private PriorityPBImpl convertFromProtoFormat(YarnProtos.PriorityProto p) {
        return new PriorityPBImpl(p);
    }

    private YarnProtos.PriorityProto convertToProtoFormat(Priority t) {
        return ((PriorityPBImpl)t).getProto();
    }

    private List<ResourceRequest> convertFromProtoFormat(List<YarnProtos.ResourceRequestProto> ps) {
        ArrayList<ResourceRequest> rs = new ArrayList<ResourceRequest>();
        for (YarnProtos.ResourceRequestProto p : ps) {
            rs.add(new ResourceRequestPBImpl(p));
        }
        return rs;
    }

    private List<YarnProtos.ResourceRequestProto> convertToProtoFormat(List<ResourceRequest> ts) {
        ArrayList<YarnProtos.ResourceRequestProto> rs = new ArrayList<YarnProtos.ResourceRequestProto>(ts.size());
        for (ResourceRequest t : ts) {
            rs.add(((ResourceRequestPBImpl)t).getProto());
        }
        return rs;
    }

    private ApplicationIdPBImpl convertFromProtoFormat(YarnProtos.ApplicationIdProto p) {
        return new ApplicationIdPBImpl(p);
    }

    private YarnProtos.ApplicationIdProto convertToProtoFormat(ApplicationId t) {
        return ((ApplicationIdPBImpl)t).getProto();
    }

    private ContainerLaunchContextPBImpl convertFromProtoFormat(YarnProtos.ContainerLaunchContextProto p) {
        return new ContainerLaunchContextPBImpl(p);
    }

    private YarnProtos.ContainerLaunchContextProto convertToProtoFormat(ContainerLaunchContext t) {
        return ((ContainerLaunchContextPBImpl)t).getProto();
    }

    private ResourcePBImpl convertFromProtoFormat(YarnProtos.ResourceProto p) {
        return new ResourcePBImpl(p);
    }

    private YarnProtos.ResourceProto convertToProtoFormat(Resource t) {
        return ProtoUtils.convertToProtoFormat(t);
    }

    @Override
    public synchronized String getNodeLabelExpression() {
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder p;
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder applicationSubmissionContextProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasNodeLabelExpression()) {
            return null;
        }
        return p.getNodeLabelExpression();
    }

    @Override
    public synchronized void setNodeLabelExpression(String labelExpression) {
        this.maybeInitBuilder();
        if (labelExpression == null) {
            this.builder.clearNodeLabelExpression();
            return;
        }
        this.builder.setNodeLabelExpression(labelExpression);
    }

    @Override
    @Deprecated
    public synchronized ResourceRequest getAMContainerResourceRequest() {
        List<ResourceRequest> reqs = this.getAMContainerResourceRequests();
        if (reqs == null || reqs.isEmpty()) {
            return null;
        }
        return this.getAMContainerResourceRequests().get(0);
    }

    @Override
    public synchronized List<ResourceRequest> getAMContainerResourceRequests() {
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder p;
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder applicationSubmissionContextProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.amResourceRequests != null) {
            return this.amResourceRequests;
        }
        if (p.getAmContainerResourceRequestCount() == 0) {
            return null;
        }
        this.amResourceRequests = this.convertFromProtoFormat(p.getAmContainerResourceRequestList());
        return this.amResourceRequests;
    }

    @Override
    @Deprecated
    public synchronized void setAMContainerResourceRequest(ResourceRequest request) {
        this.maybeInitBuilder();
        if (request == null) {
            this.builder.clearAmContainerResourceRequest();
        }
        this.amResourceRequests = Collections.singletonList(request);
    }

    @Override
    public synchronized void setAMContainerResourceRequests(List<ResourceRequest> requests) {
        this.maybeInitBuilder();
        if (requests == null) {
            this.builder.clearAmContainerResourceRequest();
        }
        this.amResourceRequests = requests;
    }

    @Override
    public synchronized long getAttemptFailuresValidityInterval() {
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getAttemptFailuresValidityInterval();
    }

    @Override
    public synchronized void setAttemptFailuresValidityInterval(long attemptFailuresValidityInterval) {
        this.maybeInitBuilder();
        this.builder.setAttemptFailuresValidityInterval(attemptFailuresValidityInterval);
    }

    private LogAggregationContextPBImpl convertFromProtoFormat(YarnProtos.LogAggregationContextProto p) {
        return new LogAggregationContextPBImpl(p);
    }

    private YarnProtos.LogAggregationContextProto convertToProtoFormat(LogAggregationContext t) {
        return ((LogAggregationContextPBImpl)t).getProto();
    }

    @Override
    public synchronized LogAggregationContext getLogAggregationContext() {
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder p;
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder applicationSubmissionContextProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.logAggregationContext != null) {
            return this.logAggregationContext;
        }
        if (!p.hasLogAggregationContext()) {
            return null;
        }
        this.logAggregationContext = this.convertFromProtoFormat(p.getLogAggregationContext());
        return this.logAggregationContext;
    }

    @Override
    public synchronized void setLogAggregationContext(LogAggregationContext logAggregationContext) {
        this.maybeInitBuilder();
        if (logAggregationContext == null) {
            this.builder.clearLogAggregationContext();
        }
        this.logAggregationContext = logAggregationContext;
    }

    private ReservationIdPBImpl convertFromProtoFormat(YarnProtos.ReservationIdProto p) {
        return new ReservationIdPBImpl(p);
    }

    private YarnProtos.ReservationIdProto convertToProtoFormat(ReservationId t) {
        return ((ReservationIdPBImpl)t).getProto();
    }

    @Override
    public synchronized Map<ApplicationTimeoutType, Long> getApplicationTimeouts() {
        this.initApplicationTimeout();
        return this.applicationTimeouts;
    }

    private void initApplicationTimeout() {
        if (this.applicationTimeouts != null) {
            return;
        }
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.ApplicationTimeoutMapProto> lists = p.getApplicationTimeoutsList();
        this.applicationTimeouts = new HashMap<ApplicationTimeoutType, Long>(lists.size());
        for (YarnProtos.ApplicationTimeoutMapProto timeoutProto : lists) {
            this.applicationTimeouts.put(ProtoUtils.convertFromProtoFormat(timeoutProto.getApplicationTimeoutType()), timeoutProto.getTimeout());
        }
    }

    @Override
    public synchronized void setApplicationTimeouts(Map<ApplicationTimeoutType, Long> appTimeouts) {
        if (appTimeouts == null) {
            return;
        }
        this.initApplicationTimeout();
        this.applicationTimeouts.clear();
        this.applicationTimeouts.putAll(appTimeouts);
    }

    private void addApplicationTimeouts() {
        this.maybeInitBuilder();
        this.builder.clearApplicationTimeouts();
        if (this.applicationTimeouts == null) {
            return;
        }
        Iterable<YarnProtos.ApplicationTimeoutMapProto> values = new Iterable<YarnProtos.ApplicationTimeoutMapProto>(){

            @Override
            public Iterator<YarnProtos.ApplicationTimeoutMapProto> iterator() {
                return new Iterator<YarnProtos.ApplicationTimeoutMapProto>(){
                    private Iterator<ApplicationTimeoutType> iterator;
                    {
                        this.iterator = ApplicationSubmissionContextPBImpl.this.applicationTimeouts.keySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public YarnProtos.ApplicationTimeoutMapProto next() {
                        ApplicationTimeoutType key = this.iterator.next();
                        return YarnProtos.ApplicationTimeoutMapProto.newBuilder().setTimeout((Long)ApplicationSubmissionContextPBImpl.this.applicationTimeouts.get((Object)key)).setApplicationTimeoutType(ProtoUtils.convertToProtoFormat(key)).build();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllApplicationTimeouts((Iterable<? extends YarnProtos.ApplicationTimeoutMapProto>)values);
    }

    private void addApplicationSchedulingProperties() {
        this.maybeInitBuilder();
        this.builder.clearApplicationSchedulingProperties();
        if (this.schedulingProperties == null) {
            return;
        }
        Iterable<YarnProtos.StringStringMapProto> values = new Iterable<YarnProtos.StringStringMapProto>(){

            @Override
            public Iterator<YarnProtos.StringStringMapProto> iterator() {
                return new Iterator<YarnProtos.StringStringMapProto>(){
                    private Iterator<String> iterator;
                    {
                        this.iterator = ApplicationSubmissionContextPBImpl.this.schedulingProperties.keySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public YarnProtos.StringStringMapProto next() {
                        String key = this.iterator.next();
                        return YarnProtos.StringStringMapProto.newBuilder().setValue((String)ApplicationSubmissionContextPBImpl.this.schedulingProperties.get(key)).setKey(key).build();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllApplicationSchedulingProperties((Iterable<? extends YarnProtos.StringStringMapProto>)values);
    }

    private void initApplicationSchedulingProperties() {
        if (this.schedulingProperties != null) {
            return;
        }
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.StringStringMapProto> properties = p.getApplicationSchedulingPropertiesList();
        this.schedulingProperties = new HashMap<String, String>(properties.size());
        for (YarnProtos.StringStringMapProto envProto : properties) {
            this.schedulingProperties.put(envProto.getKey(), envProto.getValue());
        }
    }

    @Override
    public synchronized Map<String, String> getApplicationSchedulingPropertiesMap() {
        this.initApplicationSchedulingProperties();
        return this.schedulingProperties;
    }

    @Override
    public synchronized void setApplicationSchedulingPropertiesMap(Map<String, String> schedulingPropertyMap) {
        if (schedulingPropertyMap == null) {
            return;
        }
        this.initApplicationSchedulingProperties();
        this.schedulingProperties.clear();
        this.schedulingProperties.putAll(schedulingPropertyMap);
    }
}

