/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.shaded.com.google.protobuf.ByteString;
import org.apache.hadoop.yarn.api.protocolrecords.ApplicationsRequestScope;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceTypes;
import org.apache.hadoop.yarn.api.records.AMCommand;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ApplicationTimeoutType;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerRetryPolicy;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerSubState;
import org.apache.hadoop.yarn.api.records.ContainerUpdateType;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.LogAggregationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.NodeUpdateType;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.RejectionReason;
import org.apache.hadoop.yarn.api.records.ReservationRequestInterpreter;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.UpdateContainerError;
import org.apache.hadoop.yarn.api.records.UpdateContainerRequest;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationResourceUsageReportPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerStatusPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ExecutionTypeRequestPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.UpdateContainerErrorPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.UpdateContainerRequestPBImpl;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.apache.hadoop.yarn.server.api.ContainerType;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ProtoUtils {
    private static final String CONTAINER_STATE_PREFIX = "C_";
    private static final String CONTAINER_SUB_STATE_PREFIX = "CSS_";
    private static final String NODE_STATE_PREFIX = "NS_";
    private static String YARN_APPLICATION_ATTEMPT_STATE_PREFIX = "APP_ATTEMPT_";
    private static String FINAL_APPLICATION_STATUS_PREFIX = "APP_";
    private static final String REJECTION_REASON_PREFIX = "RRP_";
    private static String QUEUE_STATE_PREFIX = "Q_";
    private static String QUEUE_ACL_PREFIX = "QACL_";
    private static String APP_ACCESS_TYPE_PREFIX = "APPACCESS_";
    private static String APP_TIMEOUT_TYPE_PREFIX = "APP_TIMEOUT_";
    private static final String LOG_AGGREGATION_STATUS_PREFIX = "LOG_";
    private static final int LOG_AGGREGATION_STATUS_PREFIX_LEN = "LOG_".length();

    public static YarnProtos.ContainerStateProto convertToProtoFormat(ContainerState e) {
        return YarnProtos.ContainerStateProto.valueOf(CONTAINER_STATE_PREFIX + e.name());
    }

    public static ContainerState convertFromProtoFormat(YarnProtos.ContainerStateProto e) {
        return ContainerState.valueOf(e.name().replace(CONTAINER_STATE_PREFIX, ""));
    }

    public static YarnProtos.ContainerSubStateProto convertToProtoFormat(ContainerSubState e) {
        return YarnProtos.ContainerSubStateProto.valueOf(CONTAINER_SUB_STATE_PREFIX + e.name());
    }

    public static ContainerSubState convertFromProtoFormat(YarnProtos.ContainerSubStateProto e) {
        return ContainerSubState.valueOf(e.name().substring(CONTAINER_SUB_STATE_PREFIX.length()));
    }

    public static YarnProtos.NodeStateProto convertToProtoFormat(NodeState e) {
        return YarnProtos.NodeStateProto.valueOf(NODE_STATE_PREFIX + e.name());
    }

    public static NodeState convertFromProtoFormat(YarnProtos.NodeStateProto e) {
        return NodeState.valueOf(e.name().replace(NODE_STATE_PREFIX, ""));
    }

    public static YarnProtos.NodeIdProto convertToProtoFormat(NodeId e) {
        return ((NodeIdPBImpl)e).getProto();
    }

    public static NodeId convertFromProtoFormat(YarnProtos.NodeIdProto e) {
        return new NodeIdPBImpl(e);
    }

    public static YarnProtos.YarnApplicationStateProto convertToProtoFormat(YarnApplicationState e) {
        return YarnProtos.YarnApplicationStateProto.valueOf(e.name());
    }

    public static YarnApplicationState convertFromProtoFormat(YarnProtos.YarnApplicationStateProto e) {
        return YarnApplicationState.valueOf(e.name());
    }

    public static YarnProtos.YarnApplicationAttemptStateProto convertToProtoFormat(YarnApplicationAttemptState e) {
        return YarnProtos.YarnApplicationAttemptStateProto.valueOf(YARN_APPLICATION_ATTEMPT_STATE_PREFIX + e.name());
    }

    public static YarnApplicationAttemptState convertFromProtoFormat(YarnProtos.YarnApplicationAttemptStateProto e) {
        return YarnApplicationAttemptState.valueOf(e.name().replace(YARN_APPLICATION_ATTEMPT_STATE_PREFIX, ""));
    }

    public static YarnServiceProtos.ApplicationsRequestScopeProto convertToProtoFormat(ApplicationsRequestScope e) {
        return YarnServiceProtos.ApplicationsRequestScopeProto.valueOf(e.name());
    }

    public static ApplicationsRequestScope convertFromProtoFormat(YarnServiceProtos.ApplicationsRequestScopeProto e) {
        return ApplicationsRequestScope.valueOf(e.name());
    }

    public static YarnProtos.ApplicationResourceUsageReportProto convertToProtoFormat(ApplicationResourceUsageReport e) {
        return ((ApplicationResourceUsageReportPBImpl)e).getProto();
    }

    public static ApplicationResourceUsageReport convertFromProtoFormat(YarnProtos.ApplicationResourceUsageReportProto e) {
        return new ApplicationResourceUsageReportPBImpl(e);
    }

    public static YarnProtos.FinalApplicationStatusProto convertToProtoFormat(FinalApplicationStatus e) {
        return YarnProtos.FinalApplicationStatusProto.valueOf(FINAL_APPLICATION_STATUS_PREFIX + e.name());
    }

    public static FinalApplicationStatus convertFromProtoFormat(YarnProtos.FinalApplicationStatusProto e) {
        return FinalApplicationStatus.valueOf(e.name().replace(FINAL_APPLICATION_STATUS_PREFIX, ""));
    }

    public static YarnProtos.LocalResourceTypeProto convertToProtoFormat(LocalResourceType e) {
        return YarnProtos.LocalResourceTypeProto.valueOf(e.name());
    }

    public static LocalResourceType convertFromProtoFormat(YarnProtos.LocalResourceTypeProto e) {
        return LocalResourceType.valueOf(e.name());
    }

    public static YarnProtos.LocalResourceVisibilityProto convertToProtoFormat(LocalResourceVisibility e) {
        return YarnProtos.LocalResourceVisibilityProto.valueOf(e.name());
    }

    public static LocalResourceVisibility convertFromProtoFormat(YarnProtos.LocalResourceVisibilityProto e) {
        return LocalResourceVisibility.valueOf(e.name());
    }

    public static YarnProtos.AMCommandProto convertToProtoFormat(AMCommand e) {
        return YarnProtos.AMCommandProto.valueOf(e.name());
    }

    public static AMCommand convertFromProtoFormat(YarnProtos.AMCommandProto e) {
        return AMCommand.valueOf(e.name());
    }

    public static YarnProtos.RejectionReasonProto convertToProtoFormat(RejectionReason e) {
        return YarnProtos.RejectionReasonProto.valueOf(REJECTION_REASON_PREFIX + e.name());
    }

    public static RejectionReason convertFromProtoFormat(YarnProtos.RejectionReasonProto e) {
        return RejectionReason.valueOf(e.name().replace(REJECTION_REASON_PREFIX, ""));
    }

    public static ByteBuffer convertFromProtoFormat(ByteString byteString) {
        int capacity = byteString.asReadOnlyByteBuffer().rewind().remaining();
        byte[] b = new byte[capacity];
        byteString.asReadOnlyByteBuffer().get(b, 0, capacity);
        return ByteBuffer.wrap(b);
    }

    public static ByteString convertToProtoFormat(ByteBuffer byteBuffer) {
        int oldPos = byteBuffer.position();
        byteBuffer.rewind();
        ByteString bs = ByteString.copyFrom((ByteBuffer)byteBuffer);
        byteBuffer.position(oldPos);
        return bs;
    }

    public static YarnProtos.QueueStateProto convertToProtoFormat(QueueState e) {
        return YarnProtos.QueueStateProto.valueOf(QUEUE_STATE_PREFIX + e.name());
    }

    public static QueueState convertFromProtoFormat(YarnProtos.QueueStateProto e) {
        return QueueState.valueOf(e.name().replace(QUEUE_STATE_PREFIX, ""));
    }

    public static YarnProtos.QueueACLProto convertToProtoFormat(QueueACL e) {
        return YarnProtos.QueueACLProto.valueOf(QUEUE_ACL_PREFIX + e.name());
    }

    public static QueueACL convertFromProtoFormat(YarnProtos.QueueACLProto e) {
        return QueueACL.valueOf(e.name().replace(QUEUE_ACL_PREFIX, ""));
    }

    public static YarnProtos.ApplicationAccessTypeProto convertToProtoFormat(ApplicationAccessType e) {
        return YarnProtos.ApplicationAccessTypeProto.valueOf(APP_ACCESS_TYPE_PREFIX + e.name());
    }

    public static ApplicationAccessType convertFromProtoFormat(YarnProtos.ApplicationAccessTypeProto e) {
        return ApplicationAccessType.valueOf(e.name().replace(APP_ACCESS_TYPE_PREFIX, ""));
    }

    public static YarnProtos.ApplicationTimeoutTypeProto convertToProtoFormat(ApplicationTimeoutType e) {
        return YarnProtos.ApplicationTimeoutTypeProto.valueOf(APP_TIMEOUT_TYPE_PREFIX + e.name());
    }

    public static ApplicationTimeoutType convertFromProtoFormat(YarnProtos.ApplicationTimeoutTypeProto e) {
        return ApplicationTimeoutType.valueOf(e.name().replace(APP_TIMEOUT_TYPE_PREFIX, ""));
    }

    public static YarnProtos.ReservationRequestInterpreterProto convertToProtoFormat(ReservationRequestInterpreter e) {
        return YarnProtos.ReservationRequestInterpreterProto.valueOf(e.name());
    }

    public static ReservationRequestInterpreter convertFromProtoFormat(YarnProtos.ReservationRequestInterpreterProto e) {
        return ReservationRequestInterpreter.valueOf(e.name());
    }

    public static YarnProtos.LogAggregationStatusProto convertToProtoFormat(LogAggregationStatus e) {
        return YarnProtos.LogAggregationStatusProto.valueOf(LOG_AGGREGATION_STATUS_PREFIX + e.name());
    }

    public static LogAggregationStatus convertFromProtoFormat(YarnProtos.LogAggregationStatusProto e) {
        return LogAggregationStatus.valueOf(e.name().substring(LOG_AGGREGATION_STATUS_PREFIX_LEN));
    }

    public static YarnProtos.ContainerTypeProto convertToProtoFormat(ContainerType e) {
        return YarnProtos.ContainerTypeProto.valueOf(e.name());
    }

    public static ContainerType convertFromProtoFormat(YarnProtos.ContainerTypeProto e) {
        return ContainerType.valueOf(e.name());
    }

    public static YarnProtos.NodeUpdateTypeProto convertToProtoFormat(NodeUpdateType e) {
        return YarnProtos.NodeUpdateTypeProto.valueOf(e.name());
    }

    public static NodeUpdateType convertFromProtoFormat(YarnProtos.NodeUpdateTypeProto e) {
        return NodeUpdateType.valueOf(e.name());
    }

    public static YarnProtos.ExecutionTypeProto convertToProtoFormat(ExecutionType e) {
        return YarnProtos.ExecutionTypeProto.valueOf(e.name());
    }

    public static ExecutionType convertFromProtoFormat(YarnProtos.ExecutionTypeProto e) {
        return ExecutionType.valueOf(e.name());
    }

    public static YarnServiceProtos.ContainerUpdateTypeProto convertToProtoFormat(ContainerUpdateType e) {
        return YarnServiceProtos.ContainerUpdateTypeProto.valueOf(e.name());
    }

    public static ContainerUpdateType convertFromProtoFormat(YarnServiceProtos.ContainerUpdateTypeProto e) {
        return ContainerUpdateType.valueOf(e.name());
    }

    public static synchronized YarnProtos.ResourceProto convertToProtoFormat(Resource r) {
        return ResourcePBImpl.getProto(r);
    }

    public static Resource convertFromProtoFormat(YarnProtos.ResourceProto resource) {
        return new ResourcePBImpl(resource);
    }

    public static YarnProtos.ContainerRetryPolicyProto convertToProtoFormat(ContainerRetryPolicy e) {
        return YarnProtos.ContainerRetryPolicyProto.valueOf(e.name());
    }

    public static ContainerRetryPolicy convertFromProtoFormat(YarnProtos.ContainerRetryPolicyProto e) {
        return ContainerRetryPolicy.valueOf(e.name());
    }

    public static YarnProtos.ExecutionTypeRequestProto convertToProtoFormat(ExecutionTypeRequest e) {
        return ((ExecutionTypeRequestPBImpl)e).getProto();
    }

    public static ExecutionTypeRequest convertFromProtoFormat(YarnProtos.ExecutionTypeRequestProto e) {
        return new ExecutionTypeRequestPBImpl(e);
    }

    public static YarnProtos.ContainerProto convertToProtoFormat(Container t) {
        return ((ContainerPBImpl)t).getProto();
    }

    public static ContainerPBImpl convertFromProtoFormat(YarnProtos.ContainerProto t) {
        return new ContainerPBImpl(t);
    }

    public static ContainerStatusPBImpl convertFromProtoFormat(YarnProtos.ContainerStatusProto p) {
        return new ContainerStatusPBImpl(p);
    }

    public static ContainerIdPBImpl convertFromProtoFormat(YarnProtos.ContainerIdProto p) {
        return new ContainerIdPBImpl(p);
    }

    public static YarnProtos.ContainerIdProto convertToProtoFormat(ContainerId t) {
        return ((ContainerIdPBImpl)t).getProto();
    }

    public static UpdateContainerRequestPBImpl convertFromProtoFormat(YarnServiceProtos.UpdateContainerRequestProto p) {
        return new UpdateContainerRequestPBImpl(p);
    }

    public static YarnServiceProtos.UpdateContainerRequestProto convertToProtoFormat(UpdateContainerRequest t) {
        return ((UpdateContainerRequestPBImpl)t).getProto();
    }

    public static UpdateContainerErrorPBImpl convertFromProtoFormat(YarnServiceProtos.UpdateContainerErrorProto p) {
        return new UpdateContainerErrorPBImpl(p);
    }

    public static YarnServiceProtos.UpdateContainerErrorProto convertToProtoFormat(UpdateContainerError t) {
        return ((UpdateContainerErrorPBImpl)t).getProto();
    }

    public static YarnProtos.ResourceTypesProto converToProtoFormat(ResourceTypes e) {
        return YarnProtos.ResourceTypesProto.valueOf(e.name());
    }

    public static ResourceTypes convertFromProtoFormat(YarnProtos.ResourceTypesProto e) {
        return ResourceTypes.valueOf(e.name());
    }

    public static Map<String, Long> convertStringLongMapProtoListToMap(List<YarnProtos.StringLongMapProto> pList) {
        Resource tmp = Resource.newInstance(0, 0);
        HashMap<String, Long> ret = new HashMap<String, Long>();
        for (ResourceInformation entry : tmp.getResources()) {
            ret.put(entry.getName(), 0L);
        }
        if (pList != null) {
            for (YarnProtos.StringLongMapProto p : pList) {
                ret.put(p.getKey(), p.getValue());
            }
        }
        return ret;
    }

    public static List<YarnProtos.StringLongMapProto> convertMapToStringLongMapProtoList(Map<String, Long> map) {
        ArrayList<YarnProtos.StringLongMapProto> ret = new ArrayList<YarnProtos.StringLongMapProto>();
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            YarnProtos.StringLongMapProto.Builder tmp = YarnProtos.StringLongMapProto.newBuilder();
            tmp.setKey(entry.getKey());
            tmp.setValue(entry.getValue());
            ret.add(tmp.build());
        }
        return ret;
    }

    public static YarnProtos.PlacementConstraintTargetProto.TargetType convertToProtoFormat(PlacementConstraint.TargetExpression.TargetType t) {
        return YarnProtos.PlacementConstraintTargetProto.TargetType.valueOf(t.name());
    }

    public static PlacementConstraint.TargetExpression.TargetType convertFromProtoFormat(YarnProtos.PlacementConstraintTargetProto.TargetType t) {
        return PlacementConstraint.TargetExpression.TargetType.valueOf(t.name());
    }

    public static YarnProtos.TimedPlacementConstraintProto.DelayUnit convertToProtoFormat(PlacementConstraint.TimedPlacementConstraint.DelayUnit u) {
        return YarnProtos.TimedPlacementConstraintProto.DelayUnit.valueOf(u.name());
    }

    public static PlacementConstraint.TimedPlacementConstraint.DelayUnit convertFromProtoFormat(YarnProtos.TimedPlacementConstraintProto.DelayUnit u) {
        return PlacementConstraint.TimedPlacementConstraint.DelayUnit.valueOf(u.name());
    }
}

