/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.fs.StorageStatistics;

public class DFSOpsCountStatistics
extends StorageStatistics {
    public static final String NAME = "DFSOpsCountStatistics";
    private final Map<OpType, AtomicLong> opsCount = new EnumMap<OpType, AtomicLong>(OpType.class);

    public DFSOpsCountStatistics() {
        super(NAME);
        for (OpType opType : OpType.values()) {
            this.opsCount.put(opType, new AtomicLong(0L));
        }
    }

    public void incrementOpCounter(OpType op) {
        this.opsCount.get((Object)op).addAndGet(1L);
    }

    @Override
    public String getScheme() {
        return "hdfs";
    }

    @Override
    public Iterator<StorageStatistics.LongStatistic> getLongStatistics() {
        return new LongIterator();
    }

    @Override
    public Long getLong(String key) {
        OpType type = OpType.fromSymbol(key);
        return type == null ? null : Long.valueOf(this.opsCount.get((Object)type).get());
    }

    @Override
    public boolean isTracked(String key) {
        return OpType.fromSymbol(key) != null;
    }

    @Override
    public void reset() {
        for (AtomicLong count : this.opsCount.values()) {
            count.set(0L);
        }
    }

    private class LongIterator
    implements Iterator<StorageStatistics.LongStatistic> {
        private Iterator<Map.Entry<OpType, AtomicLong>> iterator;

        private LongIterator() {
            this.iterator = DFSOpsCountStatistics.this.opsCount.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public StorageStatistics.LongStatistic next() {
            if (!this.iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            Map.Entry<OpType, AtomicLong> entry = this.iterator.next();
            return new StorageStatistics.LongStatistic(entry.getKey().getSymbol(), entry.getValue().get());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static enum OpType {
        ADD_CACHE_DIRECTIVE("op_add_cache_directive"),
        ADD_CACHE_POOL("op_add_cache_pool"),
        ADD_EC_POLICY("op_add_ec_policy"),
        ALLOW_SNAPSHOT("op_allow_snapshot"),
        APPEND("op_append"),
        CONCAT("op_concat"),
        COPY_FROM_LOCAL_FILE("op_copy_from_local_file"),
        CREATE("op_create"),
        CREATE_ENCRYPTION_ZONE("op_create_encryption_zone"),
        CREATE_NON_RECURSIVE("op_create_non_recursive"),
        CREATE_SNAPSHOT("op_create_snapshot"),
        CREATE_SYM_LINK("op_create_symlink"),
        DELETE("op_delete"),
        DELETE_SNAPSHOT("op_delete_snapshot"),
        DISABLE_EC_POLICY("op_disable_ec_policy"),
        DISALLOW_SNAPSHOT("op_disallow_snapshot"),
        ENABLE_EC_POLICY("op_enable_ec_policy"),
        EXISTS("op_exists"),
        GET_BYTES_WITH_FUTURE_GS("op_get_bytes_with_future_generation_stamps"),
        GET_CONTENT_SUMMARY("op_get_content_summary"),
        GET_EC_CODECS("op_get_ec_codecs"),
        GET_EC_POLICY("op_get_ec_policy"),
        GET_EC_POLICIES("op_get_ec_policies"),
        GET_ENCRYPTION_ZONE("op_get_encryption_zone"),
        GET_FILE_BLOCK_LOCATIONS("op_get_file_block_locations"),
        GET_FILE_CHECKSUM("op_get_file_checksum"),
        GET_FILE_LINK_STATUS("op_get_file_link_status"),
        GET_FILE_STATUS("op_get_file_status"),
        GET_LINK_TARGET("op_get_link_target"),
        GET_QUOTA_USAGE("op_get_quota_usage"),
        GET_STATUS("op_get_status"),
        GET_STORAGE_POLICIES("op_get_storage_policies"),
        GET_STORAGE_POLICY("op_get_storage_policy"),
        GET_TRASH_ROOT("op_get_trash_root"),
        GET_XATTR("op_get_xattr"),
        LIST_CACHE_DIRECTIVE("op_list_cache_directive"),
        LIST_CACHE_POOL("op_list_cache_pool"),
        LIST_ENCRYPTION_ZONE("op_list_encryption_zone"),
        LIST_LOCATED_STATUS("op_list_located_status"),
        LIST_STATUS("op_list_status"),
        MODIFY_CACHE_POOL("op_modify_cache_pool"),
        MODIFY_CACHE_DIRECTIVE("op_modify_cache_directive"),
        MKDIRS("op_mkdirs"),
        MODIFY_ACL_ENTRIES("op_modify_acl_entries"),
        OPEN("op_open"),
        PRIMITIVE_CREATE("op_primitive_create"),
        PRIMITIVE_MKDIR("op_primitive_mkdir"),
        REMOVE_ACL("op_remove_acl"),
        REMOVE_ACL_ENTRIES("op_remove_acl_entries"),
        REMOVE_CACHE_DIRECTIVE("op_remove_cache_directive"),
        REMOVE_CACHE_POOL("op_remove_cache_pool"),
        REMOVE_DEFAULT_ACL("op_remove_default_acl"),
        REMOVE_EC_POLICY("op_remove_ec_policy"),
        REMOVE_XATTR("op_remove_xattr"),
        RENAME("op_rename"),
        RENAME_SNAPSHOT("op_rename_snapshot"),
        RESOLVE_LINK("op_resolve_link"),
        SATISFY_STORAGE_POLICY("op_satisfy_storagepolicy"),
        SET_ACL("op_set_acl"),
        SET_EC_POLICY("op_set_ec_policy"),
        SET_OWNER("op_set_owner"),
        SET_PERMISSION("op_set_permission"),
        SET_QUOTA_BYTSTORAGEYPE("op_set_quota_bystoragetype"),
        SET_QUOTA_USAGE("op_set_quota_usage"),
        SET_REPLICATION("op_set_replication"),
        SET_STORAGE_POLICY("op_set_storagePolicy"),
        SET_TIMES("op_set_times"),
        SET_XATTR("op_set_xattr"),
        GET_SNAPSHOT_DIFF("op_get_snapshot_diff"),
        GET_SNAPSHOTTABLE_DIRECTORY_LIST("op_get_snapshottable_directory_list"),
        TRUNCATE("op_truncate"),
        UNSET_EC_POLICY("op_unset_ec_policy"),
        UNSET_STORAGE_POLICY("op_unset_storage_policy");

        private static final Map<String, OpType> SYMBOL_MAP;
        private final String symbol;

        private OpType(String symbol) {
            this.symbol = symbol;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public static OpType fromSymbol(String symbol) {
            return SYMBOL_MAP.get(symbol);
        }

        static {
            SYMBOL_MAP = new HashMap<String, OpType>(OpType.values().length);
            for (OpType opType : OpType.values()) {
                SYMBOL_MAP.put(opType.getSymbol(), opType);
            }
        }
    }
}

