/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security.token.block;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Optional;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;

@InterfaceAudience.Private
public class BlockTokenIdentifier
extends TokenIdentifier {
    static final Text KIND_NAME = new Text("HDFS_BLOCK_TOKEN");
    private long expiryDate;
    private int keyId;
    private String userId;
    private String blockPoolId;
    private long blockId;
    private final EnumSet<AccessMode> modes;
    private StorageType[] storageTypes;
    private String[] storageIds;
    private boolean useProto;
    private byte[] handshakeMsg;
    private byte[] cache = null;

    public BlockTokenIdentifier() {
        this(null, null, 0L, EnumSet.noneOf(AccessMode.class), null, null, false);
    }

    public BlockTokenIdentifier(String userId, String bpid, long blockId, EnumSet<AccessMode> modes, StorageType[] storageTypes, String[] storageIds, boolean useProto) {
        this.userId = userId;
        this.blockPoolId = bpid;
        this.blockId = blockId;
        this.modes = modes == null ? EnumSet.noneOf(AccessMode.class) : modes;
        this.storageTypes = Optional.ofNullable(storageTypes).orElse(StorageType.EMPTY_ARRAY);
        this.storageIds = Optional.ofNullable(storageIds).orElse(new String[0]);
        this.useProto = useProto;
        this.handshakeMsg = new byte[0];
    }

    @Override
    public Text getKind() {
        return KIND_NAME;
    }

    @Override
    public UserGroupInformation getUser() {
        if (this.userId == null || "".equals(this.userId)) {
            String user = this.blockPoolId + ":" + Long.toString(this.blockId);
            return UserGroupInformation.createRemoteUser(user);
        }
        return UserGroupInformation.createRemoteUser(this.userId);
    }

    public long getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(long expiryDate) {
        this.cache = null;
        this.expiryDate = expiryDate;
    }

    public int getKeyId() {
        return this.keyId;
    }

    public void setKeyId(int keyId) {
        this.cache = null;
        this.keyId = keyId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getBlockPoolId() {
        return this.blockPoolId;
    }

    public long getBlockId() {
        return this.blockId;
    }

    public EnumSet<AccessMode> getAccessModes() {
        return this.modes;
    }

    public StorageType[] getStorageTypes() {
        return this.storageTypes;
    }

    public String[] getStorageIds() {
        return this.storageIds;
    }

    public byte[] getHandshakeMsg() {
        return this.handshakeMsg;
    }

    public void setHandshakeMsg(byte[] bytes) {
        this.cache = null;
        this.handshakeMsg = bytes;
    }

    public String toString() {
        return "block_token_identifier (expiryDate=" + this.getExpiryDate() + ", keyId=" + this.getKeyId() + ", userId=" + this.getUserId() + ", blockPoolId=" + this.getBlockPoolId() + ", blockId=" + this.getBlockId() + ", access modes=" + this.getAccessModes() + ", storageTypes= " + Arrays.toString((Object[])this.getStorageTypes()) + ", storageIds= " + Arrays.toString(this.getStorageIds()) + ")";
    }

    static boolean isEqual(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BlockTokenIdentifier) {
            BlockTokenIdentifier that = (BlockTokenIdentifier)obj;
            return this.expiryDate == that.expiryDate && this.keyId == that.keyId && BlockTokenIdentifier.isEqual(this.userId, that.userId) && BlockTokenIdentifier.isEqual(this.blockPoolId, that.blockPoolId) && this.blockId == that.blockId && BlockTokenIdentifier.isEqual(this.modes, that.modes) && Arrays.equals((Object[])this.storageTypes, (Object[])that.storageTypes) && Arrays.equals(this.storageIds, that.storageIds);
        }
        return false;
    }

    public int hashCode() {
        return (int)this.expiryDate ^ this.keyId ^ (int)this.blockId ^ this.modes.hashCode() ^ (this.userId == null ? 0 : this.userId.hashCode()) ^ (this.blockPoolId == null ? 0 : this.blockPoolId.hashCode()) ^ (this.storageTypes == null ? 0 : Arrays.hashCode((Object[])this.storageTypes)) ^ (this.storageIds == null ? 0 : Arrays.hashCode(this.storageIds));
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.cache = null;
        DataInputStream dis = (DataInputStream)in;
        if (!dis.markSupported()) {
            throw new IOException("Could not peek first byte.");
        }
        this.cache = IOUtils.readFullyToByteArray(dis);
        dis.reset();
        dis.mark(1);
        byte firstByte = dis.readByte();
        dis.reset();
        if (firstByte <= 0) {
            this.readFieldsLegacy(dis);
        } else {
            this.readFieldsProtobuf(dis);
        }
    }

    @VisibleForTesting
    void readFieldsLegacy(DataInput in) throws IOException {
        this.expiryDate = WritableUtils.readVLong(in);
        this.keyId = WritableUtils.readVInt(in);
        this.userId = WritableUtils.readString(in);
        this.blockPoolId = WritableUtils.readString(in);
        this.blockId = WritableUtils.readVLong(in);
        int length = WritableUtils.readVIntInRange(in, 0, ((AccessMode[])AccessMode.class.getEnumConstants()).length);
        for (int i = 0; i < length; ++i) {
            this.modes.add(WritableUtils.readEnum(in, AccessMode.class));
        }
        try {
            length = WritableUtils.readVInt(in);
            StorageType[] readStorageTypes = new StorageType[length];
            for (int i = 0; i < length; ++i) {
                readStorageTypes[i] = WritableUtils.readEnum(in, StorageType.class);
            }
            this.storageTypes = readStorageTypes;
            length = WritableUtils.readVInt(in);
            String[] readStorageIds = new String[length];
            for (int i = 0; i < length; ++i) {
                readStorageIds[i] = WritableUtils.readString(in);
            }
            this.storageIds = readStorageIds;
            int handshakeMsgLen = WritableUtils.readVInt(in);
            if (handshakeMsgLen != 0) {
                this.handshakeMsg = new byte[handshakeMsgLen];
                in.readFully(this.handshakeMsg);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        this.useProto = false;
    }

    @VisibleForTesting
    void readFieldsProtobuf(DataInput in) throws IOException {
        HdfsProtos.BlockTokenSecretProto blockTokenSecretProto = HdfsProtos.BlockTokenSecretProto.parseFrom((DataInputStream)in);
        this.expiryDate = blockTokenSecretProto.getExpiryDate();
        this.keyId = blockTokenSecretProto.getKeyId();
        this.userId = blockTokenSecretProto.hasUserId() ? blockTokenSecretProto.getUserId() : null;
        this.blockPoolId = blockTokenSecretProto.hasBlockPoolId() ? blockTokenSecretProto.getBlockPoolId() : null;
        this.blockId = blockTokenSecretProto.getBlockId();
        for (int i = 0; i < blockTokenSecretProto.getModesCount(); ++i) {
            HdfsProtos.AccessModeProto accessModeProto = blockTokenSecretProto.getModes(i);
            this.modes.add(PBHelperClient.convert(accessModeProto));
        }
        this.storageTypes = (StorageType[])blockTokenSecretProto.getStorageTypesList().stream().map(PBHelperClient::convertStorageType).toArray(StorageType[]::new);
        this.storageIds = (String[])blockTokenSecretProto.getStorageIdsList().stream().toArray(String[]::new);
        this.useProto = true;
        this.handshakeMsg = blockTokenSecretProto.hasHandshakeSecret() ? blockTokenSecretProto.getHandshakeSecret().toByteArray() : new byte[0];
    }

    @Override
    public void write(DataOutput out) throws IOException {
        if (this.useProto) {
            this.writeProtobuf(out);
        } else {
            this.writeLegacy(out);
        }
    }

    @VisibleForTesting
    void writeLegacy(DataOutput out) throws IOException {
        WritableUtils.writeVLong(out, this.expiryDate);
        WritableUtils.writeVInt(out, this.keyId);
        WritableUtils.writeString(out, this.userId);
        WritableUtils.writeString(out, this.blockPoolId);
        WritableUtils.writeVLong(out, this.blockId);
        WritableUtils.writeVInt(out, this.modes.size());
        for (AccessMode aMode : this.modes) {
            WritableUtils.writeEnum(out, aMode);
        }
        if (this.storageTypes != null) {
            WritableUtils.writeVInt(out, this.storageTypes.length);
            StorageType[] storageTypeArray = this.storageTypes;
            int n = storageTypeArray.length;
            for (int i = 0; i < n; ++i) {
                StorageType storageType = storageTypeArray[i];
                WritableUtils.writeEnum(out, storageType);
            }
        }
        if (this.storageIds != null) {
            WritableUtils.writeVInt(out, this.storageIds.length);
            for (String string : this.storageIds) {
                WritableUtils.writeString(out, string);
            }
        }
        if (this.handshakeMsg != null && this.handshakeMsg.length > 0) {
            WritableUtils.writeVInt(out, this.handshakeMsg.length);
            out.write(this.handshakeMsg);
        }
    }

    @VisibleForTesting
    void writeProtobuf(DataOutput out) throws IOException {
        HdfsProtos.BlockTokenSecretProto secret = PBHelperClient.convert(this);
        out.write(secret.toByteArray());
    }

    @Override
    public byte[] getBytes() {
        if (this.cache == null) {
            this.cache = super.getBytes();
        }
        return this.cache;
    }

    @InterfaceAudience.Private
    public static class Renewer
    extends Token.TrivialRenewer {
        @Override
        protected Text getKind() {
            return KIND_NAME;
        }
    }

    public static enum AccessMode {
        READ,
        WRITE,
        COPY,
        REPLACE;

    }
}

