/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.Serializable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.org.apache.commons.codec.binary.Hex;

@InterfaceAudience.Private
public class FileEncryptionInfo
implements Serializable {
    private static final long serialVersionUID = 359316995L;
    private final CipherSuite cipherSuite;
    private final CryptoProtocolVersion version;
    private final byte[] edek;
    private final byte[] iv;
    private final String keyName;
    private final String ezKeyVersionName;

    public FileEncryptionInfo(CipherSuite suite, CryptoProtocolVersion version, byte[] edek, byte[] iv, String keyName, String ezKeyVersionName) {
        Preconditions.checkNotNull((Object)((Object)suite));
        Preconditions.checkNotNull((Object)((Object)version));
        Preconditions.checkNotNull((Object)edek);
        Preconditions.checkNotNull((Object)iv);
        Preconditions.checkNotNull((Object)keyName);
        Preconditions.checkNotNull((Object)ezKeyVersionName);
        Preconditions.checkArgument((iv.length == suite.getAlgorithmBlockSize() ? 1 : 0) != 0, (Object)"Unexpected IV length");
        this.cipherSuite = suite;
        this.version = version;
        this.edek = edek;
        this.iv = iv;
        this.keyName = keyName;
        this.ezKeyVersionName = ezKeyVersionName;
    }

    public CipherSuite getCipherSuite() {
        return this.cipherSuite;
    }

    public CryptoProtocolVersion getCryptoProtocolVersion() {
        return this.version;
    }

    public byte[] getEncryptedDataEncryptionKey() {
        return this.edek;
    }

    public byte[] getIV() {
        return this.iv;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getEzKeyVersionName() {
        return this.ezKeyVersionName;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{").append("cipherSuite: " + (Object)((Object)this.cipherSuite)).append(", cryptoProtocolVersion: " + (Object)((Object)this.version)).append(", edek: " + Hex.encodeHexString((byte[])this.edek)).append(", iv: " + Hex.encodeHexString((byte[])this.iv)).append(", keyName: " + this.keyName).append(", ezKeyVersionName: " + this.ezKeyVersionName).append("}");
        return builder.toString();
    }

    public String toStringStable() {
        StringBuilder builder = new StringBuilder("{").append("cipherSuite: " + (Object)((Object)this.cipherSuite)).append(", cryptoProtocolVersion: " + (Object)((Object)this.version)).append(", edek: " + Hex.encodeHexString((byte[])this.edek)).append(", iv: " + Hex.encodeHexString((byte[])this.iv)).append(", keyName: " + this.keyName).append(", ezKeyVersionName: " + this.ezKeyVersionName).append("}");
        return builder.toString();
    }
}

