/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.InnerNode;
import org.apache.hadoop.net.InnerNodeImpl;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class NetworkTopology {
    public static final String DEFAULT_RACK = "/default-rack";
    public static final Logger LOG = LoggerFactory.getLogger(NetworkTopology.class);
    private static final char PATH_SEPARATOR = '/';
    private static final String PATH_SEPARATOR_STR = "/";
    private static final String ROOT = "/";
    InnerNode.Factory factory;
    InnerNode clusterMap;
    private int depthOfAllLeaves = -1;
    protected int numOfRacks = 0;
    private boolean clusterEverBeenMultiRack = false;
    protected ReadWriteLock netlock = new ReentrantReadWriteLock(true);
    private static final Random r = new Random();

    public static NetworkTopology getInstance(Configuration conf) {
        return NetworkTopology.getInstance(conf, InnerNodeImpl.FACTORY);
    }

    public static NetworkTopology getInstance(Configuration conf, InnerNode.Factory factory) {
        NetworkTopology nt = ReflectionUtils.newInstance(conf.getClass("net.topology.impl", NetworkTopology.class, NetworkTopology.class), conf);
        return nt.init(factory);
    }

    protected NetworkTopology init(InnerNode.Factory factory) {
        if (!factory.equals(this.factory)) {
            this.factory = factory;
            this.clusterMap = factory.newInnerNode("");
        }
        return this;
    }

    public NetworkTopology() {
        this.factory = InnerNodeImpl.FACTORY;
        this.clusterMap = this.factory.newInnerNode("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Node node) {
        if (node == null) {
            return;
        }
        int newDepth = NodeBase.locationToDepth(node.getNetworkLocation()) + 1;
        this.netlock.writeLock().lock();
        try {
            if (node instanceof InnerNode) {
                throw new IllegalArgumentException("Not allow to add an inner node: " + NodeBase.getPath(node));
            }
            if (this.depthOfAllLeaves != -1 && this.depthOfAllLeaves != newDepth) {
                LOG.error("Error: can't add leaf node {} at depth {} to topology:{}\n", new Object[]{NodeBase.getPath(node), newDepth, this});
                throw new InvalidTopologyException("Failed to add " + NodeBase.getPath(node) + ": You cannot have a rack and a non-rack node at the same level of the network topology.");
            }
            Node rack = this.getNodeForNetworkLocation(node);
            if (rack != null && !(rack instanceof InnerNode)) {
                throw new IllegalArgumentException("Unexpected data node " + node.toString() + " at an illegal network location");
            }
            if (this.clusterMap.add(node)) {
                LOG.info("Adding a new node: " + NodeBase.getPath(node));
                if (rack == null) {
                    this.incrementRacks();
                }
                if (this.depthOfAllLeaves == -1) {
                    this.depthOfAllLeaves = node.getLevel();
                }
            }
            LOG.debug("NetworkTopology became:\n{}", (Object)this);
        }
        finally {
            this.netlock.writeLock().unlock();
        }
    }

    protected void incrementRacks() {
        ++this.numOfRacks;
        if (!this.clusterEverBeenMultiRack && this.numOfRacks > 1) {
            this.clusterEverBeenMultiRack = true;
        }
    }

    protected Node getNodeForNetworkLocation(Node node) {
        return this.getNode(node.getNetworkLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Node> getDatanodesInRack(String loc) {
        this.netlock.readLock().lock();
        try {
            InnerNode rack;
            loc = NodeBase.normalize(loc);
            if (!"".equals(loc)) {
                loc = loc.substring(1);
            }
            if ((rack = (InnerNode)this.clusterMap.getLoc(loc)) == null) {
                List<Node> list = null;
                return list;
            }
            ArrayList<Node> arrayList = new ArrayList<Node>(rack.getChildren());
            return arrayList;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    public void remove(Node node) {
        if (node == null) {
            return;
        }
        if (node instanceof InnerNode) {
            throw new IllegalArgumentException("Not allow to remove an inner node: " + NodeBase.getPath(node));
        }
        LOG.info("Removing a node: " + NodeBase.getPath(node));
        this.netlock.writeLock().lock();
        try {
            InnerNode rack;
            if (this.clusterMap.remove(node) && (rack = (InnerNode)this.getNode(node.getNetworkLocation())) == null) {
                --this.numOfRacks;
            }
            LOG.debug("NetworkTopology became:\n{}", (Object)this);
        }
        finally {
            this.netlock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Node node) {
        if (node == null) {
            return false;
        }
        this.netlock.readLock().lock();
        try {
            Node parent = node.getParent();
            for (int level = node.getLevel(); parent != null && level > 0; parent = parent.getParent(), --level) {
                if (parent != this.clusterMap) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.netlock.readLock().unlock();
        }
        return false;
    }

    public Node getNode(String loc) {
        this.netlock.readLock().lock();
        try {
            loc = NodeBase.normalize(loc);
            if (!"".equals(loc)) {
                loc = loc.substring(1);
            }
            Node node = this.clusterMap.getLoc(loc);
            return node;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    public boolean hasClusterEverBeenMultiRack() {
        return this.clusterEverBeenMultiRack;
    }

    public String getRack(String loc) {
        return loc;
    }

    public int getNumOfRacks() {
        return this.numOfRacks;
    }

    public int getNumOfLeaves() {
        return this.clusterMap.getNumOfLeaves();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDistance(Node node1, Node node2) {
        if (node1 != null && node1.equals(node2) || node1 == null && node2 == null) {
            return 0;
        }
        if (node1 == null || node2 == null) {
            LOG.warn("One of the nodes is a null pointer");
            return Integer.MAX_VALUE;
        }
        Node n1 = node1;
        Node n2 = node2;
        int dis = 0;
        this.netlock.readLock().lock();
        try {
            int level1 = node1.getLevel();
            int level2 = node2.getLevel();
            while (n1 != null && level1 > level2) {
                n1 = n1.getParent();
                --level1;
                ++dis;
            }
            while (n2 != null && level2 > level1) {
                n2 = n2.getParent();
                --level2;
                ++dis;
            }
            while (n1 != null && n2 != null && n1.getParent() != n2.getParent()) {
                n1 = n1.getParent();
                n2 = n2.getParent();
                dis += 2;
            }
        }
        finally {
            this.netlock.readLock().unlock();
        }
        if (n1 == null) {
            LOG.warn("The cluster does not contain node: " + NodeBase.getPath(node1));
            return Integer.MAX_VALUE;
        }
        if (n2 == null) {
            LOG.warn("The cluster does not contain node: " + NodeBase.getPath(node2));
            return Integer.MAX_VALUE;
        }
        return dis + 2;
    }

    public static int getDistanceByPath(Node node1, Node node2) {
        if (node1 == null && node2 == null) {
            return 0;
        }
        if (node1 == null || node2 == null) {
            LOG.warn("One of the nodes is a null pointer");
            return Integer.MAX_VALUE;
        }
        String[] paths1 = NodeBase.getPathComponents(node1);
        String[] paths2 = NodeBase.getPathComponents(node2);
        int dis = 0;
        int minLevel = Math.min(paths1.length, paths2.length);
        for (int index = 0; index < minLevel; ++index) {
            if (paths1[index].equals(paths2[index])) continue;
            dis += 2 * (minLevel - index);
            break;
        }
        return dis += Math.abs(paths1.length - paths2.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOnSameRack(Node node1, Node node2) {
        if (node1 == null || node2 == null) {
            return false;
        }
        this.netlock.readLock().lock();
        try {
            boolean bl = this.isSameParents(node1, node2);
            return bl;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    public boolean isNodeGroupAware() {
        return false;
    }

    public boolean isOnSameNodeGroup(Node node1, Node node2) {
        return false;
    }

    protected boolean isSameParents(Node node1, Node node2) {
        return node1.getParent() == node2.getParent();
    }

    @VisibleForTesting
    void setRandomSeed(long seed) {
        r.setSeed(seed);
    }

    public Node chooseRandom(String scope) {
        return this.chooseRandom(scope, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node chooseRandom(String scope, Collection<Node> excludedNodes) {
        this.netlock.readLock().lock();
        try {
            if (scope.startsWith("~")) {
                Node node = this.chooseRandom("", scope.substring(1), excludedNodes);
                return node;
            }
            Node node = this.chooseRandom(scope, null, excludedNodes);
            return node;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node chooseRandom(String scope, String excludedScope, Collection<Node> excludedNodes) {
        int availableNodes;
        Node node;
        if (excludedScope != null) {
            if (scope.startsWith(excludedScope)) {
                return null;
            }
            if (!excludedScope.startsWith(scope)) {
                excludedScope = null;
            }
        }
        if (!((node = this.getNode(scope)) instanceof InnerNode)) {
            return excludedNodes != null && excludedNodes.contains(node) ? null : node;
        }
        InnerNode innerNode = (InnerNode)node;
        int numOfDatanodes = innerNode.getNumOfLeaves();
        if (excludedScope == null) {
            node = null;
        } else {
            node = this.getNode(excludedScope);
            numOfDatanodes = !(node instanceof InnerNode) ? --numOfDatanodes : (numOfDatanodes -= ((InnerNode)node).getNumOfLeaves());
        }
        if (numOfDatanodes <= 0) {
            LOG.debug("Failed to find datanode (scope=\"{}\" excludedScope=\"{}\"). numOfDatanodes={}", new Object[]{scope, excludedScope, numOfDatanodes});
            return null;
        }
        if (excludedScope == null) {
            availableNodes = this.countNumOfAvailableNodes(scope, excludedNodes);
        } else {
            this.netlock.readLock().lock();
            try {
                availableNodes = this.countNumOfAvailableNodes(scope, excludedNodes) - this.countNumOfAvailableNodes(excludedScope, excludedNodes);
            }
            finally {
                this.netlock.readLock().unlock();
            }
        }
        LOG.debug("Choosing random from {} available nodes on node {}, scope={}, excludedScope={}, excludeNodes={}. numOfDatanodes={}.", new Object[]{availableNodes, innerNode, scope, excludedScope, excludedNodes, numOfDatanodes});
        Node ret = null;
        if (availableNodes > 0) {
            ret = this.chooseRandom(innerNode, node, excludedNodes, numOfDatanodes, availableNodes);
        }
        LOG.debug("chooseRandom returning {}", ret);
        return ret;
    }

    private Node chooseRandom(InnerNode parentNode, Node excludedScopeNode, Collection<Node> excludedNodes, int totalInScopeNodes, int availableNodes) {
        if (totalInScopeNodes < availableNodes) {
            LOG.warn("Total Nodes in scope : {} are less than Available Nodes : {}", (Object)totalInScopeNodes, (Object)availableNodes);
            return null;
        }
        if (excludedNodes == null || excludedNodes.isEmpty()) {
            int index = r.nextInt(totalInScopeNodes);
            return parentNode.getLeaf(index, excludedScopeNode);
        }
        int nthValidToReturn = r.nextInt(availableNodes);
        LOG.debug("nthValidToReturn is {}", (Object)nthValidToReturn);
        Node ret = parentNode.getLeaf(r.nextInt(totalInScopeNodes), excludedScopeNode);
        if (!excludedNodes.contains(ret)) {
            LOG.debug("Chosen node {} from first random", (Object)ret);
            return ret;
        }
        ret = null;
        Node lastValidNode = null;
        for (int i = 0; i < totalInScopeNodes; ++i) {
            ret = parentNode.getLeaf(i, excludedScopeNode);
            if (!excludedNodes.contains(ret)) {
                if (nthValidToReturn == 0) break;
                --nthValidToReturn;
                lastValidNode = ret;
                continue;
            }
            LOG.debug("Node {} is excluded, continuing.", (Object)ret);
            ret = null;
        }
        if (ret == null && lastValidNode != null) {
            LOG.error("BUG: Found lastValidNode {} but not nth valid node. parentNode={}, excludedScopeNode={}, excludedNodes={}, totalInScopeNodes={}, availableNodes={}, nthValidToReturn={}.", new Object[]{lastValidNode, parentNode, excludedScopeNode, excludedNodes, totalInScopeNodes, availableNodes, nthValidToReturn});
            ret = lastValidNode;
        }
        return ret;
    }

    public List<Node> getLeaves(String scope) {
        Node node = this.getNode(scope);
        ArrayList<Node> leafNodes = new ArrayList<Node>();
        if (!(node instanceof InnerNode)) {
            leafNodes.add(node);
        } else {
            InnerNode innerNode = (InnerNode)node;
            for (int i = 0; i < innerNode.getNumOfLeaves(); ++i) {
                leafNodes.add(innerNode.getLeaf(i, null));
            }
        }
        return leafNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public int countNumOfAvailableNodes(String scope, Collection<Node> excludedNodes) {
        boolean isExcluded = false;
        if (scope.startsWith("~")) {
            isExcluded = true;
            scope = scope.substring(1);
        }
        scope = NodeBase.normalize(scope);
        int excludedCountInScope = 0;
        int excludedCountOffScope = 0;
        this.netlock.readLock().lock();
        try {
            if (excludedNodes != null) {
                for (Node node : excludedNodes) {
                    if ((node = this.getNode(NodeBase.getPath(node))) == null) continue;
                    if ((NodeBase.getPath(node) + "/").startsWith(scope + "/")) {
                        if (node instanceof InnerNode) {
                            excludedCountInScope += ((InnerNode)node).getNumOfLeaves();
                            continue;
                        }
                        ++excludedCountInScope;
                        continue;
                    }
                    ++excludedCountOffScope;
                }
            }
            Node n = this.getNode(scope);
            int scopeNodeCount = 0;
            if (n != null) {
                ++scopeNodeCount;
            }
            if (n instanceof InnerNode) {
                scopeNodeCount = ((InnerNode)n).getNumOfLeaves();
            }
            if (isExcluded) {
                int n2 = this.clusterMap.getNumOfLeaves() - scopeNodeCount - excludedCountOffScope;
                return n2;
            }
            int n3 = scopeNodeCount - excludedCountInScope;
            return n3;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    public String toString() {
        StringBuilder tree = new StringBuilder();
        tree.append("Number of racks: ").append(this.numOfRacks).append("\n");
        int numOfLeaves = this.getNumOfLeaves();
        tree.append("Expected number of leaves:").append(numOfLeaves).append("\n");
        for (int i = 0; i < numOfLeaves; ++i) {
            tree.append(NodeBase.getPath(this.clusterMap.getLeaf(i, null))).append("\n");
        }
        return tree.toString();
    }

    public static String getFirstHalf(String networkLocation) {
        int index = networkLocation.lastIndexOf("/");
        return networkLocation.substring(0, index);
    }

    public static String getLastHalf(String networkLocation) {
        int index = networkLocation.lastIndexOf("/");
        return networkLocation.substring(index);
    }

    @VisibleForTesting
    protected int getWeight(Node reader, Node node) {
        int weight = Integer.MAX_VALUE;
        if (reader != null && node != null) {
            int maxNodeLevel;
            if (reader.equals(node)) {
                return 0;
            }
            int maxReaderLevel = reader.getLevel();
            int currentLevelToCompare = maxReaderLevel > (maxNodeLevel = node.getLevel()) ? maxNodeLevel : maxReaderLevel;
            Node r = reader;
            Node n = node;
            weight = 0;
            while (r != null && r.getLevel() > currentLevelToCompare) {
                r = r.getParent();
                ++weight;
            }
            while (n != null && n.getLevel() > currentLevelToCompare) {
                n = n.getParent();
                ++weight;
            }
            while (r != null && n != null && !r.equals(n)) {
                r = r.getParent();
                n = n.getParent();
                weight += 2;
            }
        }
        return weight;
    }

    @VisibleForTesting
    protected static int getWeightUsingNetworkLocation(Node reader, Node node) {
        int weight = Integer.MAX_VALUE;
        if (reader != null && node != null) {
            String nodePath;
            String readerPath = NetworkTopology.normalizeNetworkLocationPath(reader.getNetworkLocation());
            if (readerPath.equals(nodePath = NetworkTopology.normalizeNetworkLocationPath(node.getNetworkLocation()))) {
                weight = reader.getName().equals(node.getName()) ? 0 : 2;
            } else {
                int currentLevel;
                String[] nodePathToken;
                String[] readerPathToken = readerPath.split("/");
                int maxLevelToCompare = readerPathToken.length > (nodePathToken = nodePath.split("/")).length ? nodePathToken.length : readerPathToken.length;
                for (currentLevel = 1; currentLevel < maxLevelToCompare && readerPathToken[currentLevel].equals(nodePathToken[currentLevel]); ++currentLevel) {
                }
                weight = readerPathToken.length - currentLevel + (nodePathToken.length - currentLevel) + 2;
            }
        }
        return weight;
    }

    private static String normalizeNetworkLocationPath(String path) {
        if (path == null || path.length() == 0) {
            return "/";
        }
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException("Network Locationpath doesn't start with /: " + path);
        }
        int len = path.length();
        if (path.charAt(len - 1) == '/') {
            return path.substring(0, len - 1);
        }
        return path;
    }

    public void sortByDistance(Node reader, Node[] nodes, int activeLen) {
        this.sortByDistance(reader, nodes, activeLen, list -> Collections.shuffle(list));
    }

    public <T extends Node> void sortByDistance(Node reader, T[] nodes, int activeLen, Consumer<List<T>> secondarySort) {
        this.sortByDistance(reader, (Node[])nodes, activeLen, secondarySort, false);
    }

    public void sortByDistanceUsingNetworkLocation(Node reader, Node[] nodes, int activeLen) {
        this.sortByDistanceUsingNetworkLocation(reader, nodes, activeLen, list -> Collections.shuffle(list));
    }

    public <T extends Node> void sortByDistanceUsingNetworkLocation(Node reader, T[] nodes, int activeLen, Consumer<List<T>> secondarySort) {
        this.sortByDistance(reader, (Node[])nodes, activeLen, secondarySort, true);
    }

    private <T extends Node> void sortByDistance(Node reader, T[] nodes, int activeLen, Consumer<List<T>> secondarySort, boolean nonDataNodeReader) {
        int[] weights = new int[activeLen];
        for (int i = 0; i < activeLen; ++i) {
            weights[i] = nonDataNodeReader ? NetworkTopology.getWeightUsingNetworkLocation(reader, nodes[i]) : this.getWeight(reader, (Node)nodes[i]);
        }
        TreeMap<Integer, List> tree = new TreeMap<Integer, List>();
        for (int i = 0; i < activeLen; ++i) {
            int weight = weights[i];
            T node = nodes[i];
            List list = (List)tree.get(weight);
            if (list == null) {
                list = Lists.newArrayListWithExpectedSize((int)1);
                tree.put(weight, list);
            }
            list.add(node);
        }
        int idx = 0;
        for (List list : tree.values()) {
            if (list == null) continue;
            secondarySort.accept(list);
            for (Node n : list) {
                nodes[idx] = n;
                ++idx;
            }
        }
        Preconditions.checkState((idx == activeLen ? 1 : 0) != 0, (Object)"Sorted the wrong number of nodes!");
    }

    public static class InvalidTopologyException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public InvalidTopologyException(String msg) {
            super(msg);
        }
    }
}

