/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.shaded.com.google.gson.Gson;
import org.apache.hadoop.shaded.com.google.gson.reflect.TypeToken;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.PriorityPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.TokenPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ContainerPBImpl
extends Container {
    YarnProtos.ContainerProto proto = YarnProtos.ContainerProto.getDefaultInstance();
    YarnProtos.ContainerProto.Builder builder = null;
    boolean viaProto = false;
    private ContainerId containerId = null;
    private NodeId nodeId = null;
    private Resource resource = null;
    private Priority priority = null;
    private Token containerToken = null;
    private Set<String> allocationTags = null;
    private Map<String, List<Map<String, String>>> exposedPorts = null;

    public ContainerPBImpl() {
        this.builder = YarnProtos.ContainerProto.newBuilder();
    }

    public ContainerPBImpl(YarnProtos.ContainerProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnProtos.ContainerProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((ContainerPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    private void mergeLocalToBuilder() {
        if (this.containerId != null && !((ContainerIdPBImpl)this.containerId).getProto().equals(this.builder.getId())) {
            this.builder.setId(this.convertToProtoFormat(this.containerId));
        }
        if (this.nodeId != null && !((NodeIdPBImpl)this.nodeId).getProto().equals(this.builder.getNodeId())) {
            this.builder.setNodeId(this.convertToProtoFormat(this.nodeId));
        }
        if (this.resource != null) {
            this.builder.setResource(this.convertToProtoFormat(this.resource));
        }
        if (this.priority != null && !((PriorityPBImpl)this.priority).getProto().equals(this.builder.getPriority())) {
            this.builder.setPriority(this.convertToProtoFormat(this.priority));
        }
        if (this.containerToken != null && !((TokenPBImpl)this.containerToken).getProto().equals(this.builder.getContainerToken())) {
            this.builder.setContainerToken(this.convertToProtoFormat(this.containerToken));
        }
        if (this.allocationTags != null) {
            this.builder.clearAllocationTags();
            this.builder.addAllAllocationTags(this.allocationTags);
        }
        if (this.exposedPorts != null) {
            Gson gson = new Gson();
            String strExposedPorts = gson.toJson(this.exposedPorts);
            this.builder.setExposedPorts(strExposedPorts);
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ContainerProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public ContainerId getId() {
        YarnProtos.ContainerProtoOrBuilder p;
        YarnProtos.ContainerProtoOrBuilder containerProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.containerId != null) {
            return this.containerId;
        }
        if (!p.hasId()) {
            return null;
        }
        this.containerId = this.convertFromProtoFormat(p.getId());
        return this.containerId;
    }

    @Override
    public void setNodeId(NodeId nodeId) {
        this.maybeInitBuilder();
        if (nodeId == null) {
            this.builder.clearNodeId();
        }
        this.nodeId = nodeId;
    }

    @Override
    public NodeId getNodeId() {
        YarnProtos.ContainerProtoOrBuilder p;
        YarnProtos.ContainerProtoOrBuilder containerProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.nodeId != null) {
            return this.nodeId;
        }
        if (!p.hasNodeId()) {
            return null;
        }
        this.nodeId = this.convertFromProtoFormat(p.getNodeId());
        return this.nodeId;
    }

    @Override
    public void setId(ContainerId id) {
        this.maybeInitBuilder();
        if (id == null) {
            this.builder.clearId();
        }
        this.containerId = id;
    }

    @Override
    public String getNodeHttpAddress() {
        YarnProtos.ContainerProtoOrBuilder p;
        YarnProtos.ContainerProtoOrBuilder containerProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasNodeHttpAddress()) {
            return null;
        }
        return p.getNodeHttpAddress();
    }

    @Override
    public void setNodeHttpAddress(String nodeHttpAddress) {
        this.maybeInitBuilder();
        if (nodeHttpAddress == null) {
            this.builder.clearNodeHttpAddress();
            return;
        }
        this.builder.setNodeHttpAddress(nodeHttpAddress.intern());
    }

    @Override
    public Resource getResource() {
        YarnProtos.ContainerProtoOrBuilder p;
        YarnProtos.ContainerProtoOrBuilder containerProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.resource != null) {
            return this.resource;
        }
        if (!p.hasResource()) {
            return null;
        }
        this.resource = this.convertFromProtoFormat(p.getResource());
        return this.resource;
    }

    @Override
    public void setResource(Resource resource) {
        this.maybeInitBuilder();
        if (resource == null) {
            this.builder.clearResource();
        }
        this.resource = resource;
    }

    @Override
    public Map<String, List<Map<String, String>>> getExposedPorts() {
        YarnProtos.ContainerProtoOrBuilder p;
        YarnProtos.ContainerProtoOrBuilder containerProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.exposedPorts != null) {
            return this.exposedPorts;
        }
        if (!p.hasExposedPorts()) {
            return null;
        }
        String ports = p.getExposedPorts();
        Gson gson = new Gson();
        this.exposedPorts = (Map)gson.fromJson(ports, new TypeToken<Map<String, List<Map<String, String>>>>(){}.getType());
        return this.exposedPorts;
    }

    @Override
    public void setExposedPorts(Map<String, List<Map<String, String>>> ports) {
        this.maybeInitBuilder();
        if (this.resource == null) {
            this.builder.clearExposedPorts();
        }
        this.exposedPorts = ports;
    }

    @Override
    public Priority getPriority() {
        YarnProtos.ContainerProtoOrBuilder p;
        YarnProtos.ContainerProtoOrBuilder containerProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.priority != null) {
            return this.priority;
        }
        if (!p.hasPriority()) {
            return null;
        }
        this.priority = this.convertFromProtoFormat(p.getPriority());
        return this.priority;
    }

    @Override
    public void setPriority(Priority priority) {
        this.maybeInitBuilder();
        if (priority == null) {
            this.builder.clearPriority();
        }
        this.priority = priority;
    }

    @Override
    public Token getContainerToken() {
        YarnProtos.ContainerProtoOrBuilder p;
        YarnProtos.ContainerProtoOrBuilder containerProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.containerToken != null) {
            return this.containerToken;
        }
        if (!p.hasContainerToken()) {
            return null;
        }
        this.containerToken = this.convertFromProtoFormat(p.getContainerToken());
        return this.containerToken;
    }

    @Override
    public void setContainerToken(Token containerToken) {
        this.maybeInitBuilder();
        if (containerToken == null) {
            this.builder.clearContainerToken();
        }
        this.containerToken = containerToken;
    }

    @Override
    public ExecutionType getExecutionType() {
        YarnProtos.ContainerProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return this.convertFromProtoFormat(p.getExecutionType());
    }

    @Override
    public void setExecutionType(ExecutionType executionType) {
        this.maybeInitBuilder();
        this.builder.setExecutionType(this.convertToProtoFormat(executionType));
    }

    @Override
    public long getAllocationRequestId() {
        YarnProtos.ContainerProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getAllocationRequestId();
    }

    @Override
    public void setAllocationRequestId(long allocationRequestID) {
        this.maybeInitBuilder();
        this.builder.setAllocationRequestId(allocationRequestID);
    }

    @Override
    public int getVersion() {
        YarnProtos.ContainerProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getVersion();
    }

    @Override
    public void setVersion(int version) {
        this.maybeInitBuilder();
        this.builder.setVersion(version);
    }

    private void initAllocationTags() {
        if (this.allocationTags != null) {
            return;
        }
        YarnProtos.ContainerProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        this.allocationTags = new HashSet<String>();
        this.allocationTags.addAll(p.getAllocationTagsList());
    }

    @Override
    public Set<String> getAllocationTags() {
        this.initAllocationTags();
        return this.allocationTags;
    }

    @Override
    public void setAllocationTags(Set<String> allocationTags) {
        this.maybeInitBuilder();
        this.builder.clearAllocationTags();
        this.allocationTags = allocationTags;
    }

    private ContainerIdPBImpl convertFromProtoFormat(YarnProtos.ContainerIdProto p) {
        return new ContainerIdPBImpl(p);
    }

    private NodeIdPBImpl convertFromProtoFormat(YarnProtos.NodeIdProto p) {
        return new NodeIdPBImpl(p);
    }

    private YarnProtos.ContainerIdProto convertToProtoFormat(ContainerId t) {
        return ((ContainerIdPBImpl)t).getProto();
    }

    private YarnProtos.NodeIdProto convertToProtoFormat(NodeId t) {
        return ((NodeIdPBImpl)t).getProto();
    }

    private ResourcePBImpl convertFromProtoFormat(YarnProtos.ResourceProto p) {
        return new ResourcePBImpl(p);
    }

    private YarnProtos.ResourceProto convertToProtoFormat(Resource t) {
        return ProtoUtils.convertToProtoFormat(t);
    }

    private PriorityPBImpl convertFromProtoFormat(YarnProtos.PriorityProto p) {
        return new PriorityPBImpl(p);
    }

    private YarnProtos.PriorityProto convertToProtoFormat(Priority p) {
        return ((PriorityPBImpl)p).getProto();
    }

    private TokenPBImpl convertFromProtoFormat(SecurityProtos.TokenProto p) {
        return new TokenPBImpl(p);
    }

    private SecurityProtos.TokenProto convertToProtoFormat(Token t) {
        return ((TokenPBImpl)t).getProto();
    }

    private ExecutionType convertFromProtoFormat(YarnProtos.ExecutionTypeProto e) {
        return ProtoUtils.convertFromProtoFormat(e);
    }

    private YarnProtos.ExecutionTypeProto convertToProtoFormat(ExecutionType e) {
        return ProtoUtils.convertToProtoFormat(e);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Container: [").append("ContainerId: ").append(this.getId()).append(", ").append("AllocationRequestId: ").append(this.getAllocationRequestId()).append(", ").append("Version: ").append(this.getVersion()).append(", ").append("NodeId: ").append(this.getNodeId()).append(", ").append("NodeHttpAddress: ").append(this.getNodeHttpAddress()).append(", ").append("Resource: ").append(this.getResource()).append(", ").append("Priority: ").append(this.getPriority()).append(", ").append("Token: ").append(this.getContainerToken()).append(", ").append("ExecutionType: ").append((Object)this.getExecutionType()).append(", ").append("]");
        return sb.toString();
    }

    @Override
    public int compareTo(Container other) {
        if (this.getId().compareTo(other.getId()) == 0) {
            if (this.getNodeId().compareTo(other.getNodeId()) == 0) {
                return this.getResource().compareTo(other.getResource());
            }
            return this.getNodeId().compareTo(other.getNodeId());
        }
        return this.getId().compareTo(other.getId());
    }
}

