/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.csi;

import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.shaded.com.google.common.base.Strings;
import org.apache.hadoop.yarn.exceptions.YarnException;

public final class CsiConfigUtils {
    private CsiConfigUtils() {
    }

    public static String[] getCsiDriverNames(Configuration conf) {
        return conf.getStrings("yarn.nodemanager.csi-driver.names");
    }

    public static String getCsiDriverEndpoint(String driverName, Configuration conf) throws YarnException {
        String driverEndpointProperty = "yarn.nodemanager.csi-driver." + driverName + ".endpoint";
        String driverEndpoint = conf.get(driverEndpointProperty);
        if (Strings.isNullOrEmpty((String)driverEndpoint)) {
            throw new YarnException("CSI driver's endpoint is not specified or invalid, property " + driverEndpointProperty + " is not defined");
        }
        return driverEndpoint;
    }

    public static InetSocketAddress getCsiAdaptorAddressForDriver(String driverName, Configuration conf) throws YarnException {
        String configName = "yarn.nodemanager.csi-driver-adaptor." + driverName + ".address";
        String errorMessage = "Failed to load CSI adaptor address for driver " + driverName + ", configuration property " + configName + " is not defined or invalid.";
        try {
            InetSocketAddress address = conf.getSocketAddr(configName, null, -1);
            if (address == null) {
                throw new YarnException(errorMessage);
            }
            return address;
        }
        catch (IllegalArgumentException e) {
            throw new YarnException(errorMessage);
        }
    }
}

