/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.resource;

import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.shaded.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DefaultResourceCalculator
extends ResourceCalculator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultResourceCalculator.class);
    private static final Set<String> INSUFFICIENT_RESOURCE_NAME = ImmutableSet.of((Object)"memory-mb");

    @Override
    public int compare(Resource unused, Resource lhs, Resource rhs, boolean singleType) {
        return Long.compare(lhs.getMemorySize(), rhs.getMemorySize());
    }

    @Override
    public long computeAvailableContainers(Resource available, Resource required) {
        return available.getMemorySize() / required.getMemorySize();
    }

    @Override
    public float divide(Resource unused, Resource numerator, Resource denominator) {
        return this.ratio(numerator, denominator);
    }

    @Override
    public boolean isInvalidDivisor(Resource r) {
        return (float)r.getMemorySize() == 0.0f;
    }

    @Override
    public float ratio(Resource a, Resource b) {
        return DefaultResourceCalculator.divideSafelyAsFloat(a.getMemorySize(), b.getMemorySize());
    }

    @Override
    public Resource divideAndCeil(Resource numerator, int denominator) {
        return Resources.createResource(DefaultResourceCalculator.divideAndCeil(numerator.getMemorySize(), (long)denominator));
    }

    @Override
    public Resource divideAndCeil(Resource numerator, float denominator) {
        return Resources.createResource(DefaultResourceCalculator.divideAndCeil(numerator.getMemorySize(), denominator));
    }

    @Override
    public Resource normalize(Resource r, Resource minimumResource, Resource maximumResource, Resource stepFactor) {
        if (stepFactor.getMemorySize() == 0L) {
            LOG.error("Memory cannot be allocated in increments of zero. Assuming " + minimumResource.getMemorySize() + "MB increment size. Please ensure the scheduler configuration is correct.");
            stepFactor = minimumResource;
        }
        long normalizedMemory = Math.min(DefaultResourceCalculator.roundUp(Math.max(r.getMemorySize(), minimumResource.getMemorySize()), stepFactor.getMemorySize()), maximumResource.getMemorySize());
        return Resources.createResource(normalizedMemory);
    }

    @Override
    public Resource roundUp(Resource r, Resource stepFactor) {
        return Resources.createResource(DefaultResourceCalculator.roundUp(r.getMemorySize(), stepFactor.getMemorySize()));
    }

    @Override
    public Resource roundDown(Resource r, Resource stepFactor) {
        return Resources.createResource(DefaultResourceCalculator.roundDown(r.getMemorySize(), stepFactor.getMemorySize()));
    }

    @Override
    public Resource multiplyAndNormalizeUp(Resource r, double by, Resource stepFactor) {
        return Resources.createResource(DefaultResourceCalculator.roundUp((long)((double)r.getMemorySize() * by + 0.5), stepFactor.getMemorySize()));
    }

    @Override
    public Resource multiplyAndNormalizeUp(Resource r, double[] by, Resource stepFactor) {
        return Resources.createResource(DefaultResourceCalculator.roundUp((long)((double)r.getMemorySize() * by[0] + 0.5), stepFactor.getMemorySize()));
    }

    @Override
    public Resource multiplyAndNormalizeDown(Resource r, double by, Resource stepFactor) {
        return Resources.createResource(DefaultResourceCalculator.roundDown((long)((double)r.getMemorySize() * by), stepFactor.getMemorySize()));
    }

    @Override
    public boolean fitsIn(Resource smaller, Resource bigger) {
        return smaller.getMemorySize() <= bigger.getMemorySize();
    }

    @Override
    public Resource normalizeDown(Resource r, Resource stepFactor) {
        return Resources.createResource(DefaultResourceCalculator.roundDown(r.getMemorySize(), stepFactor.getMemorySize()));
    }

    @Override
    public boolean isAnyMajorResourceZeroOrNegative(Resource resource) {
        return resource.getMemorySize() <= 0L;
    }

    @Override
    public boolean isAnyMajorResourceAboveZero(Resource resource) {
        return resource.getMemorySize() > 0L;
    }

    @Override
    public Set<String> getInsufficientResourceNames(Resource required, Resource available) {
        if (required.getMemorySize() > available.getMemorySize()) {
            return INSUFFICIENT_RESOURCE_NAME;
        }
        return ImmutableSet.of();
    }
}

