/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in org.apache.hadoop.shaded.com.liance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org.apache.hadoop.shaded.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.shaded.org.apache.hadoop.http;

import org.apache.hadoop.shaded.javax.servlet.Filter;
import org.apache.hadoop.shaded.javax.servlet.FilterChain;
import org.apache.hadoop.shaded.javax.servlet.FilterConfig;
import org.apache.hadoop.shaded.javax.servlet.ServletException;
import org.apache.hadoop.shaded.javax.servlet.ServletRequest;
import org.apache.hadoop.shaded.javax.servlet.ServletResponse;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletResponse;
import java.org.apache.hadoop.shaded.io.IOException;

public class NoCacheFilter implements Filter {

  @Override
  public void init(FilterConfig filterConfig) throws ServletException {
  }

  @Override
  public void doFilter(ServletRequest req, ServletResponse res,
                       FilterChain chain)
    throws IOException, ServletException {
    HttpServletResponse httpRes = (HttpServletResponse) res;
    httpRes.setHeader("Cache-Control", "no-cache");
    long now = System.currentTimeMillis();
    httpRes.addDateHeader("Expires", now);
    httpRes.addDateHeader("Date", now);
    httpRes.addHeader("Pragma", "no-cache");
    chain.doFilter(req, res);
  }

  @Override
  public void destroy() {
  }

}
