/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.lib.db.DataDrivenDBInputFormat;
import org.apache.hadoop.mapreduce.lib.db.IntegerSplitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class DateSplitter
extends IntegerSplitter {
    private static final Logger LOG = LoggerFactory.getLogger(DateSplitter.class);

    @Override
    public List<InputSplit> split(Configuration conf, ResultSet results, String colName) throws SQLException {
        int sqlDataType = results.getMetaData().getColumnType(1);
        long minVal = this.resultSetColToLong(results, 1, sqlDataType);
        long maxVal = this.resultSetColToLong(results, 2, sqlDataType);
        String lowClausePrefix = colName + " >= ";
        String highClausePrefix = colName + " < ";
        int numSplits = conf.getInt("mapreduce.job.maps", 1);
        if (numSplits < 1) {
            numSplits = 1;
        }
        if (minVal == Long.MIN_VALUE && maxVal == Long.MIN_VALUE) {
            ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
            splits.add(new DataDrivenDBInputFormat.DataDrivenDBInputSplit(colName + " IS NULL", colName + " IS NULL"));
            return splits;
        }
        List<Long> splitPoints = this.split(numSplits, minVal, maxVal);
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        long start = splitPoints.get(0);
        Date startDate = this.longToDate(start, sqlDataType);
        if (sqlDataType == 93) {
            try {
                ((Timestamp)startDate).setNanos(results.getTimestamp(1).getNanos());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        for (int i = 1; i < splitPoints.size(); ++i) {
            long end = splitPoints.get(i);
            Date endDate = this.longToDate(end, sqlDataType);
            if (i == splitPoints.size() - 1) {
                if (sqlDataType == 93) {
                    try {
                        ((Timestamp)endDate).setNanos(results.getTimestamp(2).getNanos());
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                splits.add(new DataDrivenDBInputFormat.DataDrivenDBInputSplit(lowClausePrefix + this.dateToString(startDate), colName + " <= " + this.dateToString(endDate)));
            } else {
                splits.add(new DataDrivenDBInputFormat.DataDrivenDBInputSplit(lowClausePrefix + this.dateToString(startDate), highClausePrefix + this.dateToString(endDate)));
            }
            start = end;
            startDate = endDate;
        }
        if (minVal == Long.MIN_VALUE || maxVal == Long.MIN_VALUE) {
            splits.add(new DataDrivenDBInputFormat.DataDrivenDBInputSplit(colName + " IS NULL", colName + " IS NULL"));
        }
        return splits;
    }

    private long resultSetColToLong(ResultSet rs, int colNum, int sqlDataType) throws SQLException {
        try {
            switch (sqlDataType) {
                case 91: {
                    return rs.getDate(colNum).getTime();
                }
                case 92: {
                    return rs.getTime(colNum).getTime();
                }
                case 93: {
                    return rs.getTimestamp(colNum).getTime();
                }
            }
            throw new SQLException("Not a date-type field");
        }
        catch (NullPointerException npe) {
            LOG.warn("Encountered a NULL date in the split column. Splits may be poorly balanced.");
            return Long.MIN_VALUE;
        }
    }

    private Date longToDate(long val, int sqlDataType) {
        switch (sqlDataType) {
            case 91: {
                return new java.sql.Date(val);
            }
            case 92: {
                return new Time(val);
            }
            case 93: {
                return new Timestamp(val);
            }
        }
        return null;
    }

    protected String dateToString(Date d) {
        return "'" + d.toString() + "'";
    }
}

