/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.shaded.org.apache.hadoop.hdfs.protocol;

import org.apache.hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.shaded.org.apache.hadoop.classification.InterfaceStability;

/**
 * Rolling upgrade status
 */
@InterfaceAudience.Private
@InterfaceStability.Evolving
public class RollingUpgradeStatus {
  private final String blockPoolId;
  private final boolean finalized;

  public RollingUpgradeStatus(String blockPoolId, boolean finalized) {
    this.blockPoolId = blockPoolId;
    this.finalized = finalized;
  }

  public String getBlockPoolId() {
    return blockPoolId;
  }

  public boolean isFinalized() {
    return finalized;
  }

  @Override
  public int hashCode() {
    return blockPoolId.hashCode();
  }

  @Override
  public boolean equals(Object obj) {
    if (obj == this) {
      return true;
    } else if (!(obj instanceof RollingUpgradeStatus)) {
      return false;
    }
    final RollingUpgradeStatus that = (RollingUpgradeStatus) obj;
    return this.blockPoolId.equals(that.blockPoolId)
        && this.isFinalized() == that.isFinalized();
  }

  @Override
  public String toString() {
    return "  Block Pool ID: " + blockPoolId;
  }
}
