/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hadoop.shaded.org.apache.hadoop.util.functional;

import java.io.IOException;

/**
 * Version of java.util.function.Consumer which raises
 * exceptions.
 * @param <T> type of argument,.
 */
@FunctionalInterface
public interface ConsumerRaisingIOE<T> {

  /**
   * Process the argument.
   * @param t type
   * @throws IOException if needed
   */
  void accept(T t) throws IOException;

  /**
   * after calling {@link #accept(Object)},
   * invoke the next consumer in the chain.
   * @param next next consumer
   * @return the chain.
   */
  default ConsumerRaisingIOE<T> andThen(
      ConsumerRaisingIOE<? super T> next) {
    return (T t) -> {
      accept(t);
      next.accept(t);
    };
  }
}
