/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.shaded.org.apache.hadoop.yarn.api.protocolrecords;

import org.apache.hadoop.shaded.org.apache.hadoop.yarn.util.Records;

/**
 * YARN internal message used to represent the response of
 * volume capabilities validation with a CSI driver controller plugin.
 */
public abstract class ValidateVolumeCapabilitiesResponse {

  public static ValidateVolumeCapabilitiesResponse newInstance(
      boolean supported, String responseMessage) {
    ValidateVolumeCapabilitiesResponse
        record =
        Records.newRecord(
            ValidateVolumeCapabilitiesResponse.class);
    record.setResponseMessage(responseMessage);
    record.setSupported(supported);
    return record;
  }

  public abstract void setSupported(boolean supported);

  public abstract boolean isSupported();

  public abstract void setResponseMessage(String responseMessage);

  public abstract String getResponseMessage();
}
