/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hadoop.shaded.org.apache.hadoop.yarn.client.api.impl;

import java.io.IOException;
import java.net.URI;

import org.apache.hadoop.shaded.org.slf4j.Logger;
import org.apache.hadoop.shaded.org.slf4j.LoggerFactory;
import org.apache.hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience.Private;
import org.apache.hadoop.shaded.org.apache.hadoop.classification.InterfaceStability.Unstable;
import org.apache.hadoop.shaded.org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.shaded.org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.shaded.org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.shaded.org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.shaded.org.apache.hadoop.yarn.api.records.timeline.TimelineEntityGroupId;
import org.apache.hadoop.shaded.org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.shaded.org.apache.hadoop.yarn.exceptions.YarnException;

import org.apache.hadoop.shaded.com.sun.jersey.api.client.Client;

/**
 * A simple writer class for storing Timeline data into Leveldb store.
 */
@Private
@Unstable
public class DirectTimelineWriter extends TimelineWriter{

  private static final Logger LOG = LoggerFactory
      .getLogger(DirectTimelineWriter.class);

  public DirectTimelineWriter(UserGroupInformation authUgi,
      Client client, URI resURI) {
    super(authUgi, client, resURI);
  }

  @Override
  public TimelinePutResponse putEntities(ApplicationAttemptId appAttemptId,
      TimelineEntityGroupId groupId, TimelineEntity... entities)
      throws IOException, YarnException {
    throw new IOException("Not supported");
  }

  @Override
  public void putDomain(ApplicationAttemptId appAttemptId,
      TimelineDomain domain) throws IOException, YarnException {
    throw new IOException("Not supported");
  }

}
