/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hadoop.shaded.org.apache.hadoop.yarn.server.api;

import java.io.IOException;

import org.apache.hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience.Public;
import org.apache.hadoop.shaded.org.apache.hadoop.classification.InterfaceStability.Unstable;
import org.apache.hadoop.shaded.org.apache.hadoop.yarn.server.api.protocolrecords.RunSharedCacheCleanerTaskRequest;
import org.apache.hadoop.shaded.org.apache.hadoop.yarn.server.api.protocolrecords.RunSharedCacheCleanerTaskResponse;
import org.apache.hadoop.shaded.org.apache.hadoop.yarn.exceptions.YarnException;

/**
 * <p>
 * The protocol between administrators and the <code>SharedCacheManager</code>
 * </p>
 */
@Public
@Unstable
public interface SCMAdminProtocol {
  /**
   * <p>
   * The method used by administrators to ask SCM to run cleaner task right away
   * </p>
   *
   * @param request request <code>SharedCacheManager</code> to run a cleaner task
   * @return <code>SharedCacheManager</code> returns an empty response
   *         on success and throws an exception on rejecting the request
   * @throws YarnException exceptions from yarn servers.
   * @throws IOException io error occur.
   */
  @Public
  @Unstable
  public RunSharedCacheCleanerTaskResponse runCleanerTask(
      RunSharedCacheCleanerTaskRequest request) throws YarnException, IOException;
  
}
