/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.shaded.org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb;

import org.apache.hadoop.shaded.org.apache.hadoop.thirdparty.protobuf.TextFormat;
import org.apache.hadoop.shaded.org.apache.hadoop.yarn.proto.YarnServerResourceManagerServiceProtos.BatchSaveFederationQueuePoliciesResponseProto;
import org.apache.hadoop.shaded.org.apache.hadoop.yarn.proto.YarnServerResourceManagerServiceProtos.BatchSaveFederationQueuePoliciesResponseProtoOrBuilder;
import org.apache.hadoop.shaded.org.apache.hadoop.yarn.server.api.protocolrecords.BatchSaveFederationQueuePoliciesResponse;

/**
 * The class is responsible for batch-saving queue policies responses.
 */
public class BatchSaveFederationQueuePoliciesResponsePBImpl
    extends BatchSaveFederationQueuePoliciesResponse {

  private BatchSaveFederationQueuePoliciesResponseProto proto =
      BatchSaveFederationQueuePoliciesResponseProto.getDefaultInstance();
  private BatchSaveFederationQueuePoliciesResponseProto.Builder builder = null;
  private boolean viaProto = false;

  public BatchSaveFederationQueuePoliciesResponsePBImpl() {
    builder = BatchSaveFederationQueuePoliciesResponseProto.newBuilder();
  }

  public BatchSaveFederationQueuePoliciesResponsePBImpl(
      BatchSaveFederationQueuePoliciesResponseProto proto) {
    this.proto = proto;
    viaProto = true;
  }

  @Override
  public int hashCode() {
    return getProto().hashCode();
  }

  @Override
  public boolean equals(Object other) {
    if (other == null) {
      return false;
    }
    if (other.getClass().isAssignableFrom(this.getClass())) {
      return this.getProto().equals(this.getClass().cast(other).getProto());
    }
    return false;
  }

  public BatchSaveFederationQueuePoliciesResponseProto getProto() {
    proto = viaProto ? proto : builder.build();
    viaProto = true;
    return proto;
  }

  @Override
  public String getMessage() {
    BatchSaveFederationQueuePoliciesResponseProtoOrBuilder p = viaProto ? proto : builder;
    boolean hasMessage = p.hasMessage();
    if (hasMessage) {
      return p.getMessage();
    }
    return null;
  }

  @Override
  public void setMessage(String msg) {
    maybeInitBuilder();
    if (msg == null) {
      builder.clearMessage();
      return;
    }
    builder.setMessage(msg);
  }

  private synchronized void maybeInitBuilder() {
    if (viaProto || builder == null) {
      builder = BatchSaveFederationQueuePoliciesResponseProto.newBuilder(proto);
    }
    viaProto = false;
  }

  @Override
  public String toString() {
    return TextFormat.shortDebugString(getProto());
  }
}
