/**
* Licensed to the Apache Software Foundation (ASF) under one
* or more contributor license agreements.  See the NOTICE file
* distributed with this work for additional information
* regarding copyright ownership.  The ASF licenses this file
* to you under the Apache License, Version 2.0 (the
* "License"); you may not use this file except in compliance
* with the License.  You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

package org.apache.hadoop.shaded.org.apache.hadoop.yarn.webapp;

import java.io.IOException;

import org.apache.hadoop.shaded.javax.servlet.RequestDispatcher;
import org.apache.hadoop.shaded.javax.servlet.ServletException;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServlet;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletRequestWrapper;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletResponse;

import org.apache.hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience.Private;

import org.apache.hadoop.shaded.com.google.inject.Singleton;

@InterfaceAudience.LimitedPrivate({"YARN", "MapReduce"})
@Singleton
public class DefaultWrapperServlet extends HttpServlet {

private static final long serialVersionUID = 1L;

@Private
public void doGet(HttpServletRequest req, HttpServletResponse resp)
throws ServletException, IOException {
  RequestDispatcher rd = getServletContext().getNamedDispatcher("default");

  HttpServletRequest wrapped = new HttpServletRequestWrapper(req) {
    public String getServletPath() {
    return "";
    }
  };

  rd.forward(wrapped, resp);
  }

}
