/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.server;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.qjournal.client.QuorumJournalManager;
import org.apache.hadoop.hdfs.qjournal.server.Journal;
import org.apache.hadoop.hdfs.qjournal.server.JournalNodeHttpServer;
import org.apache.hadoop.hdfs.qjournal.server.JournalNodeMXBean;
import org.apache.hadoop.hdfs.qjournal.server.JournalNodeRpcServer;
import org.apache.hadoop.hdfs.qjournal.server.JournalNodeSyncer;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.StorageErrorReporter;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.shaded.com.google.common.collect.Maps;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.ajax.JSON;
import org.apache.hadoop.tracing.TraceUtils;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.htrace.core.Tracer;

@InterfaceAudience.Private
public class JournalNode
implements Tool,
Configurable,
JournalNodeMXBean {
    public static final Log LOG = LogFactory.getLog(JournalNode.class);
    private Configuration conf;
    private JournalNodeRpcServer rpcServer;
    private JournalNodeHttpServer httpServer;
    private final Map<String, Journal> journalsById = Maps.newHashMap();
    private final Map<String, JournalNodeSyncer> journalSyncersById = Maps.newHashMap();
    private ObjectName journalNodeInfoBeanName;
    private String httpServerURI;
    private final ArrayList<File> localDir = Lists.newArrayList();
    Tracer tracer;
    private int resultCode = 0;

    synchronized Journal getOrCreateJournal(String jid, String nameServiceId, HdfsServerConstants.StartupOption startOpt) throws IOException {
        QuorumJournalManager.checkJournalId(jid);
        Journal journal = this.journalsById.get(jid);
        if (journal == null) {
            File logDir = this.getLogDir(jid, nameServiceId);
            LOG.info((Object)("Initializing journal in directory " + logDir));
            journal = new Journal(this.conf, logDir, jid, startOpt, new ErrorReporter());
            this.journalsById.put(jid, journal);
            if (this.conf.getBoolean("dfs.journalnode.enable.sync", false)) {
                this.startSyncer(journal, jid, nameServiceId);
            }
        } else if (this.journalSyncersById.get(jid) != null && !this.journalSyncersById.get(jid).isJournalSyncerStarted() && !this.journalsById.get(jid).getTriedJournalSyncerStartedwithnsId() && nameServiceId != null) {
            this.startSyncer(journal, jid, nameServiceId);
        }
        return journal;
    }

    @VisibleForTesting
    public boolean getJournalSyncerStatus(String jid) {
        if (this.journalSyncersById.get(jid) != null) {
            return this.journalSyncersById.get(jid).isJournalSyncerStarted();
        }
        return false;
    }

    private void startSyncer(Journal journal, String jid, String nameServiceId) {
        JournalNodeSyncer jSyncer = this.journalSyncersById.get(jid);
        if (jSyncer == null) {
            jSyncer = new JournalNodeSyncer(this, journal, jid, this.conf, nameServiceId);
            this.journalSyncersById.put(jid, jSyncer);
        }
        jSyncer.start(nameServiceId);
    }

    @VisibleForTesting
    public Journal getOrCreateJournal(String jid) throws IOException {
        return this.getOrCreateJournal(jid, null, HdfsServerConstants.StartupOption.REGULAR);
    }

    public Journal getOrCreateJournal(String jid, String nameServiceId) throws IOException {
        return this.getOrCreateJournal(jid, nameServiceId, HdfsServerConstants.StartupOption.REGULAR);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        String journalNodeDir = null;
        Collection nameserviceIds = conf.getTrimmedStringCollection("dfs.internal.nameservices");
        if (nameserviceIds.size() == 0) {
            nameserviceIds = conf.getTrimmedStringCollection("dfs.nameservices");
        }
        if (nameserviceIds.size() < 2) {
            for (String nameService : nameserviceIds) {
                journalNodeDir = conf.get("dfs.journalnode.edits.dir." + nameService);
            }
            if (journalNodeDir == null) {
                journalNodeDir = conf.get("dfs.journalnode.edits.dir", "/tmp/hadoop/dfs/journalnode/");
            }
            this.localDir.add(new File(journalNodeDir.trim()));
        }
        if (this.tracer == null) {
            this.tracer = new Tracer.Builder("JournalNode").conf(TraceUtils.wrapHadoopConf((String)"journalnode.htrace", (Configuration)conf)).build();
        }
    }

    private static void validateAndCreateJournalDir(File dir) throws IOException {
        if (!dir.isAbsolute()) {
            throw new IllegalArgumentException("Journal dir '" + dir + "' should be an absolute path");
        }
        DiskChecker.checkDir((File)dir);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public int run(String[] args) throws Exception {
        this.start();
        return this.join();
    }

    public void start() throws IOException {
        Preconditions.checkState((!this.isStarted() ? 1 : 0) != 0, (Object)"JN already running");
        try {
            for (File journalDir : this.localDir) {
                JournalNode.validateAndCreateJournalDir(journalDir);
            }
            DefaultMetricsSystem.initialize((String)"JournalNode");
            JvmMetrics.create((String)"JournalNode", (String)this.conf.get("dfs.metrics.session-id"), (MetricsSystem)DefaultMetricsSystem.instance());
            InetSocketAddress socAddr = JournalNodeRpcServer.getAddress(this.conf);
            SecurityUtil.login((Configuration)this.conf, (String)"dfs.journalnode.keytab.file", (String)"dfs.journalnode.kerberos.principal", (String)socAddr.getHostName());
            this.registerJNMXBean();
            this.httpServer = new JournalNodeHttpServer(this.conf, this, this.getHttpServerBindAddress(this.conf));
            this.httpServer.start();
            this.httpServerURI = this.httpServer.getServerURI().toString();
            this.rpcServer = new JournalNodeRpcServer(this.conf, this);
            this.rpcServer.start();
        }
        catch (IOException ioe) {
            LOG.error((Object)"Failed to start JournalNode.", (Throwable)ioe);
            this.stop(1);
            throw ioe;
        }
    }

    public boolean isStarted() {
        return this.rpcServer != null;
    }

    public InetSocketAddress getBoundIpcAddress() {
        return this.rpcServer.getAddress();
    }

    public String getHttpServerURI() {
        return this.httpServerURI;
    }

    public void stop(int rc) {
        this.resultCode = rc;
        for (JournalNodeSyncer jSyncer : this.journalSyncersById.values()) {
            jSyncer.stopSync();
        }
        if (this.rpcServer != null) {
            this.rpcServer.stop();
        }
        if (this.httpServer != null) {
            try {
                this.httpServer.stop();
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Unable to stop HTTP server for " + this), (Throwable)ioe);
            }
        }
        for (Journal j : this.journalsById.values()) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{j});
        }
        DefaultMetricsSystem.shutdown();
        if (this.journalNodeInfoBeanName != null) {
            MBeans.unregister((ObjectName)this.journalNodeInfoBeanName);
            this.journalNodeInfoBeanName = null;
        }
        if (this.tracer != null) {
            this.tracer.close();
            this.tracer = null;
        }
    }

    int join() throws InterruptedException {
        if (this.rpcServer != null) {
            this.rpcServer.join();
        }
        return this.resultCode;
    }

    public void stopAndJoin(int rc) throws InterruptedException {
        this.stop(rc);
        this.join();
    }

    private File getLogDir(String jid, String nameServiceId) throws IOException {
        File journalDir;
        String dir = null;
        if (nameServiceId != null) {
            dir = this.conf.get("dfs.journalnode.edits.dir." + nameServiceId);
        }
        if (dir == null) {
            dir = this.conf.get("dfs.journalnode.edits.dir", "/tmp/hadoop/dfs/journalnode/");
        }
        if (!this.localDir.contains(journalDir = new File(dir.trim()))) {
            JournalNode.validateAndCreateJournalDir(journalDir);
            this.localDir.add(journalDir);
        }
        Preconditions.checkArgument((jid != null && !jid.isEmpty() ? 1 : 0) != 0, (String)"bad journal identifier: %s", (Object[])new Object[]{jid});
        assert (jid != null);
        return new File(journalDir, jid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJournalsStatus() {
        HashMap status = new HashMap();
        JournalNode journalNode = this;
        synchronized (journalNode) {
            for (Map.Entry<String, Journal> entry : this.journalsById.entrySet()) {
                HashMap<String, String> jMap = new HashMap<String, String>();
                jMap.put("Formatted", Boolean.toString(entry.getValue().isFormatted()));
                status.put(entry.getKey(), jMap);
            }
        }
        for (File jDir : this.localDir) {
            File[] journalDirs = jDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory();
                }
            });
            if (journalDirs == null) continue;
            for (File journalDir : journalDirs) {
                String jid = journalDir.getName();
                if (status.containsKey(jid)) continue;
                HashMap<String, String> jMap = new HashMap<String, String>();
                jMap.put("Formatted", "true");
                status.put(jid, jMap);
            }
        }
        return JSON.toString(status);
    }

    private void registerJNMXBean() {
        this.journalNodeInfoBeanName = MBeans.register((String)"JournalNode", (String)"JournalNodeInfo", (Object)this);
    }

    public static void main(String[] args) throws Exception {
        StringUtils.startupShutdownMessage(JournalNode.class, (String[])args, (Log)LOG);
        try {
            System.exit(ToolRunner.run((Tool)new JournalNode(), (String[])args));
        }
        catch (Throwable e) {
            LOG.error((Object)"Failed to start journalnode.", e);
            ExitUtil.terminate((int)-1, (Throwable)e);
        }
    }

    public void doPreUpgrade(String journalId) throws IOException {
        this.getOrCreateJournal(journalId).doPreUpgrade();
    }

    public void doUpgrade(String journalId, StorageInfo sInfo) throws IOException {
        this.getOrCreateJournal(journalId).doUpgrade(sInfo);
    }

    public void doFinalize(String journalId, String nameServiceId) throws IOException {
        this.getOrCreateJournal(journalId, nameServiceId).doFinalize();
    }

    public Boolean canRollBack(String journalId, StorageInfo storage, StorageInfo prevStorage, int targetLayoutVersion, String nameServiceId) throws IOException {
        return this.getOrCreateJournal(journalId, nameServiceId, HdfsServerConstants.StartupOption.ROLLBACK).canRollBack(storage, prevStorage, targetLayoutVersion);
    }

    public void doRollback(String journalId, String nameServiceId) throws IOException {
        this.getOrCreateJournal(journalId, nameServiceId, HdfsServerConstants.StartupOption.ROLLBACK).doRollback();
    }

    public void discardSegments(String journalId, long startTxId, String nameServiceId) throws IOException {
        this.getOrCreateJournal(journalId, nameServiceId).discardSegments(startTxId);
    }

    public Long getJournalCTime(String journalId, String nameServiceId) throws IOException {
        return this.getOrCreateJournal(journalId, nameServiceId).getJournalCTime();
    }

    @VisibleForTesting
    public Journal getJournal(String jid) {
        return this.journalsById.get(jid);
    }

    public static InetSocketAddress getHttpAddress(Configuration conf) {
        String addr = conf.get("dfs.journalnode.http-address", "0.0.0.0:8480");
        return NetUtils.createSocketAddr((String)addr, (int)8480, (String)"dfs.journalnode.http-address");
    }

    protected InetSocketAddress getHttpServerBindAddress(Configuration configuration) {
        InetSocketAddress bindAddress = JournalNode.getHttpAddress(configuration);
        String bindHost = configuration.getTrimmed("dfs.journalnode.http-bind-host");
        if (bindHost != null && !bindHost.isEmpty()) {
            bindAddress = new InetSocketAddress(bindHost, bindAddress.getPort());
        }
        return bindAddress;
    }

    @VisibleForTesting
    public JournalNodeRpcServer getRpcServer() {
        return this.rpcServer;
    }

    public InetSocketAddress getBoundHttpAddress() {
        return this.httpServer.getAddress();
    }

    public InetSocketAddress getHttpAddress() {
        return this.httpServer.getHttpAddress();
    }

    public InetSocketAddress getHttpsAddress() {
        return this.httpServer.getHttpsAddress();
    }

    static {
        HdfsConfiguration.init();
    }

    private class ErrorReporter
    implements StorageErrorReporter {
        private ErrorReporter() {
        }

        @Override
        public void reportErrorOnFile(File f) {
            LOG.fatal((Object)("Error reported on file " + f + "... exiting"), (Throwable)new Exception());
            JournalNode.this.stop(1);
        }
    }
}

