/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer.planner;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.Step;
import org.apache.hadoop.shaded.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.JavaType;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;

public class NodePlan {
    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
    private List<Step> volumeSetPlans = new LinkedList<Step>();
    private String nodeName;
    private String nodeUUID;
    private int port;
    private long timeStamp;

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public NodePlan() {
    }

    public NodePlan(String datanodeName, int rpcPort) {
        this.nodeName = datanodeName;
        this.port = rpcPort;
    }

    public List<Step> getVolumeSetPlans() {
        return this.volumeSetPlans;
    }

    void addStep(Step nextStep) {
        Preconditions.checkNotNull((Object)nextStep);
        this.volumeSetPlans.add(nextStep);
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public void setVolumeSetPlans(List<Step> volumeSetPlans) {
        this.volumeSetPlans = volumeSetPlans;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setURI(String dataNodeName) {
        this.nodeName = dataNodeName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public static NodePlan parseJson(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (NodePlan)mapper.readValue(json, NodePlan.class);
    }

    public String toJson() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JavaType planType = mapper.constructType(NodePlan.class);
        return mapper.writerFor(planType).writeValueAsString((Object)this);
    }

    public String getNodeUUID() {
        return this.nodeUUID;
    }

    public void setNodeUUID(String nodeUUID) {
        this.nodeUUID = nodeUUID;
    }
}

