/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.codahale.metrics;

import java.lang.management.ManagementFactory;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.hadoop.shaded.com.codahale.metrics.Gauge;

public class JmxAttributeGauge
implements Gauge<Object> {
    private final MBeanServer mBeanServer;
    private final ObjectName objectName;
    private final String attributeName;

    public JmxAttributeGauge(ObjectName objectName, String attributeName) {
        this(ManagementFactory.getPlatformMBeanServer(), objectName, attributeName);
    }

    public JmxAttributeGauge(MBeanServer mBeanServer, ObjectName objectName, String attributeName) {
        this.mBeanServer = mBeanServer;
        this.objectName = objectName;
        this.attributeName = attributeName;
    }

    @Override
    public Object getValue() {
        try {
            return this.mBeanServer.getAttribute(this.objectName, this.attributeName);
        }
        catch (JMException e) {
            return null;
        }
    }
}

